/*
 * Decompiled with CFR 0.152.
 */
package cn.com.szhtkj.tools;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;

public class NumberTool {
    public static final int NUMBER_DDY = 0;
    public static final int NUMBER_BDY = 1;
    public static final int NUMBER_DY = 2;
    public static final int NUMBER_DYDY = 3;
    public static final int NUMBER_XY = 4;
    public static final int NUMBER_XYDY = 5;
    public static final String ZERO_50 = "0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000";
    private static int _defaultDecimals = 8;
    private static String _defaultFloatFmt = "%1$.8f";

    public static int getDefaultDecimals() {
        return _defaultDecimals;
    }

    public static void setDefaultDecimals(int dec) {
        if (_defaultDecimals == dec) {
            return;
        }
        _defaultDecimals = dec;
        _defaultFloatFmt = "%1$. " + _defaultDecimals + "f";
    }

    public static int CmpDouble(double d1, double d2, int dec) {
        long l3 = 1L;
        if (dec == 0) {
            l3 = 1L;
        } else {
            for (int i = 1; i <= dec; ++i) {
                l3 *= 10L;
            }
        }
        long l1 = (long)(d1 * (double)l3);
        long l2 = (long)(d2 * (double)l3);
        if (l1 == l2) {
            return 0;
        }
        if (l1 != l2) {
            return 1;
        }
        if (l1 > l2) {
            return 2;
        }
        if (l1 >= l2) {
            return 3;
        }
        if (l1 < l2) {
            return 4;
        }
        if (l1 <= l2) {
            return 5;
        }
        return -1;
    }

    public static boolean equals(double d1, double d2, int dec) {
        return NumberTool.CmpDouble(d1, d2, dec) == 0;
    }

    public static double round(double anumber, int place) {
        String sValue = String.valueOf(anumber);
        BigDecimal bigValue = new BigDecimal(sValue);
        return bigValue.setScale(place, 4).doubleValue();
    }

    public static String getFormatString(double d, String dec) {
        String val = NumberTool.getNoTailZeroString(d, dec);
        if (val.equals("")) {
            return "";
        }
        double num = Double.valueOf(val);
        int decimals = 0;
        if (dec == null || dec.trim().length() <= 0 || dec.equals("0") || dec.equals("INF")) {
            if (dec != null && (dec.equals("INF") || dec.equals("0"))) {
                double number = Double.parseDouble(NumberTool.getNoTailZeroString(d, dec));
                DecimalFormat df = (DecimalFormat)DecimalFormat.getInstance();
                df.setMaximumFractionDigits(100);
                df.setGroupingSize(3);
                return df.format(number);
            }
            return new Double(num).toString();
        }
        decimals = Integer.parseInt(dec);
        double number = 0.0;
        number = decimals < 0 ? num * Math.pow(10.0, decimals) : num;
        NumberFormat nf = NumberFormat.getInstance();
        int scale = 0;
        if (decimals > 0) {
            scale = decimals;
            nf.setMinimumFractionDigits(scale);
        }
        return nf.format(new BigDecimal(number).setScale(scale, 5));
    }

    public static String getNoTailZeroString(double d, String dec) {
        return NumberTool.getNoTailZeroString(d, dec, false);
    }

    public static String getNoTailZeroString(double d, String dec, boolean keepZeroDec) {
        int pos;
        if (!keepZeroDec && Double.compare(d, 0.0) == 0) {
            return "0";
        }
        String ret = String.format(_defaultFloatFmt, d);
        int decLen = 0;
        if (dec != null && dec.trim().length() > 0 && "INF".compareToIgnoreCase(dec.trim()) != 0) {
            try {
                decLen = Integer.parseInt(dec);
            }
            catch (Exception err) {
                decLen = 0;
            }
        }
        if ((pos = ret.indexOf(".")) >= 0) {
            int len;
            int lenDec = pos + decLen;
            int diff = len - pos;
            if (decLen > 0 && diff == decLen) {
                return ret;
            }
            if (decLen == 0 || decLen < diff) {
                for (len = ret.length() - 1; ret.charAt(len) == '0' && len > lenDec; --len) {
                }
                if (ret.charAt(len) == '.') {
                    --len;
                }
                ret = ret.substring(0, len + 1);
            }
            if (decLen > 0) {
                diff = len - pos;
                if (diff < 0) {
                    ret = ret + "." + ZERO_50.substring(0, decLen > 50 ? 50 : decLen);
                } else if (diff < decLen) {
                    diff = decLen - diff;
                    ret = ret + ZERO_50.substring(0, diff > 50 ? 50 : diff);
                }
            }
        } else if (decLen > 0) {
            ret = ret + "." + ZERO_50.substring(0, decLen > 50 ? 50 : decLen);
        }
        return ret;
    }
}

