/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.util.test;

import xjyb.org.bjca.util.test.Test;
import xjyb.org.bjca.util.test.TestResult;

public class SimpleTestResult
implements TestResult {
    private static final String SEPARATOR = System.getProperty("line.separator");
    private boolean success;
    private String message;
    private Throwable exception;

    public SimpleTestResult(boolean success, String message) {
        this.success = success;
        this.message = message;
    }

    public SimpleTestResult(boolean success, String message, Throwable exception) {
        this.success = success;
        this.message = message;
        this.exception = exception;
    }

    public static TestResult successful(Test test2, String message) {
        return new SimpleTestResult(true, test2.getName() + ": " + message);
    }

    public static TestResult failed(Test test2, String message) {
        return new SimpleTestResult(false, test2.getName() + ": " + message);
    }

    public static TestResult failed(Test test2, String message, Throwable t) {
        return new SimpleTestResult(false, test2.getName() + ": " + message, t);
    }

    public static TestResult failed(Test test2, String message, Object expected, Object found) {
        return SimpleTestResult.failed(test2, message + SEPARATOR + "Expected: " + expected + SEPARATOR + "Found   : " + found);
    }

    public static String failedMessage(String algorithm, String testName, String expected, String actual) {
        StringBuffer sb = new StringBuffer(algorithm);
        sb.append(" failing ").append(testName);
        sb.append(SEPARATOR).append("    expected: ").append(expected);
        sb.append(SEPARATOR).append("    got     : ").append(actual);
        return sb.toString();
    }

    @Override
    public boolean isSuccessful() {
        return this.success;
    }

    @Override
    public String toString() {
        return this.message;
    }

    @Override
    public Throwable getException() {
        return this.exception;
    }
}

