/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.jce;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CRL;
import java.security.cert.CRLException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509CRL;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;
import java.util.TimeZone;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERBoolean;
import xjyb.org.bjca.asn1.DERConstructedSequence;
import xjyb.org.bjca.asn1.DERConstructedSet;
import xjyb.org.bjca.asn1.DERGeneralizedTime;
import xjyb.org.bjca.asn1.DERInputStream;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DEROutputStream;
import xjyb.org.bjca.asn1.DERTaggedObject;
import xjyb.org.bjca.asn1.DERUTCTime;
import xjyb.org.bjca.asn1.pkcs.IssuerAndSerialNumber;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.fastparser.FX509Certificate;
import xjyb.org.bjca.jce.fastparser.Item;
import xjyb.org.bjca.jce.fastparser.timestamp.FastTimeStamp;
import xjyb.org.bjca.jce.interfaces.P11Interface;
import xjyb.org.bjca.jce.interfaces.TimeStampInterface;
import xjyb.org.bjca.jce.provider.X509CRLObjectFP;
import xjyb.org.bjca.jce.provider.X509CertificateObjectFP;

public class TimeStamp
implements PKCSObjectIdentifiers,
TimeStampInterface {
    int version;
    int signerversion;
    Set digestalgos;
    Collection certs;
    Collection crls;
    X509Certificate signCert;
    byte[] signCertByte;
    byte[] encryptedDigest;
    byte[] timeStampOriginalData;
    String digestAlgorithm;
    String digestEncryptionAlgorithm;
    Signature sig;
    transient PrivateKey privKey;
    byte[] contentData;
    private byte[] finalOriginalData = null;
    Date signDate;
    private byte[] originalHashByte = null;
    private byte[] timeByte = null;
    private String serialNumber = null;
    byte[] signCertTBS;
    DERObject[] certsEncoded;
    Hashtable isAndsns;
    static final String ID_PKCS7_DATA = "1.2.840.113549.1.7.1";
    static final String ID_PKCS7_SIGNED_DATA = "1.2.840.113549.1.7.2";
    static final String ID_TimeStamping = "1.3.6.1.5.5.7.3.8";
    static final String ID_ct_TSTInfo = "1.2.840.113549.1.9.16.1.4";
    static final String ID_ts_contentType = "1.2.840.113549.1.9.3";
    static final String ID_ts_messageDigest = "1.2.840.113549.1.9.4";
    static final String ID_ts_signingTime = "1.2.840.113549.1.9.5";
    static final String ID_MD5 = "1.2.840.113549.2.5";
    static final String ID_MD2 = "1.2.840.113549.2.2";
    static final String ID_SHA1 = "1.3.14.3.2.26";
    static final String ID_RSA = "1.2.840.113549.1.1.1";
    static final String ID_DSA = "1.2.840.10040.4.1";
    static final String ID_SHA224 = "2.16.840.1.101.3.4.2.4";
    static final String ID_SHA256 = "2.16.840.1.101.3.4.2.1";
    static final String ID_SHA384 = "2.16.840.1.101.3.4.2.2";
    static final String ID_SHA512 = "2.16.840.1.101.3.4.2.3";
    static final String ID_RC4 = "1.2.840.113549.3.4";
    static final String ID_DES = "1.3.14.3.2.7";
    static final String ID_DESEDE = "1.2.840.113549.3.7";
    static final String ID_RC2 = "1.2.840.113549.3.2";
    static final String ID_AES = "2.16.840.1.101.3.4.2";
    static final int MD5 = 1;
    static final int MD2 = 2;
    static final int SHA1 = 3;
    static final int RSA = 4;
    static final int DSA = 5;
    static final int SHA224 = 6;
    static final int SHA256 = 7;
    static final int SHA384 = 8;
    static final int SHA512 = 9;
    static final int RC4 = 10;
    static final int DES = 11;
    static final int DESEDE = 12;
    static final int RC2 = 13;
    static final int AES = 14;
    static String[] algArray = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "DESEDE", "RC2", "AES"};
    static String[] algArray2 = new String[]{"MD5", "MD2", "SHA1", "RSA", "DSA", "SHA224", "SHA256", "SHA384", "SHA512", "RC4", "DES", "3DES", "RC2", "AES"};
    static HashMap algmap = null;
    byte[] bsPKCS7 = null;
    FastTimeStamp fxPKCS7 = null;
    String provider = "";

    public TimeStamp() {
    }

    public byte[] createRequest(byte[] originalHashData) throws IOException {
        DERConstructedSequence requestSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERConstructedSequence requestContent = new DERConstructedSequence();
        DERConstructedSequence contentTypeSeq = new DERConstructedSequence();
        DERObjectIdentifier contentType = new DERObjectIdentifier(ID_SHA1);
        contentTypeSeq.addObject(contentType);
        DEROctetString originalHash = null;
        if (originalHashData != null) {
            originalHash = new DEROctetString(originalHashData);
        }
        requestContent.addObject(contentType);
        requestContent.addObject(originalHash);
        DERBoolean isContainCert = new DERBoolean(true);
        requestSequence.addObject(version);
        requestSequence.addObject(requestContent);
        requestSequence.addObject(isContainCert);
        return requestSequence.getEncoded();
    }

    public byte[] createRequest(byte[] originalHashData, long hashAlg) throws IOException {
        DERConstructedSequence requestSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERConstructedSequence requestContent = new DERConstructedSequence();
        DERConstructedSequence contentTypeSeq = new DERConstructedSequence();
        DERObjectIdentifier contentType = null;
        contentType = 2L == hashAlg ? new DERObjectIdentifier(ID_SHA256) : new DERObjectIdentifier(ID_SHA1);
        contentTypeSeq.addObject(contentType);
        DEROctetString originalHash = null;
        if (originalHashData != null) {
            originalHash = new DEROctetString(originalHashData);
        }
        requestContent.addObject(contentType);
        requestContent.addObject(originalHash);
        DERBoolean isContainCert = new DERBoolean(true);
        requestSequence.addObject(version);
        requestSequence.addObject(requestContent);
        requestSequence.addObject(isContainCert);
        return requestSequence.getEncoded();
    }

    public TimeStamp(byte[] in) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        this(in, "BC");
    }

    public TimeStamp(byte[] in, String provider) throws SecurityException, CRLException, InvalidKeyException, CertificateException, NoSuchProviderException, NoSuchAlgorithmException, SignatureException {
        this.fxPKCS7 = new FastTimeStamp();
        this.fxPKCS7.pkcs7Data(in);
        this.provider = provider;
        this.bsPKCS7 = in;
        ArrayList alCerts = this.fxPKCS7.getCerts();
        this.certs = new ArrayList();
        this.certsEncoded = new DERObject[alCerts.size()];
        for (int i = 0; i < alCerts.size(); ++i) {
            Item itCert = (Item)alCerts.get(i);
            byte[] bsCert = new byte[itCert.length + itCert.tagsize];
            System.arraycopy(this.bsPKCS7, itCert.offset - itCert.tagsize, bsCert, 0, bsCert.length);
            this.certs.add(new X509CertificateObjectFP(bsCert));
            ASN1InputStream ains = new ASN1InputStream(new ByteArrayInputStream(bsCert));
            try {
                ASN1Sequence derCert = (ASN1Sequence)ains.readObject();
                this.certsEncoded[i] = derCert;
                continue;
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        ArrayList alCrls = this.fxPKCS7.getCrls();
        this.crls = new ArrayList();
        for (int i = 0; i < alCrls.size(); ++i) {
            Item itCrl = (Item)alCrls.get(i);
            byte[] bsCrl = new byte[itCrl.length + itCrl.tagsize];
            System.arraycopy(this.bsPKCS7, itCrl.offset - itCrl.tagsize, bsCrl, 0, bsCrl.length);
            try {
                this.crls.add(new X509CRLObjectFP(bsCrl));
                continue;
            }
            catch (CRLException e) {
                e.printStackTrace();
            }
        }
        Item signCertItem = this.fxPKCS7.getSignCert();
        this.signCertByte = DerUtil.getItemDataAndTag(this.bsPKCS7, signCertItem);
        if (this.signCertByte.length != 0) {
            this.signCert = new X509CertificateObjectFP(this.signCertByte);
            this.signCertTBS = this.signCert.getTBSCertificate();
            Item item = this.fxPKCS7.getSignCert();
            byte[] bs = new byte[item.length];
            System.arraycopy(in, item.offset, bs, 0, item.length);
            FX509Certificate fx = new FX509Certificate();
            fx.parse(bs, 0, bs.length);
        }
        ArrayList daAl = this.fxPKCS7.getDigestAlgorithms();
        this.digestalgos = new HashSet();
        for (int i = 0; i < daAl.size(); ++i) {
            Item daItem = (Item)daAl.get(i);
            byte[] ds = DerUtil.getItemDataAndTag(this.bsPKCS7, daItem);
            ASN1InputStream a = new ASN1InputStream(ds);
            ASN1Sequence asn = null;
            try {
                DERObject obj = a.readObject();
                asn = (ASN1Sequence)obj;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            DERObjectIdentifier o = (DERObjectIdentifier)asn.getObjectAt(0);
            this.digestalgos.add(o.getId());
        }
        this.version = this.fxPKCS7.getVersion();
        this.signerversion = this.fxPKCS7.getSignInfoVersion();
        Item rawDataItem = this.fxPKCS7.getRawData();
        this.contentData = DerUtil.getItemData(this.bsPKCS7, rawDataItem);
        this.originalHashByte = this.fxPKCS7.getOriginalHashByte();
        this.timeByte = this.fxPKCS7.getTimeByte();
        this.serialNumber = this.fxPKCS7.getIssuerAndSerialNum().getSerialNumber().getSerialNumber().toString(16);
        Item digestItem = this.fxPKCS7.getDigest();
        this.encryptedDigest = DerUtil.getItemData(this.bsPKCS7, digestItem);
        this.digestAlgorithm = this.fxPKCS7.getDigestAlgorithm();
        this.digestEncryptionAlgorithm = this.fxPKCS7.getDigestEncryptionAlgorithm();
        Item authenticateAttrItem = this.fxPKCS7.getAuthenticatedAttributes();
        byte[] authenticateAttriByte = DerUtil.getItemData(this.bsPKCS7, authenticateAttrItem);
        int len = authenticateAttriByte.length;
        ArrayList lenList = DerUtil.getLengthDer(len);
        int addLen = lenList.size();
        this.finalOriginalData = new byte[len + 1 + addLen];
        this.finalOriginalData[0] = 49;
        for (int i = 0; i < addLen; ++i) {
            this.finalOriginalData[i + 1] = (byte)Integer.parseInt((String)lenList.get(i));
        }
        System.arraycopy(authenticateAttriByte, 0, this.finalOriginalData, addLen + 1, len);
    }

    public TimeStamp(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, hashAlgorithm, "BC");
    }

    public TimeStamp(PrivateKey privKey, Certificate[] certChain, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        this(privKey, certChain, null, hashAlgorithm, provider);
    }

    public TimeStamp(PrivateKey privKey, Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int i;
        this.privKey = privKey;
        if (hashAlgorithm.equals("MD5")) {
            this.digestAlgorithm = ID_MD5;
        } else if (hashAlgorithm.equals("MD2")) {
            this.digestAlgorithm = ID_MD2;
        } else if (hashAlgorithm.equals("SHA")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA1")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA224")) {
            this.digestAlgorithm = ID_SHA224;
        } else if (hashAlgorithm.equals("SHA256")) {
            this.digestAlgorithm = ID_SHA256;
        } else if (hashAlgorithm.equals("ID_SHA384")) {
            this.digestAlgorithm = ID_SHA384;
        } else if (hashAlgorithm.equals("ID_SHA512")) {
            this.digestAlgorithm = ID_SHA512;
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        for (i = 0; i < certChain.length; ++i) {
            this.certs.add(certChain[i]);
        }
        if (crlList != null) {
            for (i = 0; i < crlList.length; ++i) {
                this.crls.add(crlList[i]);
            }
        }
        this.digestEncryptionAlgorithm = privKey.getAlgorithm();
        if (this.digestEncryptionAlgorithm.equals("RSA")) {
            this.digestEncryptionAlgorithm = ID_RSA;
        } else if (this.digestEncryptionAlgorithm.equals("DSA")) {
            this.digestEncryptionAlgorithm = ID_DSA;
        } else {
            throw new NoSuchAlgorithmException("Unknown Key Algorithm " + this.digestEncryptionAlgorithm);
        }
        this.sig = Signature.getInstance(this.getDigestAlgorithm(), provider);
        this.sig.initSign(privKey);
    }

    public TimeStamp(Certificate[] certChain, CRL[] crlList, String hashAlgorithm, String provider) throws SecurityException, InvalidKeyException, NoSuchProviderException, NoSuchAlgorithmException {
        int i;
        if (hashAlgorithm.equals("MD5")) {
            this.digestAlgorithm = ID_MD5;
        } else if (hashAlgorithm.equals("MD2")) {
            this.digestAlgorithm = ID_MD2;
        } else if (hashAlgorithm.equals("SHA")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA1")) {
            this.digestAlgorithm = ID_SHA1;
        } else if (hashAlgorithm.equals("SHA224")) {
            this.digestAlgorithm = ID_SHA224;
        } else if (hashAlgorithm.equals("SHA256")) {
            this.digestAlgorithm = ID_SHA256;
        } else if (hashAlgorithm.equals("ID_SHA384")) {
            this.digestAlgorithm = ID_SHA384;
        } else if (hashAlgorithm.equals("ID_SHA512")) {
            this.digestAlgorithm = ID_SHA512;
        } else {
            throw new NoSuchAlgorithmException("Unknown Hash Algorithm " + hashAlgorithm);
        }
        this.signerversion = 1;
        this.version = 1;
        this.certs = new ArrayList();
        this.crls = new ArrayList();
        this.digestalgos = new HashSet();
        this.digestalgos.add(this.digestAlgorithm);
        this.signCert = (X509Certificate)certChain[0];
        for (i = 0; i < certChain.length; ++i) {
            this.certs.add(certChain[i]);
        }
        if (crlList != null) {
            for (i = 0; i < crlList.length; ++i) {
                this.crls.add(crlList[i]);
            }
        }
        this.digestEncryptionAlgorithm = ID_RSA;
    }

    private static String getAlgName(String oid) {
        String name = null;
        if (algmap.containsKey(oid)) {
            name = algmap.get(oid).toString();
        }
        return name;
    }

    private static String getAlgName(int alg) {
        String name = null;
        name = algArray[alg - 1];
        return name;
    }

    private static int getAlgID(String alg) {
        int id = 0;
        int i = 0;
        int loop = algArray2.length;
        if (i < loop && alg.equalsIgnoreCase(algArray2[i])) {
            id = i + 1;
        }
        return id;
    }

    public String getDigestAlgorithm() {
        String da = this.digestAlgorithm;
        String dea = this.digestEncryptionAlgorithm;
        if (this.digestAlgorithm.equals(ID_MD5)) {
            da = "MD5";
        } else if (this.digestAlgorithm.equals(ID_MD2)) {
            da = "MD2";
        } else if (this.digestAlgorithm.equals(ID_SHA1)) {
            da = "SHA1";
        } else if (this.digestAlgorithm.equals(ID_SHA224)) {
            da = "SHA224";
        } else if (this.digestAlgorithm.equals(ID_SHA256)) {
            da = "SHA256";
        } else if (this.digestAlgorithm.equals(ID_SHA384)) {
            da = "SHA384";
        } else if (this.digestAlgorithm.equals(ID_SHA512)) {
            da = "SHA512";
        }
        if (this.digestEncryptionAlgorithm.equals(ID_RSA)) {
            dea = "RSA";
        } else if (this.digestEncryptionAlgorithm.equals(ID_DSA)) {
            dea = "DSA";
        }
        return da + "with" + dea;
    }

    @Override
    public String getHashDigestAlg() {
        String da = this.digestAlgorithm;
        if (this.digestAlgorithm.equals(ID_MD5)) {
            da = "MD5";
        } else if (this.digestAlgorithm.equals(ID_MD2)) {
            da = "MD2";
        } else if (this.digestAlgorithm.equals(ID_SHA1)) {
            da = "SHA1";
        } else if (this.digestAlgorithm.equals(ID_SHA224)) {
            da = "SHA224";
        } else if (this.digestAlgorithm.equals(ID_SHA256)) {
            da = "SHA256";
        } else if (this.digestAlgorithm.equals(ID_SHA384)) {
            da = "SHA384";
        } else if (this.digestAlgorithm.equals(ID_SHA512)) {
            da = "SHA512";
        }
        return da;
    }

    public void reset() {
        try {
            if (this.privKey == null) {
                this.sig.initVerify(this.signCert.getPublicKey());
            } else {
                this.sig.initSign(this.privKey);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public Certificate[] getCertificates() {
        return this.certs.toArray(new X509Certificate[0]);
    }

    public Collection getCRLs() {
        return this.crls;
    }

    public X509Certificate getSigningCertificate() {
        return this.signCert;
    }

    @Override
    public byte[] getSignCertByte() {
        return this.signCertByte;
    }

    public int getVersion() {
        return this.version;
    }

    public int getSigningInfoVersion() {
        return this.signerversion;
    }

    public byte[] getContentData() {
        return this.contentData;
    }

    public byte[] getSignValue() {
        return this.encryptedDigest;
    }

    public byte[] getSignCertTBS() {
        return this.signCertTBS;
    }

    public DERObject[] getCertEncoded() {
        return this.certsEncoded;
    }

    public void update(byte buf) throws SignatureException {
        this.sig.update(buf);
    }

    public void updateRequest(byte[] request) throws IOException {
        ASN1InputStream requestStream = new ASN1InputStream(request);
        DERObject requestObj = requestStream.readObject();
        ASN1Sequence requestSeq = (ASN1Sequence)requestObj;
        ASN1Sequence originalHashDataContent = (ASN1Sequence)requestSeq.getObjectAt(1);
        BigInteger serialNum = new BigInteger("100000001");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        TimeZone tz = TimeZone.getTimeZone("Zulu");
        dateformat.setTimeZone(tz);
        this.signDate = new Date();
        String nowTime = dateformat.format(this.signDate);
        DERConstructedSequence timeStampOriginalDataSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERObjectIdentifier contentType = new DERObjectIdentifier(ID_TimeStamping);
        DERInteger serialNumInt = new DERInteger(serialNum);
        DERGeneralizedTime generalizedTime = new DERGeneralizedTime(nowTime);
        timeStampOriginalDataSequence.addObject(version);
        timeStampOriginalDataSequence.addObject(contentType);
        timeStampOriginalDataSequence.addObject(originalHashDataContent);
        timeStampOriginalDataSequence.addObject(serialNumInt);
        timeStampOriginalDataSequence.addObject(generalizedTime);
        this.timeStampOriginalData = timeStampOriginalDataSequence.getEncoded();
    }

    public void update(byte[] digest, int off, int len) throws SignatureException, IOException {
        BigInteger serialNum = new BigInteger("100000001");
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
        TimeZone tz = TimeZone.getTimeZone("Zulu");
        dateformat.setTimeZone(tz);
        this.signDate = new Date();
        String nowTime = dateformat.format(this.signDate);
        DERConstructedSequence timeStampOriginalDataSequence = new DERConstructedSequence();
        DERInteger version = new DERInteger(1);
        DERObjectIdentifier contentType = new DERObjectIdentifier(ID_TimeStamping);
        DERConstructedSequence originalHashDataContent = new DERConstructedSequence();
        DERConstructedSequence hashTypeSeq = new DERConstructedSequence();
        DERObjectIdentifier hashType = new DERObjectIdentifier(this.digestAlgorithm);
        hashTypeSeq.addObject(hashType);
        DEROctetString originalHash = null;
        if (digest != null) {
            originalHash = new DEROctetString(digest);
        }
        originalHashDataContent.addObject(hashTypeSeq);
        originalHashDataContent.addObject(originalHash);
        DERInteger serialNumInt = new DERInteger(serialNum);
        DERGeneralizedTime generalizedTime = new DERGeneralizedTime(nowTime);
        timeStampOriginalDataSequence.addObject(version);
        timeStampOriginalDataSequence.addObject(contentType);
        timeStampOriginalDataSequence.addObject(originalHashDataContent);
        timeStampOriginalDataSequence.addObject(serialNumInt);
        timeStampOriginalDataSequence.addObject(generalizedTime);
        this.timeStampOriginalData = timeStampOriginalDataSequence.getEncoded();
    }

    public boolean verify(byte[] cert) throws SignatureException, NoSuchAlgorithmException, InvalidKeyException, CertificateException {
        this.sig = Signature.getInstance(this.getDigestAlgorithm());
        if (cert == null) {
            this.sig.initVerify(this.signCert.getPublicKey());
        } else {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate x509Cert = (X509Certificate)oCf.generateCertificate(ois);
            this.sig.initVerify(x509Cert.getPublicKey());
        }
        this.sig.update(this.finalOriginalData);
        return this.sig.verify(this.encryptedDigest);
    }

    private DERObject getIssuer(byte[] enc) {
        try {
            DERInputStream in = new DERInputStream(new ByteArrayInputStream(enc));
            DERConstructedSequence seq = (DERConstructedSequence)in.readObject();
            return (DERObject)seq.getObjectAt(seq.getObjectAt(0) instanceof DERTaggedObject ? 3 : 2);
        }
        catch (IOException e) {
            throw new Error("IOException reading from ByteArray: " + e);
        }
    }

    public byte[] getEncoded(boolean isAttachCert) {
        try {
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier(ID_ct_TSTInfo));
            DEROctetString octets = new DEROctetString(this.timeStampOriginalData);
            DERTaggedObject tagged = new DERTaggedObject(0, octets);
            contentinfo.addObject(tagged);
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            DERConstructedSequence contentinfo1 = new DERConstructedSequence();
            DERObjectIdentifier contentTypeIden = new DERObjectIdentifier(ID_ts_contentType);
            DERObjectIdentifier tstInfoIden = new DERObjectIdentifier(ID_ct_TSTInfo);
            DERConstructedSet tstInfoSet = new DERConstructedSet();
            tstInfoSet.addObject(tstInfoIden);
            contentinfo1.addObject(contentTypeIden);
            contentinfo1.addObject(tstInfoSet);
            DERConstructedSequence contentinfo2 = new DERConstructedSequence();
            DERObjectIdentifier signingTimeIden = new DERObjectIdentifier(ID_ts_signingTime);
            DERConstructedSet utcTimeSet = new DERConstructedSet();
            DERUTCTime utcTime = new DERUTCTime(this.signDate);
            utcTimeSet.addObject(utcTime);
            contentinfo2.addObject(signingTimeIden);
            contentinfo2.addObject(utcTimeSet);
            DERConstructedSequence contentinfo3 = new DERConstructedSequence();
            DERObjectIdentifier tsDigestIden = new DERObjectIdentifier(ID_ts_messageDigest);
            DERConstructedSet digestSet = new DERConstructedSet();
            MessageDigest md = MessageDigest.getInstance(this.getHashDigestAlg());
            md.update(this.timeStampOriginalData);
            byte[] tsInfoDigest = md.digest();
            DEROctetString tsInfoDigestStr = new DEROctetString(tsInfoDigest);
            digestSet.addObject(tsInfoDigestStr);
            contentinfo3.addObject(tsDigestIden);
            contentinfo3.addObject(digestSet);
            DERConstructedSet tobeSignedOriginalSet = new DERConstructedSet();
            tobeSignedOriginalSet.addObject(contentinfo1);
            tobeSignedOriginalSet.addObject(contentinfo2);
            tobeSignedOriginalSet.addObject(contentinfo3);
            byte[] tobeSignedOriginalDataByte = tobeSignedOriginalSet.getEncoded();
            byte[] tobeWriteOrigianlDataByte = (byte[])tobeSignedOriginalDataByte.clone();
            tobeWriteOrigianlDataByte[0] = -96;
            ByteArrayInputStream tobeWriteArrayIn = new ByteArrayInputStream(tobeWriteOrigianlDataByte);
            ASN1InputStream tobeWriteIn = new ASN1InputStream(tobeWriteArrayIn);
            DERObject tobeWriteDer = tobeWriteIn.readObject();
            signerinfo.addObject(tobeWriteDer);
            this.sig.update(tobeSignedOriginalDataByte);
            if (null == this.encryptedDigest) {
                this.encryptedDigest = this.sig.sign();
            }
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.encryptedDigest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            if (isAttachCert) {
                body.addObject(new DERTaggedObject(false, 0, dercertificates));
            }
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier(ID_PKCS7_SIGNED_DATA));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    public byte[] getEncoded(P11Interface p11Impl, byte[] _contentData, String m_keyType, String m_container) throws Exception {
        if (null == this.encryptedDigest) {
            this.encryptedDigest = p11Impl.signByRsaSha1(_contentData, m_container, Integer.parseInt(m_keyType));
        }
        try {
            DERConstructedSet algos = new DERConstructedSet();
            Iterator i = this.digestalgos.iterator();
            while (i.hasNext()) {
                AlgorithmIdentifier a = new AlgorithmIdentifier(new DERObjectIdentifier((String)i.next()), null);
                algos.addObject(a);
            }
            DERConstructedSequence contentinfo = new DERConstructedSequence();
            contentinfo.addObject(new DERObjectIdentifier(ID_PKCS7_DATA));
            if (_contentData != null) {
                DEROctetString octets = new DEROctetString(_contentData);
                DERTaggedObject tagged = new DERTaggedObject(0, octets);
                contentinfo.addObject(tagged);
            }
            DERConstructedSet dercertificates = new DERConstructedSet();
            Iterator i2 = this.certs.iterator();
            while (i2.hasNext()) {
                DERInputStream tempstream = new DERInputStream(new ByteArrayInputStream(((X509Certificate)i2.next()).getEncoded()));
                dercertificates.addObject(tempstream.readObject());
            }
            DERConstructedSequence signerinfo = new DERConstructedSequence();
            signerinfo.addObject(new DERInteger(this.signerversion));
            byte[] bsIssuer = this.signCert.getIssuerX500Principal().getEncoded();
            ASN1InputStream ans = new ASN1InputStream(bsIssuer);
            ASN1Sequence issuer = (ASN1Sequence)ans.readObject();
            IssuerAndSerialNumber isAnds = new IssuerAndSerialNumber(new X509Name(issuer), new DERInteger(this.signCert.getSerialNumber()));
            signerinfo.addObject(isAnds);
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestAlgorithm), null));
            signerinfo.addObject(new AlgorithmIdentifier(new DERObjectIdentifier(this.digestEncryptionAlgorithm), null));
            signerinfo.addObject(new DEROctetString(this.encryptedDigest));
            DERConstructedSequence body = new DERConstructedSequence();
            body.addObject(new DERInteger(this.version));
            body.addObject(algos);
            body.addObject(contentinfo);
            body.addObject(new DERTaggedObject(false, 0, dercertificates));
            if (this.crls.size() > 0) {
                DERConstructedSet dercrls = new DERConstructedSet();
                Iterator i3 = this.crls.iterator();
                while (i3.hasNext()) {
                    DERInputStream t = new DERInputStream(new ByteArrayInputStream(((X509CRL)i3.next()).getEncoded()));
                    dercrls.addObject(t.readObject());
                }
                body.addObject(new DERTaggedObject(false, 1, dercrls));
            }
            DERConstructedSet signerinfos = new DERConstructedSet();
            signerinfos.addObject(signerinfo);
            body.addObject(signerinfos);
            DERConstructedSequence whole = new DERConstructedSequence();
            whole.addObject(new DERObjectIdentifier(ID_PKCS7_SIGNED_DATA));
            whole.addObject(new DERTaggedObject(0, body));
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            DEROutputStream dout = new DEROutputStream(bOut);
            dout.writeObject(whole);
            dout.close();
            return bOut.toByteArray();
        }
        catch (Exception e) {
            throw new RuntimeException(e.toString());
        }
    }

    @Override
    public byte[] getOriginalHashByte() {
        return this.originalHashByte;
    }

    @Override
    public byte[] getTimeByte() {
        return this.timeByte;
    }

    @Override
    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    @Override
    public byte[] getAccuracy() {
        return null;
    }

    static {
        algmap = new HashMap();
        algmap.put(ID_MD5, "MD5");
        algmap.put(ID_MD2, "MD2");
        algmap.put(ID_SHA1, "SHA1");
        algmap.put(ID_RSA, "RSA");
        algmap.put(ID_DSA, "DSA");
        algmap.put(ID_SHA224, "SHA224");
        algmap.put(ID_SHA256, "SHA256");
        algmap.put(ID_SHA384, "SHA384");
        algmap.put(ID_SHA512, "SHA512");
        algmap.put(ID_RC4, "RC4");
        algmap.put(ID_DES, "DES");
        algmap.put(ID_DESEDE, "DESEDE");
        algmap.put(ID_RC2, "RC2");
        algmap.put(ID_AES, "AES");
    }
}

