/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.util;

import java.io.IOException;
import java.io.InputStream;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Object;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.nist.NISTNamedCurves;
import xjyb.org.bjca.asn1.oiw.ElGamalParameter;
import xjyb.org.bjca.asn1.oiw.OIWObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.DHParameter;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.pkcs.PrivateKeyInfo;
import xjyb.org.bjca.asn1.pkcs.RSAPrivateKeyStructure;
import xjyb.org.bjca.asn1.sec.ECPrivateKeyStructure;
import xjyb.org.bjca.asn1.sec.SECNamedCurves;
import xjyb.org.bjca.asn1.teletrust.TeleTrusTNamedCurves;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.DSAParameter;
import xjyb.org.bjca.asn1.x9.X962NamedCurves;
import xjyb.org.bjca.asn1.x9.X962Parameters;
import xjyb.org.bjca.asn1.x9.X9ECParameters;
import xjyb.org.bjca.asn1.x9.X9ObjectIdentifiers;
import xjyb.org.bjca.crypto.params.AsymmetricKeyParameter;
import xjyb.org.bjca.crypto.params.DHParameters;
import xjyb.org.bjca.crypto.params.DHPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.DSAParameters;
import xjyb.org.bjca.crypto.params.DSAPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ECDomainParameters;
import xjyb.org.bjca.crypto.params.ECPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.ElGamalParameters;
import xjyb.org.bjca.crypto.params.ElGamalPrivateKeyParameters;
import xjyb.org.bjca.crypto.params.RSAPrivateCrtKeyParameters;

public class PrivateKeyFactory {
    public static AsymmetricKeyParameter createKey(byte[] privateKeyInfoData) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(ASN1Object.fromByteArray(privateKeyInfoData)));
    }

    public static AsymmetricKeyParameter createKey(InputStream inStr) throws IOException {
        return PrivateKeyFactory.createKey(PrivateKeyInfo.getInstance(new ASN1InputStream(inStr).readObject()));
    }

    public static AsymmetricKeyParameter createKey(PrivateKeyInfo keyInfo) throws IOException {
        AlgorithmIdentifier algId = keyInfo.getAlgorithmId();
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.rsaEncryption)) {
            RSAPrivateKeyStructure keyStructure = new RSAPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new RSAPrivateCrtKeyParameters(keyStructure.getModulus(), keyStructure.getPublicExponent(), keyStructure.getPrivateExponent(), keyStructure.getPrime1(), keyStructure.getPrime2(), keyStructure.getExponent1(), keyStructure.getExponent2(), keyStructure.getCoefficient());
        }
        if (algId.getObjectId().equals(PKCSObjectIdentifiers.dhKeyAgreement)) {
            DHParameter params = new DHParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new DHPrivateKeyParameters(derX.getValue(), new DHParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(OIWObjectIdentifiers.elGamalAlgorithm)) {
            ElGamalParameter params = new ElGamalParameter((ASN1Sequence)keyInfo.getAlgorithmId().getParameters());
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            return new ElGamalPrivateKeyParameters(derX.getValue(), new ElGamalParameters(params.getP(), params.getG()));
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_dsa)) {
            DERInteger derX = (DERInteger)keyInfo.getPrivateKey();
            DEREncodable de = keyInfo.getAlgorithmId().getParameters();
            DSAParameters parameters = null;
            if (de != null) {
                DSAParameter params = DSAParameter.getInstance(de.getDERObject());
                parameters = new DSAParameters(params.getP(), params.getQ(), params.getG());
            }
            return new DSAPrivateKeyParameters(derX.getValue(), parameters);
        }
        if (algId.getObjectId().equals(X9ObjectIdentifiers.id_ecPublicKey)) {
            X962Parameters params = new X962Parameters((DERObject)keyInfo.getAlgorithmId().getParameters());
            ECDomainParameters dParams = null;
            if (params.isNamedCurve()) {
                DERObjectIdentifier oid = (DERObjectIdentifier)params.getParameters();
                X9ECParameters ecP = X962NamedCurves.getByOID(oid);
                if (ecP == null && (ecP = SECNamedCurves.getByOID(oid)) == null && (ecP = NISTNamedCurves.getByOID(oid)) == null) {
                    ecP = TeleTrusTNamedCurves.getByOID(oid);
                }
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            } else {
                X9ECParameters ecP = new X9ECParameters((ASN1Sequence)params.getParameters());
                dParams = new ECDomainParameters(ecP.getCurve(), ecP.getG(), ecP.getN(), ecP.getH(), ecP.getSeed());
            }
            ECPrivateKeyStructure ec = new ECPrivateKeyStructure((ASN1Sequence)keyInfo.getPrivateKey());
            return new ECPrivateKeyParameters(ec.getKey(), dParams);
        }
        throw new RuntimeException("algorithm identifier in key not recognised");
    }
}

