/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.signers;

import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Random;
import xjyb.bjca.org.multi.util.LoggerUtil;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERInteger;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DEROctetString;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.crypto.digests.sm3.util.SM3Digest;
import xjyb.org.bjca.math.ec.ECCurve;
import xjyb.org.bjca.math.ec.ECPoint;
import xjyb.org.bjca.sm4soft.util.ByteUtil;
import xjyb.org.bjca.util.BigIntegers;

public class SM2Signer {
    public static final BigInteger p = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFF", 16);
    public static final BigInteger a = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFFF00000000FFFFFFFFFFFFFFFC", 16);
    public static final BigInteger b = new BigInteger("28E9FA9E9D9F5E344D5A9E4BCF6509A7F39789F515AB8F92DDBCBD414D940E93", 16);
    public static final BigInteger n = new BigInteger("FFFFFFFEFFFFFFFFFFFFFFFFFFFFFFFF7203DF6B21C6052B53BBF40939D54123", 16);
    public static final BigInteger Gx = new BigInteger("32C4AE2C1F1981195F9904466A39C9948FE30BBFF2660BE1715A4589334C74C7", 16);
    public static final BigInteger Gy = new BigInteger("BC3736A2F4F6779C59BDCEE36B692153D0A9877CC62A474002DF32E52139F0A0", 16);
    public static final BigInteger ZERO = BigInteger.valueOf(0L);
    public static final BigInteger ONE = BigInteger.valueOf(1L);
    private static ECPoint G = null;
    private static ECCurve sm2Curve = null;

    public ECPoint createPoint(BigInteger x, BigInteger y, boolean withCompression) {
        return sm2Curve.createPoint(x, y, withCompression);
    }

    public ECPoint decodePoint(byte[] encoded) {
        if (encoded.length == 64) {
            byte[] bX = new byte[32];
            byte[] bY = new byte[32];
            System.arraycopy(encoded, 0, bX, 0, 32);
            System.arraycopy(encoded, 32, bY, 0, 32);
            BigInteger x = new BigInteger(1, bX);
            BigInteger y = new BigInteger(1, bY);
            return this.createPoint(x, y, false);
        }
        return sm2Curve.decodePoint(encoded);
    }

    public byte[] genKeyPair() {
        byte[] key = new byte[96];
        byte[] bD = null;
        byte[] bX = null;
        byte[] bY = null;
        BigInteger left = null;
        BigInteger rightBigInteger = null;
        do {
            BigInteger d;
            int nBitLength = n.bitLength();
            while ((d = new BigInteger(nBitLength, new Random())).equals(BigInteger.valueOf(0L)) || d.compareTo(n) >= 0) {
            }
            ECPoint Q = G.multiply(d);
            key = new byte[96];
            bD = BigIntegers.asUnsignedByteArray(d);
            bX = BigIntegers.asUnsignedByteArray(Q.getX().toBigInteger());
            bY = BigIntegers.asUnsignedByteArray(Q.getY().toBigInteger());
            BigInteger yBigInteger = Q.getY().toBigInteger();
            BigInteger xBigInteger = Q.getX().toBigInteger();
            left = yBigInteger.multiply(yBigInteger).mod(p);
            if (left.compareTo(rightBigInteger = xBigInteger.multiply(xBigInteger.multiply(xBigInteger)).add(a.multiply(xBigInteger)).add(b).mod(p)) == 0) continue;
            LoggerUtil.errorlog("genKeyPairSM2", bX.length + ":" + bY.length + ":" + bD.length);
            LoggerUtil.errorlog("genKeyPairSM2", "x:" + xBigInteger.toString());
            LoggerUtil.errorlog("genKeyPairSM2", "y:" + yBigInteger.toString());
            LoggerUtil.errorlog("genKeyPairSM2", "left:" + left.toString());
            LoggerUtil.errorlog("genKeyPairSM2", "right:" + rightBigInteger.toString());
            LoggerUtil.errorlog("genKeyPairSM2", left.compareTo(rightBigInteger) + "");
        } while (left.compareTo(rightBigInteger) != 0);
        System.arraycopy(bX, 0, key, 32 - bX.length, bX.length);
        System.arraycopy(bY, 0, key, 64 - bY.length, bY.length);
        System.arraycopy(bD, 0, key, 96 - bD.length, bD.length);
        return key;
    }

    public byte[] encrypt(byte[] bPubKey, byte[] bMessage) {
        byte[] buf;
        BigInteger k = null;
        byte[] t = null;
        byte[] x2 = null;
        byte[] y2 = null;
        ECPoint C = null;
        do {
            BigInteger h;
            int nBitLength = n.bitLength();
            k = new BigInteger(nBitLength, new Random());
            C = G.multiply(k);
            ECPoint Pb = this.decodePoint(bPubKey);
            ECPoint S = Pb.multiply(h = ((ECCurve.Fp)sm2Curve).getQ().divide(n));
            if (S.equals(ZERO)) {
                throw new RuntimeException("\u8ba1\u7b97\u692d\u5706\u66f2\u7ebf\u70b9S=[k]G\u7ed3\u679c\u4e3a0");
            }
            ECPoint point = Pb.multiply(k);
            x2 = BigIntegers.asUnsignedByteArray(point.getX().toBigInteger());
            y2 = BigIntegers.asUnsignedByteArray(point.getY().toBigInteger());
            buf = new byte[64];
            System.arraycopy(x2, 0, buf, 32 - x2.length, x2.length);
            System.arraycopy(y2, 0, buf, 64 - y2.length, y2.length);
        } while (new BigInteger(t = this.KDF(buf, bMessage.length)).equals(ZERO));
        byte[] C2 = this.XOR(bMessage, t);
        byte[] input = new byte[64 + bMessage.length];
        System.arraycopy(x2, 0, input, 32 - x2.length, x2.length);
        System.arraycopy(bMessage, 0, input, 32, bMessage.length);
        System.arraycopy(y2, 0, input, input.length - y2.length, y2.length);
        byte[] C3 = this.hash(input);
        byte[] bX = BigIntegers.asUnsignedByteArray(C.getX().toBigInteger());
        byte[] bY = BigIntegers.asUnsignedByteArray(C.getY().toBigInteger());
        int len = 96 + bMessage.length;
        byte[] out = new byte[len];
        System.arraycopy(bX, 0, out, 32 - bX.length, bX.length);
        System.arraycopy(bY, 0, out, 64 - bY.length, bY.length);
        System.arraycopy(C2, 0, out, 64, C2.length);
        System.arraycopy(C3, 0, out, len - C3.length, C3.length);
        return out;
    }

    public byte[] encryptReDer(byte[] bPubKey, byte[] bMessage) {
        byte[] buf;
        BigInteger k = null;
        byte[] t = null;
        byte[] x2 = null;
        byte[] y2 = null;
        ECPoint C = null;
        do {
            BigInteger h;
            int nBitLength = n.bitLength();
            k = new BigInteger(nBitLength, new Random());
            C = G.multiply(k);
            ECPoint Pb = this.decodePoint(bPubKey);
            ECPoint S = Pb.multiply(h = ((ECCurve.Fp)sm2Curve).getQ().divide(n));
            if (S.equals(ZERO)) {
                throw new RuntimeException("\u8ba1\u7b97\u692d\u5706\u66f2\u7ebf\u70b9S=[k]G\u7ed3\u679c\u4e3a0");
            }
            ECPoint point = Pb.multiply(k);
            x2 = BigIntegers.asUnsignedByteArray(point.getX().toBigInteger());
            y2 = BigIntegers.asUnsignedByteArray(point.getY().toBigInteger());
            buf = new byte[64];
            System.arraycopy(x2, 0, buf, 32 - x2.length, x2.length);
            System.arraycopy(y2, 0, buf, 64 - y2.length, y2.length);
        } while (new BigInteger(t = this.KDF(buf, bMessage.length)).equals(ZERO));
        byte[] C2 = this.XOR(bMessage, t);
        byte[] input = new byte[64 + bMessage.length];
        System.arraycopy(x2, 0, input, 32 - x2.length, x2.length);
        System.arraycopy(bMessage, 0, input, 32, bMessage.length);
        System.arraycopy(y2, 0, input, input.length - y2.length, y2.length);
        byte[] C3 = this.hash(input);
        ASN1EncodableVector enVector = new ASN1EncodableVector();
        DERInteger x = new DERInteger(C.getX().toBigInteger());
        DERInteger y = new DERInteger(C.getY().toBigInteger());
        DEROctetString hashOctStr = new DEROctetString(C3);
        DEROctetString enOctStr = new DEROctetString(C2);
        enVector.add(x);
        enVector.add(y);
        enVector.add(hashOctStr);
        enVector.add(enOctStr);
        DERSequence enSeq = new DERSequence(enVector);
        return enSeq.getDEREncoded();
    }

    public byte[] decrypt(byte[] bPriKey, byte[] bX, byte[] bY, byte[] bM, byte[] bC) {
        ECPoint C1 = this.createPoint(new BigInteger(1, bX), new BigInteger(1, bY), false);
        BigInteger dB = new BigInteger(1, bPriKey);
        ECPoint point = C1.multiply(dB);
        byte[] x2 = BigIntegers.asUnsignedByteArray(point.getX().toBigInteger());
        byte[] y2 = BigIntegers.asUnsignedByteArray(point.getY().toBigInteger());
        byte[] buf = new byte[64];
        System.arraycopy(x2, 0, buf, 32 - x2.length, x2.length);
        System.arraycopy(y2, 0, buf, 64 - y2.length, y2.length);
        byte[] C2 = bC;
        byte[] t = this.KDF(buf, C2.length);
        if (new BigInteger(t).equals(ZERO)) {
            throw new RuntimeException("\u8ba1\u7b97t=KDF(x2||y2, klen)\u7ed3\u679c\u4e3a0");
        }
        byte[] message = this.XOR(C2, t);
        byte[] input = new byte[64 + message.length];
        System.arraycopy(x2, 0, input, 32 - x2.length, x2.length);
        System.arraycopy(message, 0, input, 32, message.length);
        System.arraycopy(y2, 0, input, input.length - y2.length, y2.length);
        byte[] u = this.hash(input);
        byte[] C3 = bM;
        if (Arrays.equals(u, C3)) {
            return message;
        }
        throw new RuntimeException("\u54c8\u5e0c\u7ed3\u679c\u4e0d\u4e00\u81f4");
    }

    public byte[] decryptNoPadding(byte[] bPriKey, byte[] bX, byte[] bY, byte[] bM, byte[] bC) {
        ECPoint C1 = this.createPoint(new BigInteger(1, bX), new BigInteger(1, bY), false);
        BigInteger dB = new BigInteger(1, bPriKey);
        ECPoint point = C1.multiply(dB);
        byte[] x2 = BigIntegers.asUnsignedByteArray(point.getX().toBigInteger());
        byte[] y2 = BigIntegers.asUnsignedByteArray(point.getY().toBigInteger());
        byte[] buf = new byte[x2.length + y2.length];
        System.arraycopy(x2, 0, buf, 0, x2.length);
        System.arraycopy(y2, 0, buf, x2.length, y2.length);
        byte[] C2 = bC;
        byte[] t = this.KDF(buf, C2.length);
        if (new BigInteger(t).equals(ZERO)) {
            throw new RuntimeException("\u8ba1\u7b97t=KDF(x2||y2, klen)\u7ed3\u679c\u4e3a0");
        }
        byte[] message = this.XOR(C2, t);
        byte[] input = new byte[x2.length + y2.length + message.length];
        System.arraycopy(x2, 0, input, 0, x2.length);
        System.arraycopy(message, 0, input, x2.length, message.length);
        System.arraycopy(y2, 0, input, x2.length + message.length, y2.length);
        byte[] u = this.hash(input);
        byte[] C3 = bM;
        if (Arrays.equals(u, C3)) {
            return message;
        }
        throw new RuntimeException("\u54c8\u5e0c\u7ed3\u679c\u4e0d\u4e00\u81f4");
    }

    public byte[] decryptUseDerData(byte[] bPriKey, byte[] bCipher) throws IOException {
        ASN1InputStream in = new ASN1InputStream(bCipher);
        DERObject obj = in.readObject();
        ASN1Sequence enSeq = ASN1Sequence.getInstance(obj);
        DERObject bXObj = enSeq.getObjectAt(0).getDERObject();
        DERInteger x = (DERInteger)bXObj;
        byte[] bX = BigIntegers.asUnsignedByteArray(x.getValue());
        DERObject bYObj = enSeq.getObjectAt(1).getDERObject();
        DERInteger y = (DERInteger)bYObj;
        byte[] bY = BigIntegers.asUnsignedByteArray(y.getValue());
        DERObject bHashObj = enSeq.getObjectAt(2).getDERObject();
        DEROctetString hashOctStr = (DEROctetString)bHashObj;
        byte[] bHash = hashOctStr.getOctets();
        DERObject cObj = enSeq.getObjectAt(3).getDERObject();
        DEROctetString cOctStr = (DEROctetString)cObj;
        byte[] c = cOctStr.getOctets();
        byte[] cipher = ByteUtil.catbytes(bX, bY);
        cipher = ByteUtil.catbytes(cipher, c);
        cipher = ByteUtil.catbytes(cipher, bHash);
        byte[] decData = null;
        try {
            decData = this.decrypt(bPriKey, bX, bY, bHash, c);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (decData == null) {
            decData = this.decryptNoPadding(bPriKey, bX, bY, bHash, c);
        }
        return decData;
    }

    private byte[] hash(byte[] input) {
        SM3Digest digest = new SM3Digest();
        digest.update(input, 0, input.length);
        byte[] sm3 = new byte[32];
        digest.doFinal(sm3, 0);
        return sm3;
    }

    private byte[] XOR(byte[] x, byte[] y) {
        byte[] z = new byte[x.length];
        for (int i = 0; i < z.length; ++i) {
            z[i] = (byte)(x[i] ^ y[i]);
        }
        return z;
    }

    private byte[] KDF(byte[] Z, int klen) {
        int blockSize = 32;
        int outLen = klen % blockSize == 0 ? klen : (klen / blockSize + 1) * blockSize;
        byte[] out = new byte[outLen];
        int ct = 1;
        SM3Digest sm3 = null;
        byte[] hash = null;
        byte[] buf = null;
        int outOffset = 0;
        for (int i = 0; i < outLen / blockSize; ++i) {
            sm3 = new SM3Digest();
            buf = this.byteArrayCat(Z, this.int2bytes(ct));
            sm3.update(buf, 0, buf.length);
            hash = new byte[32];
            sm3.doFinal(hash, 0);
            System.arraycopy(hash, 0, out, outOffset, hash.length);
            outOffset += hash.length;
            ++ct;
        }
        return out;
    }

    private byte[] byteArrayCat(byte[] x, byte[] y) {
        byte[] out = new byte[x.length + y.length];
        System.arraycopy(x, 0, out, 0, x.length);
        System.arraycopy(y, 0, out, x.length, y.length);
        return out;
    }

    private byte[] int2bytes(int num) {
        return ByteUtil.int2bytes(num);
    }

    public byte[] sign(byte[] bPriKey, byte[] bHash) {
        BigInteger k;
        BigInteger d;
        if (bPriKey == null) {
            throw new RuntimeException("Private key is null");
        }
        if (bPriKey.length != 32) {
            throw new RuntimeException("Private Key length: " + bPriKey.length * 8 + "bits");
        }
        if (bHash == null) {
            throw new RuntimeException("Hash is null");
        }
        if (bHash.length != 32) {
            throw new RuntimeException("Hash length: " + bHash.length * 8 + "bits");
        }
        BigInteger e = new BigInteger(1, bHash);
        BigInteger r = null;
        BigInteger s = null;
        do {
            ECPoint p;
            BigInteger x;
            k = null;
            int nBitLength = n.bitLength();
            while ((k = new BigInteger(nBitLength, new Random())).equals(ZERO) || (r = e.add(x = (p = G.multiply(k)).getX().toBigInteger()).mod(n)).equals(ZERO) || r.add(k).equals(n)) {
            }
        } while ((s = ONE.add(d = new BigInteger(1, bPriKey)).modInverse(n).multiply(k.subtract(d.multiply(r))).mod(n)).equals(ZERO));
        BigInteger[] res = new BigInteger[]{r, s};
        byte[] bR = BigIntegers.asUnsignedByteArray(r);
        byte[] bS = BigIntegers.asUnsignedByteArray(s);
        byte[] signature = new byte[64];
        System.arraycopy(bR, 0, signature, 32 - bR.length, bR.length);
        System.arraycopy(bS, 0, signature, 64 - bS.length, bS.length);
        return signature;
    }

    public boolean verify(byte[] bPubKey, byte[] bHash, byte[] bSignature) {
        if (bPubKey == null) {
            throw new RuntimeException("Public key is null");
        }
        if (bPubKey.length != 64) {
            throw new RuntimeException("Public Key length: " + bPubKey.length * 8 + "bits");
        }
        if (bHash == null) {
            throw new RuntimeException("Hash is null");
        }
        if (bHash.length != 32) {
            throw new RuntimeException("Invalid Hash length: " + bHash.length * 8 + "bits");
        }
        BigInteger e = new BigInteger(1, bHash);
        byte[] bR = new byte[32];
        byte[] bS = new byte[32];
        System.arraycopy(bSignature, 0, bR, 0, 32);
        System.arraycopy(bSignature, 32, bS, 0, 32);
        BigInteger r = new BigInteger(1, bR);
        BigInteger s = new BigInteger(1, bS);
        byte[] bX = new byte[32];
        byte[] bY = new byte[32];
        System.arraycopy(bPubKey, 0, bX, 0, 32);
        System.arraycopy(bPubKey, 32, bY, 0, 32);
        BigInteger x = new BigInteger(1, bX);
        BigInteger y = new BigInteger(1, bY);
        if (r.compareTo(ONE) < 0 || r.compareTo(n) >= 0) {
            return false;
        }
        if (s.compareTo(ONE) < 0 || s.compareTo(n) >= 0) {
            return false;
        }
        BigInteger t = r.add(s).mod(n);
        if (t.equals(ZERO)) {
            return false;
        }
        ECPoint P = this.createPoint(x, y, false);
        ECPoint T = G.multiply(s).add(P.multiply(t));
        BigInteger R = e.add(T.getX().toBigInteger()).mod(n);
        return R.equals(r);
    }

    static {
        sm2Curve = new ECCurve.Fp(p, a, b);
        G = sm2Curve.createPoint(Gx, Gy, false);
    }
}

