/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.crypto.digests.sm3;

import xjyb.org.bjca.crypto.digests.sm3.Util;

class SM3Func {
    public static final byte[] iv;
    private static int[] Tj;

    SM3Func() {
    }

    private static int FFj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3Func.FF1j(X, Y, Z);
        }
        return SM3Func.FF2j(X, Y, Z);
    }

    private static int GGj(int X, int Y, int Z, int j) {
        if (j >= 0 && j <= 15) {
            return SM3Func.GG1j(X, Y, Z);
        }
        return SM3Func.GG2j(X, Y, Z);
    }

    private static int FF1j(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private static int FF2j(int X, int Y, int Z) {
        return X & Y | X & Z | Y & Z;
    }

    private static int GG1j(int X, int Y, int Z) {
        return X ^ Y ^ Z;
    }

    private static int GG2j(int X, int Y, int Z) {
        return X & Y | ~X & Z;
    }

    private static int P0(int X) {
        return X ^ SM3Func.rotateLeft(X, 9) ^ SM3Func.rotateLeft(X, 17);
    }

    private static int P1(int X) {
        return X ^ SM3Func.rotateLeft(X, 15) ^ SM3Func.rotateLeft(X, 23);
    }

    public static byte[] CF(byte[] V, byte[] B) {
        int[] v = SM3Func.byteArray2intArray(V);
        int[] b = SM3Func.byteArray2intArray(B);
        return SM3Func.intArray2byteArray(SM3Func.CF(v, b));
    }

    private static int[] byteArray2intArray(byte[] bytes) {
        int[] out = new int[bytes.length / 4];
        byte[] tmp = new byte[4];
        for (int i = 0; i < bytes.length; i += 4) {
            System.arraycopy(bytes, i, tmp, 0, 4);
            out[i / 4] = Util.bytes2int(tmp);
        }
        return out;
    }

    private static byte[] intArray2byteArray(int[] arr) {
        byte[] out = new byte[arr.length * 4];
        byte[] tmp = null;
        for (int i = 0; i < arr.length; ++i) {
            tmp = Util.int2bytes(arr[i]);
            System.arraycopy(tmp, 0, out, i * 4, 4);
        }
        return out;
    }

    public static int[] CF(int[] V, int[] B) {
        int a = V[0];
        int b = V[1];
        int c = V[2];
        int d = V[3];
        int e = V[4];
        int f = V[5];
        int g = V[6];
        int h = V[7];
        int[][] arr = SM3Func.Expand(B);
        int[] w = arr[0];
        int[] w1 = arr[1];
        for (int j = 0; j < 64; ++j) {
            int ss1 = SM3Func.rotateLeft(SM3Func.rotateLeft(a, 12) + e + SM3Func.rotateLeft(Tj[j], j), 7);
            int ss2 = ss1 ^ SM3Func.rotateLeft(a, 12);
            int tt1 = SM3Func.FFj(a, b, c, j) + d + ss2 + w1[j];
            int tt2 = SM3Func.GGj(e, f, g, j) + h + ss1 + w[j];
            d = c;
            c = SM3Func.rotateLeft(b, 9);
            b = a;
            a = tt1;
            h = g;
            g = SM3Func.rotateLeft(f, 19);
            f = e;
            e = SM3Func.P0(tt2);
        }
        int[] out = new int[]{a ^ V[0], b ^ V[1], c ^ V[2], d ^ V[3], e ^ V[4], f ^ V[5], g ^ V[6], h ^ V[7]};
        return out;
    }

    private static int[][] Expand(int[] B) {
        int j;
        int[] W = new int[68];
        int[] W1 = new int[64];
        for (int i = 0; i < B.length; ++i) {
            W[i] = B[i];
        }
        for (j = 16; j < 68; ++j) {
            W[j] = SM3Func.P1(W[j - 16] ^ W[j - 9] ^ SM3Func.rotateLeft(W[j - 3], 15)) ^ SM3Func.rotateLeft(W[j - 13], 7) ^ W[j - 6];
        }
        for (j = 0; j < 64; ++j) {
            W1[j] = W[j] ^ W[j + 4];
        }
        int[][] arr = new int[][]{W, W1};
        return arr;
    }

    public static byte[] padding(byte[] in, int bLen) {
        int k = 448 - (8 * in.length + 1) % 512;
        if (k < 0) {
            k = 960 - (8 * in.length + 1) % 512;
        }
        byte[] padd = new byte[++k / 8];
        padd[0] = -128;
        long n = in.length * 8 + bLen * 512;
        byte[] out = new byte[in.length + k / 8 + 8];
        int pos = 0;
        System.arraycopy(in, 0, out, 0, in.length);
        System.arraycopy(padd, 0, out, pos += in.length, padd.length);
        byte[] tmp = Util.long2bytes(n);
        System.arraycopy(tmp, 0, out, pos += padd.length, tmp.length);
        return out;
    }

    private static int rotateLeft(int x, int n) {
        return x << n | x >>> 32 - n;
    }

    static {
        int i;
        iv = Util.hex2bytes("7380166f4914b2b9172442d7da8a0600a96f30bc163138aae38dee4db0fb0e4e");
        Tj = new int[64];
        for (i = 0; i < 16; ++i) {
            SM3Func.Tj[i] = 2043430169;
        }
        for (i = 16; i < 64; ++i) {
            SM3Func.Tj[i] = 2055708042;
        }
    }
}

