/*
 * Decompiled with CFR 0.152.
 */
package com.hc.util;

import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.cms.SignerInformation;
import org.bouncycastle.cms.SignerInformationStore;
import org.bouncycastle.util.encoders.Base64;

public class SignatureUtil {
    private CMSSignedData cmsSignedData;
    private Base64 base64 = new Base64();
    private byte[] src;
    private String sign;

    public SignatureUtil(String p7SignData) throws Exception {
        this.cmsSignedData = new CMSSignedData(Base64.decode(p7SignData));
        this.init();
    }

    public SignatureUtil(byte[] p7SignData) throws Exception {
        this.cmsSignedData = new CMSSignedData(p7SignData);
        this.init();
    }

    private void init() throws Exception {
        byte[] object;
        CMSTypedData cmsTypedData = this.cmsSignedData.getSignedContent();
        if (cmsTypedData != null && cmsTypedData.getContent() != null && (object = (byte[])cmsTypedData.getContent()).length > 0) {
            this.src = object;
        }
        SignerInformationStore signerInformationStore = this.cmsSignedData.getSignerInfos();
        SignerInformation signerInformation = signerInformationStore.getSigners().iterator().next();
        this.sign = new String(Base64.encode(signerInformation.getSignature()));
    }

    public CMSSignedData getCmsSignedData() {
        return this.cmsSignedData;
    }

    public void setCmsSignedData(CMSSignedData cmsSignedData) {
        this.cmsSignedData = cmsSignedData;
    }

    public byte[] getSrc() {
        return this.src;
    }

    public void setSrc(byte[] src) {
        this.src = src;
    }

    public String getSign() {
        return this.sign;
    }

    public void setSign(String sign) {
        this.sign = sign;
    }

    public String toString() {
        return "SignatureUtil [cmsSignedData=" + this.cmsSignedData + ", src=" + this.src + ", sign=" + this.sign + "]";
    }

    public static void main(String[] args) throws Exception {
    }
}

