/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jcajce.provider.asymmetric.util;

import cn.org.bjca.gaia.crypto.params.AsymmetricKeyParameter;
import cn.org.bjca.gaia.crypto.params.GOST3410Parameters;
import cn.org.bjca.gaia.crypto.params.GOST3410PrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.GOST3410PublicKeyParameters;
import cn.org.bjca.gaia.jce.interfaces.GOST3410PrivateKey;
import cn.org.bjca.gaia.jce.interfaces.GOST3410PublicKey;
import cn.org.bjca.gaia.jce.spec.GOST3410PublicKeyParameterSetSpec;
import java.security.InvalidKeyException;
import java.security.PrivateKey;
import java.security.PublicKey;

public class GOST3410Util {
    public static AsymmetricKeyParameter generatePublicKeyParameter(PublicKey key) throws InvalidKeyException {
        if (key instanceof GOST3410PublicKey) {
            GOST3410PublicKey k = (GOST3410PublicKey)key;
            GOST3410PublicKeyParameterSetSpec p = k.getParameters().getPublicKeyParameters();
            return new GOST3410PublicKeyParameters(k.getY(), new GOST3410Parameters(p.getP(), p.getQ(), p.getA()));
        }
        throw new InvalidKeyException("can't identify GOST3410 public key: " + key.getClass().getName());
    }

    public static AsymmetricKeyParameter generatePrivateKeyParameter(PrivateKey key) throws InvalidKeyException {
        if (key instanceof GOST3410PrivateKey) {
            GOST3410PrivateKey k = (GOST3410PrivateKey)key;
            GOST3410PublicKeyParameterSetSpec p = k.getParameters().getPublicKeyParameters();
            return new GOST3410PrivateKeyParameters(k.getX(), new GOST3410Parameters(p.getP(), p.getQ(), p.getA()));
        }
        throw new InvalidKeyException("can't identify GOST3410 private key.");
    }
}

