/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms.jcajce;

import cn.org.bjca.gaia.cert.X509CertificateHolder;
import cn.org.bjca.gaia.cert.jcajce.JcaX509CertificateHolder;
import cn.org.bjca.gaia.cms.CMSAttributeTableGenerator;
import cn.org.bjca.gaia.cms.CMSSignatureEncryptionAlgorithmFinder;
import cn.org.bjca.gaia.cms.DefaultCMSSignatureEncryptionAlgorithmFinder;
import cn.org.bjca.gaia.cms.SignerInfoGenerator;
import cn.org.bjca.gaia.cms.SignerInfoGeneratorBuilder;
import cn.org.bjca.gaia.operator.ContentSigner;
import cn.org.bjca.gaia.operator.DigestCalculatorProvider;
import cn.org.bjca.gaia.operator.OperatorCreationException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;

public class JcaSignerInfoGeneratorBuilder {
    private SignerInfoGeneratorBuilder builder;

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider) {
        this(digestProvider, new DefaultCMSSignatureEncryptionAlgorithmFinder());
    }

    public JcaSignerInfoGeneratorBuilder(DigestCalculatorProvider digestProvider, CMSSignatureEncryptionAlgorithmFinder sigEncAlgFinder) {
        this.builder = new SignerInfoGeneratorBuilder(digestProvider, sigEncAlgFinder);
    }

    public JcaSignerInfoGeneratorBuilder setDirectSignature(boolean hasNoSignedAttributes) {
        this.builder.setDirectSignature(hasNoSignedAttributes);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setSignedAttributeGenerator(CMSAttributeTableGenerator signedGen) {
        this.builder.setSignedAttributeGenerator(signedGen);
        return this;
    }

    public JcaSignerInfoGeneratorBuilder setUnsignedAttributeGenerator(CMSAttributeTableGenerator unsignedGen) {
        this.builder.setUnsignedAttributeGenerator(unsignedGen);
        return this;
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509CertificateHolder certHolder) throws OperatorCreationException {
        return this.builder.build(contentSigner, certHolder);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, byte[] keyIdentifier) throws OperatorCreationException {
        return this.builder.build(contentSigner, keyIdentifier);
    }

    public SignerInfoGenerator build(ContentSigner contentSigner, X509Certificate certificate) throws OperatorCreationException, CertificateEncodingException {
        return this.build(contentSigner, new JcaX509CertificateHolder(certificate));
    }
}

