/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.cms;

import cn.org.bjca.gaia.asn1.BEROctetString;
import cn.org.bjca.gaia.asn1.cms.CMSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.cms.CompressedData;
import cn.org.bjca.gaia.asn1.cms.ContentInfo;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.cms.CMSCompressedData;
import cn.org.bjca.gaia.cms.CMSException;
import cn.org.bjca.gaia.cms.CMSTypedData;
import cn.org.bjca.gaia.operator.OutputCompressor;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class CMSCompressedDataGenerator {
    public static final String ZLIB = "1.2.840.113549.1.9.16.3.8";

    public CMSCompressedData generate(CMSTypedData content, OutputCompressor compressor) throws CMSException {
        BEROctetString comOcts;
        AlgorithmIdentifier comAlgId;
        try {
            ByteArrayOutputStream bOut = new ByteArrayOutputStream();
            OutputStream zOut = compressor.getOutputStream(bOut);
            content.write(zOut);
            zOut.close();
            comAlgId = compressor.getAlgorithmIdentifier();
            comOcts = new BEROctetString(bOut.toByteArray());
        }
        catch (IOException e) {
            throw new CMSException("exception encoding data.", e);
        }
        ContentInfo comContent = new ContentInfo(content.getContentType(), comOcts);
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.compressedData, new CompressedData(comAlgId, comContent));
        return new CMSCompressedData(contentInfo);
    }
}

