/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.util;

import cn.org.bjca.gaia.asn1.ASN1Encodable;
import cn.org.bjca.gaia.asn1.ASN1EncodableVector;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.DERSequence;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.util.ByteArrayUtil;
import cn.org.bjca.gaia.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;

public class Sm2CipherUtil {
    public static DERSequence sm2Cipher0018ToDer(byte[] cipherText0018) {
        byte[] c1x = Arrays.copyOfRange(cipherText0018, 32, 64);
        byte[] c1y = Arrays.copyOfRange(cipherText0018, 96, 128);
        byte[] c2 = Arrays.copyOfRange(cipherText0018, 164, cipherText0018.length);
        byte[] c3 = Arrays.copyOfRange(cipherText0018, 128, 160);
        ASN1Encodable[] arr = new ASN1Encodable[]{new ASN1Integer(new BigInteger(1, c1x)), new ASN1Integer(new BigInteger(1, c1y)), new DEROctetString(c3), new DEROctetString(c2)};
        return new DERSequence(arr);
    }

    public static byte[] sm2SignDataToDer(byte[] r, byte[] s) throws PkiException {
        try {
            BigInteger sBigInteger = ByteArrayUtil.byteArray2BigInteger(s);
            BigInteger rBigInteger = ByteArrayUtil.byteArray2BigInteger(r);
            ASN1EncodableVector signedData = new ASN1EncodableVector();
            signedData.add(new ASN1Integer(rBigInteger));
            signedData.add(new ASN1Integer(sBigInteger));
            DERSequence signedDataSequence = new DERSequence(signedData);
            return signedDataSequence.getEncoded("DER");
        }
        catch (IOException e) {
            throw new PkiException("11007012", "SM2\u7b7e\u540d\u6784\u9020\u5931\u8d25");
        }
    }
}

