/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.cert;

import cn.org.bjca.gaia.asn1.ASN1InputStream;
import cn.org.bjca.gaia.asn1.ASN1Integer;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.gm.GMObjectIdentifiers;
import cn.org.bjca.gaia.asn1.pkcs.PKCSObjectIdentifiers;
import cn.org.bjca.gaia.asn1.x500.X500Name;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.Certificate;
import cn.org.bjca.gaia.asn1.x509.Extension;
import cn.org.bjca.gaia.asn1.x509.Extensions;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.asn1.x509.TBSCertificate;
import cn.org.bjca.gaia.asn1.x509.Time;
import cn.org.bjca.gaia.asn1.x509.X509Name;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.assemb.base.GaiaProvider;
import cn.org.bjca.gaia.assemb.constant.AlgConstant;
import cn.org.bjca.gaia.assemb.exception.PkiException;
import cn.org.bjca.gaia.assemb.extension.SelfDefExtension;
import cn.org.bjca.gaia.assemb.param.AlgPolicy;
import cn.org.bjca.gaia.assemb.param.BjcaKey;
import cn.org.bjca.gaia.assemb.param.SM3Param;
import cn.org.bjca.gaia.assemb.util.Base64Util;
import cn.org.bjca.gaia.assemb.util.KeyPairUtil;
import cn.org.bjca.gaia.util.encoders.Base64;
import cn.org.bjca.gaia.util.encoders.Hex;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Date;

public class BjcaCert {
    private final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    private final String CERT_END = "-----END CERTIFICATE-----";
    private Certificate cert = null;
    private Extensions extensions = null;

    public BjcaCert(byte[] certData) throws PkiException {
        byte[] derData = this.parseCertData(certData);
        this.initCert(derData);
    }

    public BjcaCert(InputStream is) throws PkiException {
        byte[] certIS = null;
        byte[] derData = null;
        try {
            int i;
            int length = is.available();
            certIS = new byte[length];
            for (int readLen = is.read(certIS); readLen < length; readLen += i) {
                byte[] temp = new byte[length - readLen];
                i = is.read(temp);
                System.arraycopy(temp, 0, certIS, readLen, i);
            }
            derData = this.parseCertData(certIS);
        }
        catch (IOException ex) {
            throw new PkiException("11006001", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
        finally {
            try {
                is.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.initCert(derData);
    }

    private byte[] parseCertData(byte[] certData) throws PkiException {
        try {
            byte[] tempHead = new byte["-----BEGIN CERTIFICATE-----".length()];
            System.arraycopy(certData, 0, tempHead, 0, tempHead.length);
            if (Base64Util.isBase64Encode(certData)) {
                certData = Base64Util.convertBase64(certData);
                return Base64.decode(certData);
            }
            if (Arrays.equals(tempHead, "-----BEGIN CERTIFICATE-----".getBytes())) {
                int length = certData.length;
                byte[] withoutHead = new byte[length - "-----BEGIN CERTIFICATE-----".length()];
                System.arraycopy(certData, "-----BEGIN CERTIFICATE-----".length(), withoutHead, 0, withoutHead.length);
                byte[] withoutEnd = new byte[withoutHead.length - ("-----END CERTIFICATE-----".length() + 1)];
                System.arraycopy(withoutHead, 0, withoutEnd, 0, withoutEnd.length);
                byte[] withoutEnter = Base64Util.convertBase64(withoutEnd);
                return Base64.decode(withoutEnter);
            }
            return certData;
        }
        catch (Exception ex) {
            throw new PkiException("11006001", "\u89e3\u6790\u8bc1\u4e66\u65f6\u521d\u59cb\u5316\u8bc1\u4e66\u5931\u8d25", ex);
        }
    }

    private void initCert(byte[] certData) throws PkiException {
        try {
            ByteArrayInputStream bis = new ByteArrayInputStream(certData);
            ASN1InputStream dis = new ASN1InputStream(bis);
            ASN1Sequence seq = (ASN1Sequence)dis.readObject();
            this.cert = Certificate.getInstance(seq);
        }
        catch (Exception ex) {
            throw new PkiException("11006001", "11006001", ex);
        }
    }

    public BjcaCert(Certificate x509CertStructure) {
        this.cert = x509CertStructure;
    }

    public Certificate getX509CertStructure() {
        return this.cert;
    }

    public byte[] getEncoded() throws PkiException {
        byte[] encoded = null;
        try {
            encoded = this.cert.getEncoded("DER");
        }
        catch (Exception ex) {
            throw new PkiException("11006002", "\u83b7\u5f97\u8bc1\u4e66\u7f16\u7801\u5931\u8d25", ex);
        }
        return encoded;
    }

    public int getVersion() {
        return this.cert.getVersionNumber();
    }

    public String getIssuer() {
        return new X509Name(true, this.cert.getIssuer().toString()).toString();
    }

    public String getReverseIssuer() {
        X500Name x500IssuerName = this.cert.getIssuer();
        return x500IssuerName.toString();
    }

    public String getSubject() {
        return new X509Name(true, this.cert.getSubject().toString()).toString();
    }

    public String getReverseSubject() {
        X500Name x500SubjectName = this.cert.getSubject();
        return x500SubjectName.toString();
    }

    public Date getNotBefore() {
        Time startTime = this.cert.getStartDate();
        return startTime.getDate();
    }

    public Date getNotAfter() {
        Time endTime = this.cert.getEndDate();
        return endTime.getDate();
    }

    public BigInteger getSerialNumber() {
        ASN1Integer serialNumber = this.cert.getSerialNumber();
        return serialNumber.getValue();
    }

    public String getStringSerialNumber() {
        ASN1Integer serialNumber = this.cert.getSerialNumber();
        return serialNumber.getValue().toString(16);
    }

    public String getSignatureAlgName() throws PkiException {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        return AlgConstant.convertOidToAlgName(algID.getAlgorithm());
    }

    public String getSignatureAlgOID() {
        AlgorithmIdentifier algID = this.cert.getSignatureAlgorithm();
        return algID.getAlgorithm().getId();
    }

    public BjcaKey getPublicKey() throws PkiException {
        SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
        BjcaKey pubKey = null;
        pubKey = KeyPairUtil.subjectPubKeyInfo2Key(spki);
        return pubKey;
    }

    public PublicKey getSecurityPublicKey() throws PkiException {
        return KeyPairUtil.convertPublicKey(this.getPublicKey());
    }

    public String getPublicKeyAlgorithmParameters() throws PkiException {
        try {
            ASN1ObjectIdentifier parameters = (ASN1ObjectIdentifier)this.cert.getSubjectPublicKeyInfo().getAlgorithm().getParameters();
            return Hex.toHexString(parameters.getEncoded());
        }
        catch (IOException e) {
            throw new PkiException("11006007", "\u83b7\u53d6\u8bc1\u4e66\u516c\u94a5\u4fe1\u606f\u5931\u8d25", e);
        }
    }

    public String getPublicKeyAlgorithmId() {
        return this.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm().getId();
    }

    public byte[] getPublicKeyData() throws PkiException {
        byte[] bPubKey = null;
        try {
            ASN1ObjectIdentifier algId;
            SubjectPublicKeyInfo spki = this.cert.getSubjectPublicKeyInfo();
            bPubKey = spki.getEncoded();
            ASN1ObjectIdentifier algorithmIdentifier = spki.getAlgorithm().getAlgorithm();
            if (X9ObjectIdentifiers.id_ecPublicKey.equals(algorithmIdentifier) && null != (algId = ASN1ObjectIdentifier.getInstance(spki.getAlgorithm().getParameters())) && algId.equals(GMObjectIdentifiers.sm2p256v1)) {
                bPubKey = spki.getPublicKeyData().getBytes();
            }
        }
        catch (Exception e) {
            throw new PkiException("11006004", "\u4ece\u8bc1\u4e66\u83b7\u53d6\u516c\u94a5\u5931\u8d25", e);
        }
        return bPubKey;
    }

    public byte[] getSignature() {
        DERBitString signature = this.cert.getSignature();
        return signature.getBytes();
    }

    public byte[] getSubjectUniqueId() {
        DERBitString subjectUniqueId = this.cert.getTBSCertificate().getSubjectUniqueId();
        if (subjectUniqueId != null) {
            return subjectUniqueId.getBytes();
        }
        return null;
    }

    public byte[] getIssuerUniqueId() {
        DERBitString issuerUniqueId = this.cert.getTBSCertificate().getIssuerUniqueId();
        if (issuerUniqueId != null) {
            return issuerUniqueId.getBytes();
        }
        return null;
    }

    public SelfDefExtension getSelfDefExtension(String oid) throws PkiException {
        byte[] selfDefExtData = this.getExtensionByteData(new ASN1ObjectIdentifier(oid));
        if (selfDefExtData == null) {
            return null;
        }
        SelfDefExtension selfDefExtension = new SelfDefExtension(oid, selfDefExtData);
        this.getExtensionCritical(selfDefExtension);
        return selfDefExtension;
    }

    private void getExtensionCritical(cn.org.bjca.gaia.assemb.extension.Extension extension) {
        ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(extension.getOID());
        Extension ext = this.extensions.getExtension(oid);
        extension.setCritical(ext.isCritical());
    }

    private byte[] getExtensionByteData(ASN1ObjectIdentifier oid) {
        TBSCertificate tbsCert = this.cert.getTBSCertificate();
        this.extensions = tbsCert.getExtensions();
        if (this.extensions == null) {
            return null;
        }
        Extension extension = this.extensions.getExtension(oid);
        if (extension == null) {
            return null;
        }
        return extension.getExtnValue().getOctets();
    }

    public String getCertType() {
        String keyType = null;
        ASN1ObjectIdentifier algorithmIdenti = this.cert.getSubjectPublicKeyInfo().getAlgorithm().getAlgorithm();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals(algorithmIdenti)) {
            keyType = "ECC";
            ASN1ObjectIdentifier algId = ASN1ObjectIdentifier.getInstance(this.cert.getSubjectPublicKeyInfo().getAlgorithm().getParameters());
            if (null != algId && algId.equals(GMObjectIdentifiers.sm2p256v1)) {
                keyType = "SM2";
            }
        } else {
            keyType = PKCSObjectIdentifiers.rsaEncryption.equals(algorithmIdenti) ? "RSA" : algorithmIdenti.getId();
        }
        return keyType;
    }

    public boolean validateCert(byte[] fatherCert, GaiaProvider provider) throws PkiException {
        boolean ret = false;
        try {
            BjcaCert fatherCertOb = new BjcaCert(fatherCert);
            byte[] pubKey = fatherCertOb.getPublicKeyData();
            byte[] toBeSignCert = this.cert.getTBSCertificate().getEncoded();
            byte[] signedData = this.cert.getSignature().getBytes();
            AlgorithmIdentifier signAlgIdentifier = this.cert.getSignatureAlgorithm();
            String algId = signAlgIdentifier.getAlgorithm().getId();
            AlgPolicy hashAlg = null;
            AlgPolicy signAlg = null;
            BjcaKey bjcaKey = null;
            if (algId.equals(PKCSObjectIdentifiers.sha1WithRSAEncryption.getId())) {
                hashAlg = new AlgPolicy("SHA1");
                signAlg = new AlgPolicy("SHA1WithRSA");
                bjcaKey = new BjcaKey("RSA_Public", pubKey);
            } else if (algId.equals(PKCSObjectIdentifiers.sha256WithRSAEncryption.getId())) {
                hashAlg = new AlgPolicy("SHA256");
                signAlg = new AlgPolicy("SHA256WithRSA");
                bjcaKey = new BjcaKey("RSA_Public", pubKey);
            } else if (algId.equals(GMObjectIdentifiers.sm2sign_with_sm3.getId())) {
                SM3Param sm3Param = new SM3Param(pubKey);
                hashAlg = new AlgPolicy("SM3", sm3Param);
                signAlg = new AlgPolicy("SM3WithSM2");
                bjcaKey = new BjcaKey("SM2_Public", pubKey);
            } else {
                throw new PkiException("11006003", "\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25 \u8bc1\u4e66\u7c7b\u578b\u4e0d\u652f\u6301");
            }
            byte[] hash = provider.hash(hashAlg, toBeSignCert);
            ret = provider.verifySignHashedData(signAlg, hash, signedData, bjcaKey);
        }
        catch (Exception e) {
            throw new PkiException("11006003", "\u9a8c\u8bc1\u8bc1\u4e66\u5931\u8d25", e);
        }
        return ret;
    }
}

