/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.assemb.base;

import cn.org.bjca.gaia.assemb.base.CommonJniSM9Data;
import cn.org.bjca.gaia.assemb.base.SCFJniHost;

public class CommonJniAsymKey {
    private SCFJniHost jnihost_;
    private long hAsymKey_;

    protected CommonJniAsymKey(SCFJniHost jnihost, long hAsymKey) {
        this.jnihost_ = jnihost;
        this.hAsymKey_ = hAsymKey;
    }

    public synchronized void destroy() {
        if (this.hAsymKey_ > 0L) {
            this.jnihost_.destroyAsymObject(this.hAsymKey_);
        }
        this.hAsymKey_ = 0L;
    }

    public byte[] getPublicKey() {
        return this.jnihost_.getPublicKey(this.hAsymKey_);
    }

    public byte[] getPrivateKey() {
        return this.jnihost_.getPrivateKey(this.hAsymKey_);
    }

    public int getKeyIndex() {
        return this.jnihost_.getKeyIndex(this.hAsymKey_);
    }

    public byte[] signHash(int hashAlgor, byte[] hash) {
        return this.jnihost_.asymObjectSignHash(this.hAsymKey_, hashAlgor, hash);
    }

    public boolean verifySignedHash(int hashAlgor, byte[] hash, byte[] signature) {
        return this.jnihost_.asymObjectVerifySignedHash(this.hAsymKey_, hashAlgor, hash, signature);
    }

    public byte[] publicKeyEncrypt(byte[] input) {
        return this.jnihost_.publicKeyEncrypt(this.hAsymKey_, input);
    }

    public byte[] privateKeyDecrypt(byte[] input) {
        return this.jnihost_.privateKeyDecrypt(this.hAsymKey_, input);
    }

    public boolean sm9SetMasterPublicKey(byte[] masterPublicKey, byte[] userId) {
        return this.jnihost_.sm9SetMasterPublicKey(this.hAsymKey_, masterPublicKey, userId);
    }

    public byte[] sm9SignData(int hashAlgor, byte[] inData) {
        return this.jnihost_.sm9SignData(this.hAsymKey_, hashAlgor, inData);
    }

    public boolean sm9VerifySignData(int hashAlgor, byte[] inData, byte[] signature) {
        return this.jnihost_.sm9VerifySignData(this.hAsymKey_, hashAlgor, inData, signature);
    }

    public boolean sm9SignInit(int hashAlgor) {
        return this.jnihost_.sm9SignInit(this.hAsymKey_, hashAlgor);
    }

    public boolean sm9SignUpdate(byte[] inData) {
        return this.jnihost_.sm9SignUpdate(this.hAsymKey_, inData);
    }

    public boolean sm9SignUpdate(byte[] input, int offset, int len) {
        byte[] in = new byte[len];
        System.arraycopy(input, offset, in, 0, len);
        return this.sm9SignUpdate(in);
    }

    public byte[] sm9SignFinal() {
        return this.jnihost_.sm9SignFinal(this.hAsymKey_);
    }

    public boolean sm9VerifyInit(int hashAlgor) {
        return this.jnihost_.sm9VerifyInit(this.hAsymKey_, hashAlgor);
    }

    public boolean sm9VerifyUpdate(byte[] inData) {
        return this.jnihost_.sm9VerifyUpdate(this.hAsymKey_, inData);
    }

    public boolean sm9VerifyUpdate(byte[] input, int offset, int len) {
        byte[] in = new byte[len];
        System.arraycopy(input, offset, in, 0, len);
        return this.sm9VerifyUpdate(in);
    }

    public boolean sm9VerifyFinal(byte[] signature) {
        return this.jnihost_.sm9VerifyFinal(this.hAsymKey_, signature);
    }

    public CommonJniSM9Data sm9WrapKey(int hashAlgor, byte[] userId, int keylen) {
        long hSM9Data = this.jnihost_.sm9WrapKey(this.hAsymKey_, hashAlgor, userId, keylen);
        if (hSM9Data == 0L) {
            return null;
        }
        return new CommonJniSM9Data(this.jnihost_, hSM9Data);
    }

    public byte[] sm9UnWrapKey(int hashAlgor, byte[] wrapKey, int keylen) {
        return this.jnihost_.sm9UnWrapKey(this.hAsymKey_, hashAlgor, wrapKey, keylen);
    }

    public byte[] sm9EncryptXor(int hashAlgor, byte[] userId, byte[] plainData) {
        return this.jnihost_.sm9EncryptXor(this.hAsymKey_, hashAlgor, userId, plainData);
    }

    public byte[] sm9DecryptXor(int hashAlgor, byte[] cipherData) {
        return this.jnihost_.sm9DecryptXor(this.hAsymKey_, hashAlgor, cipherData);
    }

    public byte[] sm9EncryptBlk(int hashAlgor, int symAlgId, byte[] userId, byte[] iv, byte[] plainData) {
        return this.jnihost_.sm9EncryptBlk(this.hAsymKey_, hashAlgor, symAlgId, userId, iv, plainData);
    }

    public byte[] sm9DecryptBlk(int hashAlgor, int symAlgId, byte[] cipherData) {
        return this.jnihost_.sm9DecryptBlk(this.hAsymKey_, hashAlgor, symAlgId, cipherData);
    }

    public CommonJniSM9Data sm9ExchangeKeyInitiatorRequest(byte[] userBId, int SKALen) {
        long hSM9Data = this.jnihost_.sm9ExchangeKeyInitiatorRequest(this.hAsymKey_, userBId, SKALen);
        if (hSM9Data == 0L) {
            return null;
        }
        return new CommonJniSM9Data(this.jnihost_, hSM9Data);
    }

    public CommonJniSM9Data sm9ExchangeKeyResponder(int hashAlgor, byte[] userAId, byte[] RA, int SKBLen) {
        long hSM9Data = this.jnihost_.sm9ExchangeKeyResponder(this.hAsymKey_, hashAlgor, userAId, RA, SKBLen);
        if (hSM9Data == 0L) {
            return null;
        }
        return new CommonJniSM9Data(this.jnihost_, hSM9Data);
    }

    public byte[] ED25519SignData(byte[] message) {
        return this.jnihost_.asymObjectED25519SignData(this.hAsymKey_, message);
    }

    public boolean ED25519VerifySignedData(byte[] message, byte[] signature) {
        return this.jnihost_.asymObjectED25519VerifySignedData(this.hAsymKey_, message, signature);
    }
}

