/*
 * Decompiled with CFR 0.152.
 */
package com.dianju.cz.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.logging.Logger;
import org.apache.commons.codec.binary.Base64;

public class Util {
    private static final Logger log = Logger.getLogger(Util.class.toString());

    public static void createDirs(String filePath) {
        File file = new File(filePath);
        if (!(file.exists() && file.isDirectory() || file.mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u6587\u4ef6\u5939\u5931\u8d25!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String copyDynamicLibrary(String libraryName, String targetPath) {
        String jdkBitVersion = System.getProperty("sun.arch.data.model");
        File targetFile = new File(targetPath + File.separator + libraryName);
        InputStream inputStream = null;
        FileOutputStream outputStream = null;
        try {
            int bytesRead;
            inputStream = Util.class.getResourceAsStream("/loadOCX/" + jdkBitVersion + "/" + libraryName);
            outputStream = new FileOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            while ((bytesRead = inputStream.read(buffer)) != -1) {
                ((OutputStream)outputStream).write(buffer, 0, bytesRead);
            }
            log.info("Dynamic library copied successfully to: " + targetPath);
        }
        catch (IOException e) {
            try {
                log.info("Failed to copy dynamic library: " + e.getMessage());
            }
            catch (Throwable throwable) {
                Util.closeStream(inputStream);
                Util.closeStream(outputStream);
                throw throwable;
            }
            Util.closeStream(inputStream);
            Util.closeStream(outputStream);
        }
        Util.closeStream(inputStream);
        Util.closeStream(outputStream);
        return targetFile.getAbsolutePath();
    }

    public static byte[] decodeBase64(String base64) {
        return Base64.decodeBase64(base64);
    }

    public static void closeStream(Closeable closeable) {
        if (null != closeable) {
            try {
                closeable.close();
            }
            catch (IOException e) {
                log.info("\u5173\u95ed\u6d41\u5931\u8d25!" + e.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readFileData(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            byte[] data = new byte[(int)file.length()];
            fis.read(data);
            byte[] byArray = data;
            return byArray;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException e) {
                    log.info("\u5173\u95ed\u6d41\u5931\u8d25!" + e.getMessage());
                }
            }
        }
    }
}

