/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.SigType;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signatures;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.appearance.Seal;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.range.Reference;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.range.References;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.sig.SignedInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.SESVersion;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.SESVersionHolder;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.parse.VersionParser;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SES_Signature;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SESeal;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container.OFDDir;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.BadOFDException;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.OFDReader;
import com.ygsoft.abc.mapp.ygca.ofdrw.reader.ResourceLocator;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.SignedDataValidateContainer;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.DocNotSignException;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.FileIntegrityException;
import com.ygsoft.abc.mapp.ygca.ofdrw.sign.verify.exceptions.OFDVerifyException;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.DigestInputStream;
import java.security.GeneralSecurityException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.util.Arrays;
import java.util.List;
import org.bouncycastle162.asn1.ASN1Object;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.dom4j.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OFDValidator
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger((String)OFDValidator.class.getName());
    private Provider provider;
    private OFDDir ofdDir;
    private final OFDReader reader;
    private final ResourceLocator rl;
    private SignedDataValidateContainer validator;

    public OFDValidator(OFDReader reader) {
        this.reader = reader;
        this.ofdDir = reader.getOFDDir();
        this.rl = reader.getResourceLocator();
        this.provider = new BouncyCastleProvider();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exeValidate() throws OFDVerifyException, IOException, GeneralSecurityException {
        this.rl.save();
        try {
            this.rl.cd("/");
            ST_Loc signsListLoc = this.reader.getDefaultDocSignaturesPath();
            if (signsListLoc == null) {
                throw new DocNotSignException("\u6587\u4ef6\u672a\u8fdb\u884c\u7535\u5b50\u7b7e\u540d");
            }
            Function<Element, Signatures> creater = Signatures.newFunc();
            Signatures sigList = this.rl.get(signsListLoc, creater);
            this.rl.cd(signsListLoc.parent());
            List<com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature> signatures = sigList.getSignatures();
            for (com.ygsoft.abc.mapp.ygca.ofdrw.core.signatures.Signature sigRecord : signatures) {
                SigType type = sigRecord.getType();
                ST_Loc signFileLoc = sigRecord.getBaseLoc();
                FilePath signatureFilePath = this.rl.getFile(signFileLoc);
                Signature sig = this.rl.get(signFileLoc, Signature.newFunc());
                this.checkFileIntegrity(sig);
                this.rl.save();
                try {
                    FilePath sealFilePath;
                    boolean sealMatch;
                    Seal seal;
                    this.rl.cd(signFileLoc.parent());
                    FilePath signedValueFilePath = this.rl.getFile(sig.getSignedValue());
                    if (!(type != null && type != SigType.Seal || (seal = sig.getSignedInfo().getSeal()) == null || seal.getOFDElement("BaseLoc") == null || (sealMatch = this.checkSealMatch(sealFilePath = this.rl.getFile(seal.getBaseLoc()), signedValueFilePath)))) {
                        throw new GeneralSecurityException("\u5370\u7ae0(Seal.esl)\u4e0e\u7535\u5b50\u7b7e\u7ae0\u6570\u636e(SignedValue.dat)\u4e2d\u7684\u5370\u7ae0\u4e0d\u5339\u914d");
                    }
                    String alg = sig.getSignedInfo().getSignatureMethod();
                    this.checkSignedValue(type, alg, signatureFilePath, signedValueFilePath);
                }
                finally {
                    this.rl.restore();
                }
            }
        }
        catch (Exception e) {
            if (e instanceof OFDVerifyException) {
                throw new BadOFDException(e.getMessage(), e);
            }
            throw new BadOFDException("OFD\u6587\u4ef6\u5185\u90e8\u7ed3\u6784\u9519\u8bef\uff0c\u65e0\u6cd5\u89e3\u6790\u3002", e);
        }
        finally {
            this.rl.restore();
        }
    }

    public OFDValidator setValidator(SignedDataValidateContainer validator) {
        if (validator == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9a8c\u8bc1\u5bb9\u5668\uff08validator\uff09\u4e3a\u7a7a");
        }
        this.validator = validator;
        return this;
    }

    public void checkSignedValue(SigType type, String alg, FilePath signatureFilePath, FilePath signedValuePath) throws IOException, GeneralSecurityException {
        if (this.validator == null) {
            throw new IllegalArgumentException("\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u9a8c\u8bc1\u5bb9\u5668\uff08validator\uff09\u4e3a\u7a7a,Call #setValidator");
        }
        if (type == null) {
            type = SigType.Seal;
        }
        this.validator.validate(type, alg, FileUtil.readAllBytes(signatureFilePath), FileUtil.readAllBytes(signedValuePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkFileIntegrity(Signature sig) throws FileIntegrityException, NoSuchAlgorithmException, IOException {
        this.rl.save();
        try {
            SignedInfo signedInfo = sig.getSignedInfo();
            References references = signedInfo.getReferences();
            String checkMethod = references.getCheckMethod();
            MessageDigest md = MessageDigest.getInstance(checkMethod, this.provider);
            for (Reference ref : references.getReferences()) {
                ST_Loc fileRef = ref.getFileRef();
                FilePath file = this.rl.getFile(fileRef);
                byte[] expectDataHash = ref.getCheckValue();
                FileInputStream in = null;
                DigestInputStream dis = null;
                try {
                    in = new FileInputStream(new File(file.getPath()));
                    dis = new DigestInputStream(in, md);
                    byte[] buffer = new byte[4096];
                    while (dis.read(buffer) > -1) {
                    }
                    byte[] actualDataHash = md.digest();
                    if (!Arrays.equals(expectDataHash, actualDataHash)) {
                        throw new FileIntegrityException(fileRef, expectDataHash, actualDataHash);
                    }
                }
                catch (Throwable throwable) {
                    IOUtil.close(dis);
                    IOUtil.close(in);
                    throw throwable;
                }
                IOUtil.close(dis);
                IOUtil.close(in);
                md.reset();
            }
        }
        finally {
            this.rl.restore();
        }
    }

    private boolean checkSealMatch(FilePath sealPath, FilePath signedValuePath) throws IOException, OFDVerifyException {
        ASN1Object sesSignature;
        byte[] sesSignatureBin = FileUtil.readAllBytes(signedValuePath);
        byte[] expect = null;
        SESVersionHolder v = VersionParser.parseSES_SignatureVersion(sesSignatureBin);
        if (v.getVersion() == SESVersion.v4) {
            sesSignature = com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v4.SES_Signature.getInstance(v.getObjSeq());
            SESeal eseal = sesSignature.getToSign().getEseal();
            expect = eseal.getEncoded("DER");
        } else if (v.getVersion() == SESVersion.v1) {
            sesSignature = SES_Signature.getInstance(v.getObjSeq());
            com.ygsoft.abc.mapp.ygca.ofdrw.gm.ses.v1.SESeal eseal = sesSignature.getToSign().getEseal();
            expect = eseal.getEncoded("DER");
        } else {
            throw new OFDVerifyException("\u672a\u77e5\u7684\u7535\u5b50\u7b7e\u7ae0\u6570\u636e\u7248\u672c\uff0c\u65e0\u6cd5\u89e3\u6790");
        }
        byte[] sealBin = FileUtil.readAllBytes(sealPath);
        return Arrays.equals(expect, sealBin);
    }

    @Override
    public void close() throws IOException {
        this.reader.close();
    }
}

