/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.pkg.container;

import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.jdk.function.Function;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FilePath;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.FileUtil;
import com.ygsoft.abc.mapp.ygca.jdk.nio.file.PathUtil;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.DefaultElementProxy;
import com.ygsoft.abc.mapp.ygca.ofdrw.core.basicType.ST_Loc;
import com.ygsoft.abc.mapp.ygca.ofdrw.pkg.tool.ElemCup;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle162.jcajce.provider.digest.SM3;
import org.dom4j.DocumentException;
import org.dom4j.Element;

public class VirtualContainer
implements Closeable {
    private String fullPath;
    private String name;
    private VirtualContainer parent;
    private Map<String, Element> fileCache = new HashMap<String, Element>(7);
    private Map<String, byte[]> fileSrcHash;
    private MessageDigest digest = null;
    private Map<String, VirtualContainer> dirCache = new HashMap<String, VirtualContainer>(5);

    public String getContainerName() {
        return this.name;
    }

    private VirtualContainer() {
        this.fileSrcHash = new HashMap<String, byte[]>(7);
        this.parent = this;
    }

    public VirtualContainer(FilePath filePath) throws IllegalArgumentException {
        this();
        if (filePath == null) {
            throw new IllegalArgumentException("\u5b8c\u6574\u8def\u5f84(fullDir)\u4e3a\u7a7a");
        }
        if (FileUtil.notExists(filePath) || !FileUtil.isDirectory(filePath)) {
            filePath = FileUtil.createDirectories(filePath);
        }
        this.fullPath = filePath.getPath();
        this.name = filePath.getFileName();
    }

    public VirtualContainer(FilePath parent, String dirName) throws IllegalArgumentException {
        this();
        if (parent == null) {
            throw new IllegalArgumentException("\u6839\u8def\u5f84(parent)\u4e3a\u7a7a");
        }
        FilePath filePath = PathUtil.get(parent.getPath(), dirName);
        if (FileUtil.notExists(filePath) || !FileUtil.isDirectory(filePath)) {
            filePath = FileUtil.createDirectories(filePath);
        }
        if (!FileUtil.isDirectory(parent)) {
            throw new IllegalStateException("\u8bf7\u4f20\u5165\u57fa\u7840\u76ee\u5f55\u8def\u5f84\uff0c\u800c\u4e0d\u662f\u6587\u4ef6");
        }
        this.fullPath = filePath.getPath();
        this.name = dirName;
    }

    public String getSysAbsPath() {
        return this.fullPath;
    }

    public VirtualContainer putFile(FilePath file) throws IOException {
        if (file == null || FileUtil.notExists(file) || FileUtil.isDirectory(file)) {
            return this;
        }
        String fileName = file.getFileName().toString();
        FilePath target = PathUtil.get(this.fullPath, fileName);
        if (FileUtil.exists(target) || target.toAbsolutePath().toString().equals(file.toAbsolutePath().toString())) {
            if (FileUtil.contentEquals(target.toFile(), file.toFile())) {
                return this;
            }
            throw new IOException("\u6587\u6863\u4e2d\u5df2\u7ecf\u5b58\u5728\u540c\u540d\u6587\u4ef6\u8d44\u6e90(" + fileName + ")\uff0c\u8bf7\u91cd\u547d\u540d\u6587\u4ef6");
        }
        FileUtil.copy(file, target);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualContainer addRaw(String fileName, InputStream in) throws IOException {
        FilePath target = PathUtil.get(this.fullPath, fileName);
        byte[] buffer = new byte[4096];
        int n = 0;
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(target.getPath());
            while ((n = in.read(buffer)) != -1) {
                ((OutputStream)out).write(buffer, 0, n);
            }
        }
        catch (Throwable throwable) {
            IOUtil.close(out);
            throw throwable;
        }
        IOUtil.close(out);
        return this;
    }

    public VirtualContainer putObj(String fileName, Element element) {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (element == null) {
            return this;
        }
        while (element instanceof DefaultElementProxy) {
            element = ((DefaultElementProxy)element).getProxy();
        }
        this.fileCache.put(fileName, element);
        return this;
    }

    public Element getObj(String fileName) throws FileNotFoundException, DocumentException {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        }
        Element element = this.fileCache.get(fileName);
        if (element == null) {
            FilePath file = this.getFile(fileName);
            element = ElemCup.inject(file);
            this.fileSrcHash.put(fileName, this.objectHash(element));
            this.fileCache.put(fileName, element);
        }
        return element;
    }

    private byte[] objectHash(Element element) throws DocumentException {
        try {
            if (this.digest == null) {
                this.digest = new SM3.Digest();
            }
            byte[] bin = ElemCup.dump(element);
            this.digest.reset();
            this.digest.update(bin);
            return this.digest.digest();
        }
        catch (IOException e) {
            throw new DocumentException("\u6587\u6863\u8ba1\u7b97\u6458\u8981\u8fc7\u7a0b\u4e2d\u5f02\u5e38", (Throwable)e);
        }
    }

    private boolean fileChanged(String filename, Element element) {
        if (this.digest == null) {
            return true;
        }
        byte[] srcHash = this.fileSrcHash.get(filename);
        if (srcHash == null) {
            return true;
        }
        try {
            byte[] nowHash = this.objectHash(element);
            return !Arrays.equals(srcHash, nowHash);
        }
        catch (DocumentException e) {
            throw new RuntimeException(e);
        }
    }

    public FilePath getFile(String fileName) throws FileNotFoundException {
        if (fileName == null || fileName.length() == 0) {
            throw new IllegalArgumentException("\u6587\u4ef6\u540d\u4e3a\u7a7a");
        }
        FilePath filePath = PathUtil.get(this.fullPath, fileName);
        if (FileUtil.isDirectory(filePath) || FileUtil.notExists(filePath)) {
            throw new FileNotFoundException("\u65e0\u6cd5\u5728\u76ee\u5f55: " + this.fullPath + "\u4e2d\u627e\u5230\uff0c\u6587\u4ef6 [ " + fileName + " ]");
        }
        return filePath;
    }

    public <R extends VirtualContainer> R obtainContainer(String name, Function<FilePath, R> mapper) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("\u5bb9\u5668\u540d\u79f0\uff08name\uff09\u4e3a\u7a7a");
        }
        if (mapper == null) {
            throw new IllegalArgumentException("\u5bb9\u5668\u6784\u5efa\u5bf9\u8c61\uff08mapper\uff09\u4e3a\u7a7a");
        }
        VirtualContainer target = this.dirCache.get(name);
        if (target == null) {
            FilePath p = PathUtil.get(this.fullPath, name);
            VirtualContainer ct = (VirtualContainer)mapper.apply(p);
            ct.setParent(this);
            this.dirCache.put(name, ct);
            return (R)ct;
        }
        return (R)target;
    }

    public <R extends VirtualContainer> R getContainer(String name, Function<FilePath, R> mapper) throws FileNotFoundException {
        FilePath p = PathUtil.get(this.fullPath, name);
        if (FileUtil.notExists(p) || !FileUtil.isDirectory(p)) {
            throw new FileNotFoundException("\u5bb9\u5668\u5185\u65e0\u6cd5\u627e\u540d\u4e3a\uff1a" + name + "\u76ee\u5f55");
        }
        VirtualContainer target = this.dirCache.get(name);
        if (target == null) {
            VirtualContainer ct = (VirtualContainer)mapper.apply(p);
            ct.setParent(this);
            this.dirCache.put(name, ct);
            return (R)ct;
        }
        return (R)target;
    }

    public VirtualContainer getParent() {
        return this.parent;
    }

    protected VirtualContainer setParent(VirtualContainer parent) {
        this.parent = parent;
        return this;
    }

    public FilePath getContainerPath() {
        return PathUtil.get(this.fullPath, new String[0]);
    }

    public boolean exit(String fileName) {
        if (fileName == null || fileName.length() == 0) {
            return false;
        }
        Element element = this.fileCache.get(fileName);
        if (element == null) {
            FilePath res = PathUtil.get(this.fullPath, this.fullPath);
            return !FileUtil.isDirectory(res) && !FileUtil.notExists(res);
        }
        return true;
    }

    public void clean() {
        try {
            FilePath path = this.getContainerPath();
            if (FileUtil.exists(path)) {
                FileUtil.delete(path);
            }
            this.fileCache.clear();
            this.dirCache.clear();
        }
        catch (Exception e) {
            System.err.println("\u5bb9\u5668\u5220\u9664\u5f02\u5e38: " + e.getMessage());
        }
    }

    public void flush() throws IOException {
        for (Map.Entry<String, Element> kv : this.fileCache.entrySet()) {
            String filename = kv.getKey();
            FilePath filePath = PathUtil.get(this.fullPath, filename);
            Element element = kv.getValue();
            if (!this.fileChanged(filename, element)) continue;
            ElemCup.dumpUpNS(element, filePath);
        }
        for (VirtualContainer container : this.dirCache.values()) {
            container.flush();
        }
        this.fileCache.clear();
        this.dirCache.clear();
    }

    public VirtualContainer flushContainerByName(String name) throws IOException {
        if (name == null || "".equals(name.trim())) {
            return this;
        }
        VirtualContainer virtualContainer = this.dirCache.get(name);
        if (virtualContainer != null) {
            virtualContainer.flush();
        }
        return this;
    }

    public VirtualContainer flushFileByName(String name) throws IOException {
        if (name == null || "".equals(name.trim())) {
            return this;
        }
        Element element = this.fileCache.get(name);
        if (element != null) {
            FilePath filePath = PathUtil.get(this.fullPath, name);
            if (this.fileChanged(name, element)) {
                ElemCup.dumpUpNS(element, filePath);
            }
        }
        return this;
    }

    public ST_Loc getAbsLoc() {
        ST_Loc absRes = null;
        absRes = this.parent == this ? new ST_Loc("/") : this.parent.getAbsLoc().cat(this.name);
        return absRes;
    }

    @Override
    public void close() throws IOException {
        this.flush();
    }
}

