/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut;

import com.ygsoft.abc.mapp.ygca.ofdrw.gm.cert.CertTools;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.ContentInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.IssuerAndSerialNumber;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.OIDs;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignedData;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.SignerInfo;
import com.ygsoft.abc.mapp.ygca.ofdrw.gm.sm2strut.VerifyInfo;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.security.Signature;
import java.util.Arrays;
import org.bouncycastle162.asn1.ASN1Encodable;
import org.bouncycastle162.asn1.DEROctetString;
import org.bouncycastle162.asn1.x509.Certificate;
import org.bouncycastle162.jcajce.provider.digest.SM3;
import org.bouncycastle162.jce.provider.BouncyCastleProvider;
import org.bouncycastle162.util.encoders.Base64;

public class GBT35275Validate {
    public static VerifyInfo validate(String alg, byte[] tbsContent, byte[] signedValue) throws GeneralSecurityException {
        byte[] plaintext;
        ContentInfo contentInfo = ContentInfo.getInstance(signedValue);
        if (contentInfo == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790ContentInfo\u7ed3\u6784");
        }
        if (!OIDs.signedData.equals((Object)contentInfo.getContentType())) {
            throw new IllegalArgumentException("\u975e\u6cd5\u7684\u7b7e\u540d\u6570\u636e\u7c7b\u578b\uff0c\u7c7b\u578b\uff1a" + contentInfo.getContentType());
        }
        SignedData signedData = SignedData.getInstance(contentInfo.getContent());
        if (signedData == null) {
            throw new IllegalArgumentException("\u65e0\u6cd5\u89e3\u6790\u7b7e\u540d\u503c\u683c\u5f0f\uff0c\u4e0d\u7b26 GBT35275");
        }
        SM3.Digest md = new SM3.Digest();
        byte[] plaintextAct = md.digest(tbsContent);
        if (!Arrays.equals(plaintextAct, plaintext = DEROctetString.getInstance((Object)signedData.getContentInfo().getContent()).getOctets())) {
            try {
                byte[] decode = Base64.decode((String)new String(plaintext));
                if (!Arrays.equals(plaintextAct, decode)) {
                    return VerifyInfo.Err("\u5f85\u7b7e\u540d\u539f\u6587\u4e0d\u7b26");
                }
            }
            catch (Exception e) {
                return VerifyInfo.Err("\u5f85\u7b7e\u540d\u539f\u6587\u4e0d\u7b26");
            }
        }
        for (ASN1Encodable item : signedData.getSignerInfos()) {
            SignerInfo signerInfo = SignerInfo.getInstance(item);
            IssuerAndSerialNumber iaSn = signerInfo.getIssuerAngSerialNumber();
            Certificate c = signedData.getSignCert(iaSn);
            if (c == null) {
                return VerifyInfo.Err("\u6ca1\u6709\u627e\u5230\u5339\u914d\u7684\u8bc1\u4e66\u65e0\u6cd5\u9a8c\u8bc1\u7b7e\u540d");
            }
            java.security.cert.Certificate cert = CertTools.toJavaCert(c);
            Signature sg = Signature.getInstance(alg, (Provider)new BouncyCastleProvider());
            sg.initVerify(cert.getPublicKey());
            sg.update(plaintext);
            byte[] signature = signerInfo.getEncryptedDigest().getOctets();
            if (sg.verify(signature)) continue;
            return VerifyInfo.Err("\u7b7e\u540d\u503c\u4e0d\u4e00\u81f4");
        }
        return VerifyInfo.OK();
    }
}

