/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.util;

import cn.org.bjca.gaia.asn1.ASN1Integer;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.X509CertVO;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class X509CertVOUtil {
    private static final Logger LOG = LoggerFactory.getLogger(X509CertVOUtil.class);

    public static X509CertVO convert(Certificate cert) {
        if (cert instanceof X509Certificate) {
            X509Certificate x509Cert = (X509Certificate)cert;
            X509CertVO certVO = new X509CertVO();
            certVO.setSubject(x509Cert.getSubjectDN().getName());
            certVO.setSerialNumber(x509Cert.getSerialNumber().toString());
            certVO.setBeginDate(x509Cert.getNotBefore());
            certVO.setEndDate(x509Cert.getNotAfter());
            certVO.setIssuer(x509Cert.getIssuerDN().getName());
            return certVO;
        }
        return null;
    }

    public static X509CertVO convert(cn.org.bjca.gaia.asn1.x509.Certificate cert) {
        X509CertVO x509Cert = new X509CertVO();
        x509Cert.setSerialNumber(X509CertVOUtil.toHexString(cert.getSerialNumber()));
        x509Cert.setSubject(cert.getSubject().toString());
        x509Cert.setIssuer(cert.getIssuer().toString());
        x509Cert.setBeginDate(cert.getStartDate().getDate());
        x509Cert.setEndDate(cert.getEndDate().getDate());
        return x509Cert;
    }

    private static String toHexString(ASN1Integer asn1) {
        try {
            byte[] snData = asn1.getPositiveValue().toByteArray();
            int length = snData.length;
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i != length; ++i) {
                int v = snData[i] & 0xFF;
                buf.append("0123456789ABCDEF".charAt(v >>> 4));
                buf.append("0123456789ABCDEF".charAt(v & 0xF));
            }
            return buf.toString().toLowerCase();
        }
        catch (Exception e) {
            LOG.warn("ASN1Integer\u8f6cHex\u5931\u8d25\u3002");
            e.printStackTrace();
            return asn1.toString();
        }
    }
}

