/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.gwcw.impl.service;

import com.ygsoft.abc.mapp.ygca.algorithm.util.Base64;
import com.ygsoft.abc.mapp.ygca.gwcw.common.types.YesnoEnum;
import com.ygsoft.abc.mapp.ygca.gwcw.domain.vo.VerifyResultVO;
import com.ygsoft.abc.mapp.ygca.gwcw.service.IBizSignatureService;
import com.ygsoft.abc.mapp.ygca.gwcw.util.IOUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.util.StringUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateAbstractContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateProxyContainer;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.ofd.OFDValidateUtil;
import com.ygsoft.abc.mapp.ygca.gwcw.validator.xbrl.XbrlValidator;
import java.io.File;
import java.util.Map;
import org.dom4j.DocumentFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BizSignatureService
implements IBizSignatureService {
    private static final Logger LOG = LoggerFactory.getLogger(BizSignatureService.class);

    public BizSignatureService() {
        try {
            DocumentFactory.getInstance();
        }
        catch (Exception e) {
            LOG.warn("parseText error", (Throwable)e);
        }
    }

    @Override
    public VerifyResultVO verify(String fileBase64, String fileType, Map<String, String> optionalParam) {
        if (StringUtil.isBlank(fileBase64)) {
            return new VerifyResultVO(YesnoEnum.NSP, "fileBase64\u4e3a\u7a7a\u3002", null);
        }
        byte[] fileData = Base64.decode(fileBase64);
        return this.verify(fileData, fileType, optionalParam);
    }

    @Override
    public VerifyResultVO verify(byte[] fileData, String fileType, Map<String, String> optionalParam) {
        if ("ofd".equalsIgnoreCase(fileType)) {
            return this.verifyOfd(fileData);
        }
        if ("zip".equalsIgnoreCase(fileType)) {
            return this.verifyZip(fileData);
        }
        return new VerifyResultVO(YesnoEnum.NSP, "\u4e0d\u652f\u6301\u7684\u6587\u4ef6\u7c7b\u578b\u3002", null);
    }

    @Override
    public VerifyResultVO verify(File file, String fileType, Map<String, String> optionalParam) {
        if (null == file) {
            return new VerifyResultVO(YesnoEnum.NSP, "\u53c2\u6570\u9519\u8bef\uff1afile\u4e3a\u7a7a\u3002", null);
        }
        if (!file.exists()) {
            return new VerifyResultVO(YesnoEnum.NSP, "\u53c2\u6570\u9519\u8bef\uff1afile\u4e0d\u5b58\u5728\u3002", null);
        }
        byte[] zipData = IOUtil.readFile(file.getAbsolutePath());
        return this.verify(zipData, fileType, optionalParam);
    }

    @Override
    public VerifyResultVO verify(String fileBase64, String fileType) {
        return this.verify(fileBase64, fileType, null);
    }

    @Override
    public VerifyResultVO verify(byte[] fileData, String fileType) {
        return this.verify(fileData, fileType, null);
    }

    @Override
    public VerifyResultVO verify(File file, String fileType) {
        return this.verify(file, fileType, null);
    }

    public VerifyResultVO verifyZip(byte[] zipData) {
        return XbrlValidator.verifyXbrl(zipData);
    }

    private VerifyResultVO verifyOfd(byte[] fileData) {
        if (fileData == null) {
            return new VerifyResultVO(YesnoEnum.NSP, "\u53c2\u6570\u9519\u8bef\uff1afileData\u4e3a\u7a7a\u3002", null);
        }
        OFDValidateProxyContainer validateAbstractContainer = new OFDValidateProxyContainer();
        return OFDValidateUtil.verifyOfd(fileData, (OFDValidateAbstractContainer)validateAbstractContainer);
    }
}

