/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.mapp.ygca.algorithm.common;

import cn.org.bjca.gaia.crypto.AsymmetricCipherKeyPair;
import cn.org.bjca.gaia.crypto.CipherParameters;
import cn.org.bjca.gaia.crypto.DSA;
import cn.org.bjca.gaia.crypto.KeyGenerationParameters;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECKeyGenerationParameters;
import cn.org.bjca.gaia.crypto.params.ECKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPrivateKeyParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.crypto.params.ParametersWithRandom;
import cn.org.bjca.gaia.math.ec.ECConstants;
import cn.org.bjca.gaia.math.ec.ECMultiplier;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.math.ec.FixedPointCombMultiplier;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2KeyPairGenerator;
import com.ygsoft.abc.mapp.ygca.algorithm.common.SM2Params;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SM2DSASigner
implements ECConstants,
DSA {
    private ECKeyParameters key;
    private SM2KeyPairGenerator generator;

    public void initSign(BigInteger d, SecureRandom random) {
        if (d == null) {
            throw new SecurityException("null not allowed for d");
        }
        if (random == null) {
            random = new SecureRandom();
        }
        this.key = new ECPrivateKeyParameters(d, SM2Params.sm2DomainParameters);
        this.generator = new SM2KeyPairGenerator();
        this.generator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.key.getParameters(), random));
    }

    public void initVerify(ECPoint point) {
        if (point == null) {
            throw new SecurityException("null not allowed for point");
        }
        this.key = new ECPublicKeyParameters(point, SM2Params.sm2DomainParameters);
    }

    public void init(boolean forSigning, CipherParameters param) {
        if (param == null) {
            throw new SecurityException("null not allowed for param");
        }
        if (forSigning) {
            SecureRandom random = null;
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom rParam = (ParametersWithRandom)param;
                this.key = (ECPrivateKeyParameters)rParam.getParameters();
                random = rParam.getRandom();
            } else {
                this.key = (ECPrivateKeyParameters)param;
            }
            if (random == null) {
                random = new SecureRandom();
            }
            this.generator = new SM2KeyPairGenerator();
            this.generator.init((KeyGenerationParameters)new ECKeyGenerationParameters(this.key.getParameters(), random));
        } else {
            this.key = (ECPublicKeyParameters)param;
        }
    }

    public BigInteger[] generateSignature(byte[] hashMessage) {
        BigInteger s;
        BigInteger r;
        if (hashMessage == null) {
            throw new SecurityException("null not allowed for message");
        }
        if (this.key == null) {
            throw new SecurityException("not Initialization");
        }
        if (!(this.key instanceof ECPrivateKeyParameters)) {
            throw new SecurityException("key not ECPrivateKeyParameters");
        }
        ECDomainParameters ec = this.key.getParameters();
        BigInteger n = ec.getN();
        BigInteger e = this.calculateE(n, hashMessage);
        BigInteger d = ((ECPrivateKeyParameters)this.key).getD();
        ECPoint Q = null;
        AsymmetricCipherKeyPair keypair = null;
        BigInteger k = null;
        BigInteger x1 = null;
        do {
            keypair = this.generator.generateKeyPair();
            k = ((ECPrivateKeyParameters)keypair.getPrivate()).getD();
        } while ((r = e.add(x1 = (Q = ((ECPublicKeyParameters)keypair.getPublic()).getQ()).normalize().getXCoord().toBigInteger()).mod(n)).equals(ZERO) || r.add(k).equals(n) || (s = ONE.add(d).modInverse(n).multiply(k.subtract(r.multiply(d)).mod(n)).mod(n)).equals(ZERO));
        return new BigInteger[]{r, s};
    }

    public boolean verifySignature(byte[] message, BigInteger r, BigInteger s) {
        if (message == null) {
            throw new SecurityException("null not allowed for message");
        }
        if (r != null && s != null) {
            if (this.key == null) {
                throw new SecurityException("not Initialization");
            }
            if (!(this.key instanceof ECPublicKeyParameters)) {
                throw new SecurityException("key not ECPublicKeyParameters");
            }
            ECDomainParameters ec = this.key.getParameters();
            BigInteger n = ec.getN();
            if (r.compareTo(ONE) > 0 && r.compareTo(n) <= 0) {
                if (s.compareTo(ONE) > 0 && s.compareTo(n) <= 0) {
                    BigInteger e = this.calculateE(n, message);
                    BigInteger t = r.add(s).mod(n);
                    if (t.equals(ZERO)) {
                        return false;
                    }
                    ECPoint P = ((ECPublicKeyParameters)this.key).getQ();
                    FixedPointCombMultiplier multiplier = new FixedPointCombMultiplier();
                    ECPoint point = multiplier.multiply(ec.getG(), s).add(multiplier.multiply(P, t));
                    if (point.isInfinity()) {
                        return false;
                    }
                    BigInteger v = e.add(point.normalize().getXCoord().toBigInteger()).mod(n);
                    return v.equals(r);
                }
                return false;
            }
            return false;
        }
        throw new SecurityException("null not allowed for r/s");
    }

    protected BigInteger calculateE(BigInteger n, byte[] message) {
        BigInteger e = new BigInteger(1, message);
        int messageBitLength = message.length * 8;
        int log2n = n.bitLength();
        if (log2n < messageBitLength) {
            e = e.shiftRight(messageBitLength - log2n);
        }
        return e;
    }

    protected ECMultiplier createBasePointMultiplier() {
        return new FixedPointCombMultiplier();
    }

    protected SecureRandom initSecureRandom(boolean needed, SecureRandom provided) {
        return !needed ? null : (provided != null ? provided : new SecureRandom());
    }
}

