/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.openssl;

import java.io.IOException;
import java.io.Writer;
import java.security.SecureRandom;
import org.bouncycastle149.openssl.PEMEncryptor;
import org.bouncycastle149.openssl.jcajce.JcaMiscPEMGenerator;
import org.bouncycastle149.openssl.jcajce.JcePEMEncryptorBuilder;
import org.bouncycastle149.util.io.pem.PemGenerationException;
import org.bouncycastle149.util.io.pem.PemObjectGenerator;
import org.bouncycastle149.util.io.pem.PemWriter;

public class PEMWriter
extends PemWriter {
    private String provider;

    public PEMWriter(Writer writer) {
        this(writer, "BC");
    }

    public PEMWriter(Writer writer, String string) {
        super(writer);
        this.provider = string;
    }

    public void writeObject(Object object) throws IOException {
        this.writeObject(object, null);
    }

    public void writeObject(Object object, PEMEncryptor pEMEncryptor) throws IOException {
        try {
            super.writeObject(new JcaMiscPEMGenerator(object, pEMEncryptor));
        }
        catch (PemGenerationException pemGenerationException) {
            if (pemGenerationException.getCause() instanceof IOException) {
                throw (IOException)pemGenerationException.getCause();
            }
            throw pemGenerationException;
        }
    }

    public void writeObject(PemObjectGenerator pemObjectGenerator) throws IOException {
        super.writeObject(pemObjectGenerator);
    }

    public void writeObject(Object object, String string, char[] cArray, SecureRandom secureRandom) throws IOException {
        this.writeObject(object, new JcePEMEncryptorBuilder(string).setSecureRandom(secureRandom).setProvider(this.provider).build(cArray));
    }
}

