/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.jcajce.provider.symmetric;

import org.bouncycastle149.crypto.BlockCipher;
import org.bouncycastle149.crypto.CipherKeyGenerator;
import org.bouncycastle149.crypto.engines.SerpentEngine;
import org.bouncycastle149.crypto.macs.GMac;
import org.bouncycastle149.crypto.modes.GCMBlockCipher;
import org.bouncycastle149.jcajce.provider.config.ConfigurableProvider;
import org.bouncycastle149.jcajce.provider.symmetric.SymmetricAlgorithmProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseBlockCipher;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseKeyGenerator;
import org.bouncycastle149.jcajce.provider.symmetric.util.BaseMac;
import org.bouncycastle149.jcajce.provider.symmetric.util.BlockCipherProvider;
import org.bouncycastle149.jcajce.provider.symmetric.util.IvAlgorithmParameters;

public final class Serpent {
    private Serpent() {
    }

    public static class AlgParams
    extends IvAlgorithmParameters {
        protected String engineToString() {
            return "Serpent IV";
        }
    }

    public static class ECB
    extends BaseBlockCipher {
        public ECB() {
            super(new BlockCipherProvider(){

                public BlockCipher get() {
                    return new SerpentEngine();
                }
            });
        }
    }

    public static class KeyGen
    extends BaseKeyGenerator {
        public KeyGen() {
            super("Serpent", 192, new CipherKeyGenerator());
        }
    }

    public static class Mappings
    extends SymmetricAlgorithmProvider {
        private static final String PREFIX = Serpent.class.getName();

        public void configure(ConfigurableProvider configurableProvider) {
            configurableProvider.addAlgorithm("Cipher.Serpent", PREFIX + "$ECB");
            configurableProvider.addAlgorithm("KeyGenerator.Serpent", PREFIX + "$KeyGen");
            configurableProvider.addAlgorithm("AlgorithmParameters.Serpent", PREFIX + "$AlgParams");
            this.addGMacAlgorithm(configurableProvider, "SERPENT", PREFIX + "$SerpentGMAC", PREFIX + "$KeyGen");
        }
    }

    public static class SerpentGMAC
    extends BaseMac {
        public SerpentGMAC() {
            super(new GMac(new GCMBlockCipher(new SerpentEngine())));
        }
    }
}

