/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle149.cms.jcajce;

import java.security.Provider;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import org.bouncycastle149.asn1.ASN1ObjectIdentifier;
import org.bouncycastle149.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle149.cert.jcajce.JcaX509CertificateHolder;
import org.bouncycastle149.cms.KeyTransRecipientInfoGenerator;
import org.bouncycastle149.operator.AsymmetricKeyWrapper;
import org.bouncycastle149.operator.jcajce.JceAsymmetricKeyWrapper;

public class JceKeyTransRecipientInfoGenerator
extends KeyTransRecipientInfoGenerator {
    public JceKeyTransRecipientInfoGenerator(X509Certificate x509Certificate) throws CertificateEncodingException {
        super(new IssuerAndSerialNumber(new JcaX509CertificateHolder(x509Certificate).toASN1Structure()), (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(x509Certificate.getPublicKey()));
    }

    public JceKeyTransRecipientInfoGenerator(byte[] byArray, PublicKey publicKey) {
        super(byArray, (AsymmetricKeyWrapper)new JceAsymmetricKeyWrapper(publicKey));
    }

    public JceKeyTransRecipientInfoGenerator setProvider(String string) {
        ((JceAsymmetricKeyWrapper)this.wrapper).setProvider(string);
        return this;
    }

    public JceKeyTransRecipientInfoGenerator setProvider(Provider provider) {
        ((JceAsymmetricKeyWrapper)this.wrapper).setProvider(provider);
        return this;
    }

    public JceKeyTransRecipientInfoGenerator setAlgorithmMapping(ASN1ObjectIdentifier aSN1ObjectIdentifier, String string) {
        ((JceAsymmetricKeyWrapper)this.wrapper).setAlgorithmMapping(aSN1ObjectIdentifier, string);
        return this;
    }
}

