/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import org.apache.commons.io.IOUtils;
import org.hibernate.engine.jdbc.BlobProxy;
import org.hibernate.engine.jdbc.ClobProxy;

public final class SqlLargeObjectUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SqlLargeObjectUtil.class);

    private SqlLargeObjectUtil() {
    }

    public static String blobToString(Blob blob) {
        if (null == blob) {
            return null;
        }
        try {
            return new String(IOUtils.toByteArray((InputStream)blob.getBinaryStream()));
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"SqlLargeObjectUtil_blobToString_53", (String)"Blob\u8f6cString\u5931\u8d25\uff1a") + e.getMessage();
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static Blob stringToBlob(String str) {
        if (null == str) {
            return null;
        }
        try {
            return BlobProxy.generateProxy((byte[])str.getBytes("UTF-8"));
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"SqlLargeObjectUtil_stringToBlob_70", (String)"String\u8f6cBlob\u5931\u8d25\uff1a") + e.getMessage();
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static Blob streamToBlob(InputStream in) {
        if (null == in) {
            return null;
        }
        try {
            Blob blob = BlobProxy.generateProxy((byte[])IOUtils.toByteArray((InputStream)in));
            return blob;
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"SqlLargeObjectUtil_stringToBlob_87", (String)"String\u8f6cBlob\u5931\u8d25\uff1a") + e.getMessage();
            throw new AbcServiceException("ABC.0015", msg);
        }
        finally {
            StreamUtil.closeStream((InputStream)in);
        }
    }

    public static String clobToString(Clob clob) {
        if (null == clob) {
            return null;
        }
        try {
            return clob.getSubString(1L, (int)clob.length());
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"SqlLargeObjectUtil_clobToString_107", (String)"Clob\u8f6cString\u5931\u8d25\uff1a") + e.getMessage();
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static Clob stringToClob(String str) {
        if (null == str) {
            return null;
        }
        try {
            return ClobProxy.generateProxy((String)str);
        }
        catch (Exception e) {
            String msg = EcpI18nUtil.localizedString((String)"SqlLargeObjectUtil_stringToClob_124", (String)"String\u8f6cClob\u5931\u8d25\uff1a") + e.getMessage();
            throw new AbcServiceException("ABC.0015", msg);
        }
    }

    public static void main(String[] args) {
        String str = "\u6d4b\u8bd5\u770b\u770babcd123~~~";
        Blob blob = SqlLargeObjectUtil.stringToBlob("\u6d4b\u8bd5\u770b\u770babcd123~~~");
        System.out.println(SqlLargeObjectUtil.blobToString(blob));
        Clob clob = SqlLargeObjectUtil.stringToClob("\u6d4b\u8bd5\u770b\u770babcd123~~~");
        System.out.println(SqlLargeObjectUtil.clobToString(clob));
        ByteArrayInputStream in = new ByteArrayInputStream("\u6d4b\u8bd5\u770b\u770babcd123~~~".getBytes());
        Blob blob2 = SqlLargeObjectUtil.streamToBlob(in);
        System.out.println(SqlLargeObjectUtil.blobToString(blob2));
    }
}

