/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.EmptyValueException;
import com.ygsoft.abc.service.login.ExtendContextContainer;
import com.ygsoft.abc.service.login.domain.vo.ExtendLoginContext;
import com.ygsoft.abc.service.login.domain.vo.LoginContextVO;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.core.framework.model.OrbitAbstractValueObject;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.DateUtil;
import com.ygsoft.ecp.service.tool.IEcpToolLogic;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.necp.core.service.model.IOrbitModel;
import java.util.Date;
import java.util.List;

public class OrbitModelUtil
implements IEcpToolLogic {
    private static final IEcpLog LOG = EcpLogFactory.getLog(OrbitModelUtil.class);

    public static void initOrbitDataByDefault(IOrbitModel bo) {
        Date now = DateUtil.getCurrentSystemTime();
        String userId = "_";
        bo.setModifier("_");
        bo.setLastTime(now);
        bo.setCreateTime(now);
        bo.setCreator("_");
    }

    public static void initOrbitData(ExtendLoginContext context, IOrbitModel bo) {
        if (bo != null && context != null) {
            if (StringUtil.isEmptyString((String)bo.getCreator())) {
                bo.setCreator(context.getUserGid());
            }
            bo.setModifier(context.getUserGid());
            bo.setLastTime(DateUtil.getCurrentSystemTime());
            bo.setCreateTime(DateUtil.getCurrentSystemTime());
            OrbitModelUtil.updateOrbitData(context, bo);
        }
    }

    public static void initOrbitData(IOrbitModel bo) {
        if (bo != null) {
            bo.setCreator("sys");
            bo.setModifier("sys");
            Date now = new Date();
            bo.setCreateTime(now);
            bo.setLastTime(now);
        }
    }

    public static void initOrbitData(IOrbitModel model, boolean mustLogin) {
        if (model == null) {
            return;
        }
        if (mustLogin) {
            ExtendLoginContext loginContext = ExtendContextContainer.getLoginContext();
            if (loginContext == null) {
                throw EmptyValueException.newInstance("\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e3a\u7a7a\u3002");
            }
            OrbitModelUtil.initOrbitData(loginContext, model);
        } else {
            OrbitModelUtil.initOrbitData(model);
        }
    }

    public static void updateOrbitData(ExtendLoginContext context, IOrbitModel bo) {
        if (bo != null && context != null) {
            bo.setModifier(context.getUserGid());
            bo.setLastTime(DateUtil.getCurrentSystemTime());
        }
    }

    public static void updateOrbitData(IOrbitModel model, boolean mustLogin) {
        if (model == null) {
            return;
        }
        if (PropertyConfigUtil.isUnitTest()) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)"\u5f00\u542f\u5355\u5143\u6d4b\u8bd5--\u65e0\u9700\u8bbe\u7f6e\u8ddf\u8e2a\u5c5e\u6027\u3002");
            }
            return;
        }
        if (mustLogin) {
            ExtendLoginContext loginContext = ExtendContextContainer.getLoginContext();
            if (loginContext == null) {
                throw EmptyValueException.newInstance("\u4e1a\u52a1\u4e0a\u4e0b\u6587\u4e3a\u7a7a\u3002");
            }
            OrbitModelUtil.updateOrbitData(loginContext, model);
        } else {
            OrbitModelUtil.updateOrbitData(model);
        }
    }

    public static void updateOrbitData(IOrbitModel bo) {
        if (bo != null) {
            bo.setModifier("sys");
            bo.setLastTime(DateUtil.getCurrentSystemTime());
        }
    }

    public static void initOrbitData(LoginContextVO context, IOrbitModel bo) {
        if (bo != null && context != null) {
            if (StringUtil.isEmptyString((String)bo.getCreator())) {
                bo.setCreator(context.getUserId());
            }
            bo.setModifier(context.getUserId());
            bo.setLastTime(DateUtil.getCurrentSystemTime());
            bo.setCreateTime(DateUtil.getCurrentSystemTime());
            OrbitModelUtil.updateOrbitData(context, bo);
        }
    }

    public static void updateOrbitData(LoginContextVO context, IOrbitModel bo) {
        if (bo != null && context != null) {
            bo.setModifier(context.getUserId());
            bo.setLastTime(DateUtil.getCurrentSystemTime());
        }
    }

    public static void updateOrbitDatas(LoginContextVO context, List<? extends IOrbitModel> bos) {
        if (!BlockCollectionUtil.isEmpty(bos) && context != null) {
            bos.forEach(b -> OrbitModelUtil.updateOrbitData(context, b));
        }
    }

    public static void copyOrbitToVO(OrbitAbstractValueObject vo, IOrbitModel bo) {
        if (vo != null && bo != null) {
            vo.setCreateTime(bo.getCreateTime());
            vo.setCreator(bo.getCreator());
            vo.setLastUpdater(bo.getModifier());
            vo.setLastUpdateTime(bo.getLastTime());
        }
    }

    public static void copyOrbitToBO(OrbitAbstractValueObject vo, IOrbitModel bo) {
        if (bo != null && vo != null) {
            bo.setCreateTime(vo.getCreateTime());
            bo.setCreator(vo.getCreator());
            bo.setModifier(vo.getLastUpdater());
            bo.setLastTime(vo.getLastUpdateTime());
        }
    }
}

