/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.beanutils.BeanUtilsBean;
import org.apache.commons.beanutils.ConvertUtilsBean;
import org.apache.commons.beanutils.PropertyUtilsBean;
import org.apache.poi.ss.formula.functions.T;

public final class ObjectPropertyUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ObjectPropertyUtil.class);

    private ObjectPropertyUtil() {
    }

    public static Object getValue(Object obj, String key) {
        try {
            PropertyUtilsBean propertyUtils = BeanUtilsBean.getInstance().getPropertyUtils();
            return propertyUtils.getNestedProperty(obj, key);
        }
        catch (Exception e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static String getStringValue(Object obj, String key) {
        Object value = ObjectPropertyUtil.getValue(obj, key);
        if (null == value) {
            return null;
        }
        return ObjectPropertyUtil.convert(value);
    }

    public static T getValue(Object obj, String key, Class<T> clazz) {
        Object value = ObjectPropertyUtil.getValue(obj, key);
        if (null == value) {
            return null;
        }
        return ObjectPropertyUtil.convert(value, clazz);
    }

    public static String convert(Object obj) {
        ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();
        return convertUtils.convert(obj);
    }

    public static T convert(Object obj, Class<T> clazz) {
        ConvertUtilsBean convertUtils = BeanUtilsBean.getInstance().getConvertUtils();
        return (T)convertUtils.convert(obj, clazz);
    }

    public static List<Object> getArrayPropertyValues(Object bean, String name) {
        Object value = ObjectPropertyUtil.getValue(bean, name);
        if (value == null) {
            return null;
        }
        if (value instanceof Collection) {
            ArrayList<Object> values = new ArrayList<Object>();
            for (Object item : (Collection)value) {
                if (item == null) {
                    values.add(null);
                    continue;
                }
                values.add(item);
            }
            return values;
        }
        if (value.getClass().isArray()) {
            int n = Array.getLength(value);
            ArrayList<Object> values = new ArrayList<Object>();
            for (int i = 0; i < n; ++i) {
                Object item = Array.get(value, i);
                if (item == null) {
                    values.add(null);
                    continue;
                }
                values.add(item);
            }
            return values;
        }
        return Collections.singletonList(value);
    }

    public static boolean isBasicType(Object obj) {
        if (null == obj) {
            return true;
        }
        if (obj instanceof Character || obj instanceof CharSequence) {
            return true;
        }
        if (obj instanceof Number) {
            return true;
        }
        return obj instanceof Date;
    }
}

