/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.tool;

import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.ecp.framework.spring.SpringContextHolder;
import java.beans.PropertyDescriptor;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.beanutils.PropertyUtils;
import org.springframework.beans.BeanUtils;
import org.springframework.cglib.beans.BeanCopier;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;

public class BeanCopyUtil {
    public static final String GID_FIELD_NAME = "gid";

    private BeanCopyUtil() {
    }

    public static void copyProperties(Object source, Object target) {
        try {
            PropertyUtils.copyProperties((Object)target, (Object)source);
        }
        catch (Exception e) {
            throw new AbcServiceException("ABC.0015", "copyProperties\u5931\u8d25\u3002");
        }
    }

    public static void copyPropertiesTransferGid(Object source, Object target) {
        block4: {
            try {
                BeanUtils.copyProperties((Object)source, (Object)target, (String[])new String[]{GID_FIELD_NAME});
                PropertyDescriptor targetGidDes = PropertyUtils.getPropertyDescriptor((Object)target, (String)GID_FIELD_NAME);
                PropertyDescriptor sourceGidDes = PropertyUtils.getPropertyDescriptor((Object)source, (String)GID_FIELD_NAME);
                if (targetGidDes.equals(sourceGidDes)) break block4;
                Object sourceGid = PropertyUtils.getProperty((Object)source, (String)GID_FIELD_NAME);
                if (Long.class.equals(targetGidDes.getPropertyType())) {
                    Long gid = CastUtil.getLong(sourceGid);
                    PropertyUtils.setProperty((Object)target, (String)GID_FIELD_NAME, (Object)gid);
                    break block4;
                }
                if (String.class.equals(targetGidDes.getPropertyType())) {
                    String gid = CastUtil.getString(sourceGid);
                    PropertyUtils.setProperty((Object)target, (String)GID_FIELD_NAME, (Object)gid);
                    break block4;
                }
                throw new AbcServiceException("ABC.0015", "gid\u7c7b\u578b\u4e0d\u652f\u6301\u3002");
            }
            catch (Exception e) {
                throw new AbcServiceException("ABC.0015", "copyProperties\u5931\u8d25\u3002");
            }
        }
    }

    public static void copyPropertiesIgnoreMissType(Object source, Object target) {
        BeanCopier beanCopier = BeanCopier.create(source.getClass(), target.getClass(), (boolean)false);
        beanCopier.copy(source, target, null);
    }

    public static <T> boolean hasProperty(T t, String propName) {
        for (Class<?> clazz = t.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (!f.getName().equals(propName)) continue;
                return true;
            }
        }
        return false;
    }

    public static <T, R> R getProperty(T t, String propName) throws Exception {
        PropertyDescriptor proDescriptor = new PropertyDescriptor(propName, t.getClass());
        Method getMethod = proDescriptor.getReadMethod();
        Object o = getMethod.invoke(t, new Object[0]);
        return (R)o;
    }

    public static <T> void setProperty(T t, String propName, Object propValue) throws Exception {
        PropertyDescriptor proDescriptor = new PropertyDescriptor(propName, t.getClass());
        Method setMethod = proDescriptor.getWriteMethod();
        setMethod.invoke(t, propValue);
    }

    public static <T, R> R invokeMethod(T t, String method, Class<?>[] parameterTypes, Object ... arg) throws Exception {
        Method getMethod = t.getClass().getMethod(method, parameterTypes);
        Object o = getMethod.invoke(t, arg);
        return (R)o;
    }

    public static List<Object> getAnnotationClass(Class annotaionClass) {
        ArrayList<Object> resList = new ArrayList<Object>();
        ApplicationContext context = SpringContextHolder.INSTANCE.getApplicationContext();
        String[] controllerNames = context.getBeanNamesForAnnotation(annotaionClass);
        if (controllerNames == null) {
            return resList;
        }
        for (String name : controllerNames) {
            Object bean = context.getBean(name);
            resList.add(bean);
        }
        return resList;
    }

    public static List<Method> findMethodByAnnotation(Class<?> clazz, Class<? extends Annotation> methodAnnotation) {
        ArrayList<Method> list = new ArrayList<Method>();
        while (clazz != null) {
            Method[] methods = clazz.getDeclaredMethods();
            if (methods != null) {
                for (Method m : methods) {
                    Annotation annotation = m.getAnnotation(methodAnnotation);
                    if (annotation == null) continue;
                    list.add(m);
                }
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static Annotation findMethodAnnotation(Class<?> clazz, Method m, Class<? extends Annotation> methodAnnotation) {
        Annotation annotation = BeanCopyUtil.isSpringProxy(clazz) ? AnnotationUtils.findAnnotation((Method)m, methodAnnotation) : m.getAnnotation(methodAnnotation);
        return annotation;
    }

    public static List<Parameter> findParameterByAnnotation(Method method, Class annotationClass) {
        ArrayList<Parameter> list = new ArrayList<Parameter>();
        Parameter[] parameters = method.getParameters();
        if (parameters != null) {
            for (Parameter p : parameters) {
                if (!p.isAnnotationPresent(annotationClass)) continue;
                list.add(p);
            }
        }
        return list;
    }

    public static List<Field> findFieldsByAnnotation(Class clazz, Class annotationClass) {
        ArrayList<Field> list = new ArrayList<Field>();
        while (clazz != null) {
            Field[] fields;
            for (Field f : fields = clazz.getDeclaredFields()) {
                if (!f.isAnnotationPresent(annotationClass)) continue;
                list.add(f);
            }
            clazz = clazz.getSuperclass();
        }
        return list;
    }

    public static boolean isSpringProxy(Class cls) {
        boolean isSpringProxy;
        String name = cls.getName();
        boolean bl = isSpringProxy = name.indexOf("SpringCGLIB$$") >= 0;
        return isSpringProxy;
    }

    public static String getClassSimpleName(Class cls) {
        if (BeanCopyUtil.isSpringProxy(cls)) {
            String name = cls.getSimpleName();
            name = name.substring(0, name.indexOf("$$EnhancerBy"));
            return name;
        }
        return cls.getSimpleName();
    }

    public static Object findFieldsObjectByClass(Object targetObject, Class fieldClass) {
        for (Class<?> clazz = targetObject.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
            Field[] fields = clazz.getDeclaredFields();
            if (fields == null) continue;
            for (Field f : fields) {
                f.setAccessible(true);
                if (f.getType() != fieldClass) continue;
                try {
                    return f.get(targetObject);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        }
        return null;
    }
}

