/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.security.base64;

import com.ygsoft.abc.service.security.base64.Shared;
import java.io.IOException;
import java.io.InputStream;

public class Base64InputStream
extends InputStream {
    private InputStream inputStream;
    private int[] buffer;
    private int bufferCounter = 0;
    private boolean eof = false;

    public Base64InputStream(InputStream var1) {
        this.inputStream = var1;
    }

    @Override
    public int read() throws IOException {
        if (this.buffer == null || this.bufferCounter == this.buffer.length) {
            if (this.eof) {
                return -1;
            }
            this.acquire();
            if (this.buffer.length == 0) {
                this.buffer = null;
                return -1;
            }
            this.bufferCounter = 0;
        }
        return this.buffer[this.bufferCounter++];
    }

    private void acquire() throws IOException {
        int var7;
        char[] var1 = new char[4];
        int var2 = 0;
        do {
            int var3;
            if ((var3 = this.inputStream.read()) == -1) {
                if (var2 != 0) {
                    throw new IOException("Bad base64 stream");
                }
                this.buffer = new int[0];
                this.eof = true;
                return;
            }
            char var4 = (char)var3;
            if (Shared.chars.indexOf(var4) == -1 && var4 != Shared.pad) {
                if (var4 == '\r' || var4 == '\n') continue;
                throw new IOException("Bad base64 stream");
            }
            var1[var2++] = var4;
        } while (var2 < 4);
        boolean var6 = false;
        for (var2 = 0; var2 < 4; ++var2) {
            if (var1[var2] != Shared.pad) {
                if (!var6) continue;
                throw new IOException("Bad base64 stream");
            }
            if (var6) continue;
            var6 = true;
        }
        if (var1[3] == Shared.pad) {
            if (this.inputStream.read() != -1) {
                throw new IOException("Bad base64 stream");
            }
            this.eof = true;
            var7 = var1[2] == Shared.pad ? 1 : 2;
        } else {
            var7 = 3;
        }
        int var5 = 0;
        for (var2 = 0; var2 < 4; ++var2) {
            if (var1[var2] == Shared.pad) continue;
            var5 |= Shared.chars.indexOf(var1[var2]) << 6 * (3 - var2);
        }
        this.buffer = new int[var7];
        for (var2 = 0; var2 < var7; ++var2) {
            this.buffer[var2] = var5 >>> 8 * (2 - var2) & 0xFF;
        }
    }

    @Override
    public void close() throws IOException {
        this.inputStream.close();
    }
}

