/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.login;

import com.ygsoft.abc.service.cache.ContextContainerRedisClient;
import com.ygsoft.abc.service.cache.LoginContextRedisClient;
import com.ygsoft.abc.service.login.domain.vo.LoginContextVO;
import com.ygsoft.ecp.core.framework.web.CookieUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.RedisUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import java.util.Optional;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class ContextContainer {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ContextContainer.class);
    public static final String TOKEN_COOKIE_NAME = "ecp_token";
    public static final String OPENID_NAME = "openId";
    private final ThreadLocal<String> tlToken = new ThreadLocal();
    private final ContextContainerRedisClient ctxRedis = ContextContainerRedisClient.INSTANCE;
    public static final ContextContainer INSTANCE = new ContextContainer();

    private ContextContainer() {
    }

    private String createToken() {
        return UuidUtil.newUUID();
    }

    public void createAndSetToken(HttpServletRequest request, HttpServletResponse response) {
        this.createAndSetToken(request, response, null);
    }

    public String createAndSetToken(HttpServletRequest request, HttpServletResponse response, String userGid) {
        String openId;
        String token = this.createToken();
        this.tlToken.set(token);
        CookieUtils.setCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)TOKEN_COOKIE_NAME, (String)token, (int)-1);
        if (userGid != null) {
            this.ctxRedis.setToken(token, userGid);
        }
        if (null != (openId = this.getOpenIdFromRequest(request)) && !"".equals(openId)) {
            this.ctxRedis.setOpenId(openId, userGid);
        }
        return token;
    }

    public boolean checkAndSetToken(HttpServletRequest request, HttpServletResponse response) {
        String token = this.getToken(request);
        Cookie tokenCookie = CookieUtils.getCookie((HttpServletRequest)request, (String)TOKEN_COOKIE_NAME);
        if (token != null && !"".equals(token) && this.isUserExists(token)) {
            this.setToken(token);
            String userGid = this.getUserGid();
            if (userGid != null) {
                this.ctxRedis.setToken(token, userGid);
            }
            if (tokenCookie == null) {
                CookieUtils.setCookie((HttpServletRequest)request, (HttpServletResponse)response, (String)TOKEN_COOKIE_NAME, (String)token, (int)-1);
            }
            return true;
        }
        return false;
    }

    public boolean checkOpenIdAndCreateToken(HttpServletRequest request, HttpServletResponse response) {
        String userGid;
        String openId = this.getOpenIdFromRequest(request);
        if (null != openId && !"".equals(openId) && null != (userGid = this.ctxRedis.getOpenId(openId)) && !"".equals(userGid)) {
            this.createAndSetToken(request, response, userGid);
            return true;
        }
        return false;
    }

    public String getToken() {
        return this.tlToken.get();
    }

    public void setToken(String token) {
        this.tlToken.set(token);
    }

    public void clearToken() {
        String token = this.tlToken.get();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u6e05\u7406Redis\u4e2d\u7684\u7528\u6237\u4fe1\u606f\uff0ctoken\u4e3a[" + token + "]"));
        }
        if (token != null) {
            this.ctxRedis.delToken(token);
        }
    }

    public void clearOpenId(HttpServletRequest request) {
        String openId = this.getOpenIdFromRequest(request);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u6e05\u7406Redis\u4e2d\u7684\u7528\u6237\u4fe1\u606f\uff0copenId\u4e3a[" + openId + "]"));
        }
        if (openId != null) {
            this.ctxRedis.delOpenId(openId);
        }
    }

    public void clearToken(HttpServletRequest request, HttpServletResponse response) {
        this.clearToken();
        Cookie tokenCookie = CookieUtils.getCookie((HttpServletRequest)request, (String)TOKEN_COOKIE_NAME);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u6e05\u7406Cookie\u4e2d\u7684ecp_token[" + tokenCookie.getValue() + "]"));
        }
        Cookie c = new Cookie(TOKEN_COOKIE_NAME, null);
        CookieUtils.deleteCookie((HttpServletRequest)request, (HttpServletResponse)response, (Cookie)c);
    }

    public String getUserGid() {
        String token = this.tlToken.get();
        if (token != null) {
            return this.ctxRedis.getToken(token);
        }
        return null;
    }

    public LoginContextVO getLoginContextVO() {
        LoginContextVO context = new LoginContextVO();
        context.setChainId("-1");
        context.setChainName("\u8054\u8c03\u6d4b\u8bd5\u79df\u6237");
        context.setCompId("-1");
        context.setCompCode("-1");
        context.setUserId("-1");
        context.setDisplayname("\u8054\u8c03\u7528\u6237");
        context.setFullName("\u8054\u8c03\u7528\u6237");
        return context;
    }

    public Optional<LoginContextVO> getCurrentLoginContextVO() {
        String userGid = this.getUserGid();
        if (StringUtil.isEmptyString((String)userGid)) {
            return Optional.empty();
        }
        return Optional.ofNullable(LoginContextRedisClient.getObject(userGid, false));
    }

    public LoginContextVO createLoginContextVO(String tenantId, String orgId, String userId) {
        LoginContextVO context = new LoginContextVO();
        context.setChainId(tenantId);
        context.setCompId(orgId);
        context.setUserId(userId);
        return context;
    }

    public boolean isUserExists(HttpServletRequest request) {
        String token = this.getToken(request);
        return token != null && !"".equals(token) && this.isUserExists(token);
    }

    private boolean isUserExists(String token) {
        String userGid = this.ctxRedis.getToken(token);
        return userGid != null && RedisUtil.getRedisService().exists("abc:user:stopkey", userGid) == false;
    }

    private String getToken(HttpServletRequest request) {
        String token;
        Cookie tokenCookie = CookieUtils.getCookie((HttpServletRequest)request, (String)TOKEN_COOKIE_NAME);
        if (tokenCookie != null) {
            token = tokenCookie.getValue();
        } else {
            token = request.getHeader(TOKEN_COOKIE_NAME);
            if (token == null || "".equals(token)) {
                token = request.getParameter(TOKEN_COOKIE_NAME);
            }
        }
        return token;
    }

    private String getOpenIdFromRequest(HttpServletRequest request) {
        String openId = request.getParameter(OPENID_NAME);
        if (openId == null || "".equals(openId)) {
            openId = request.getHeader(OPENID_NAME);
        }
        return openId;
    }
}

