/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.http;

import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.http.DelegatingServletInputStream;
import com.ygsoft.abc.service.tool.EncryDesUtil;
import com.ygsoft.alibaba.fastjson.JSONObject;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Objects;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import org.apache.commons.io.IOUtils;

public class EcpDecryptRequestWrapper
extends HttpServletRequestWrapper {
    static final IEcpLog LOG = EcpLogFactory.getLog(EcpDecryptRequestWrapper.class);
    private HttpServletRequest request;
    private List<String> fields;
    private byte[] requestBody;

    public EcpDecryptRequestWrapper(HttpServletRequest request, List<String> fields) {
        super(request);
        this.request = request;
        this.fields = fields;
        this.readBody();
    }

    private void readBody() {
        ServletInputStream input = null;
        try {
            input = this.request.getInputStream();
            this.requestBody = IOUtils.toByteArray((InputStream)input);
            if (!Objects.isNull(this.requestBody)) {
                if (this.requestBody.length == 0) {
                } else {
                    this.doDecrypt();
                }
            }
        }
        catch (Exception e) {
            throw new AbcIOException("ABC.0014", "\u8bfb\u53d6\u8bf7\u6c42body\u5931\u8d25\u3002", e, new Object[0]);
        }
        finally {
            IOUtils.closeQuietly((InputStream)input);
        }
    }

    private void doDecrypt() {
        String data = new String(this.requestBody);
        JSONObject jsonObj = JSONObject.parseObject((String)data);
        for (String field : this.fields) {
            String value = (String)jsonObj.get((Object)field);
            if (StringUtil.isEmptyString((String)value)) continue;
            String decodeValue = EncryDesUtil.doDecodeByDefaultKey(value);
            jsonObj.put(field, (Object)decodeValue);
        }
        this.requestBody = jsonObj.toJSONString().getBytes();
    }

    public ServletInputStream getInputStream() throws IOException {
        String data = new String(this.requestBody);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(data.getBytes());
        return new DelegatingServletInputStream(byteArrayInputStream);
    }

    public BufferedReader getReader() throws IOException {
        return new BufferedReader(new InputStreamReader((InputStream)this.getInputStream()));
    }

    public String getBodyData() {
        String data = new String(this.requestBody);
        return data;
    }
}

