/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.filter;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ygsoft.abc.service.http.SimpleRequestWrapper;
import com.ygsoft.abc.service.tool.BadWordUtil;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.BlockIOUtil;
import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.abc.service.tool.UrlUtils;
import com.ygsoft.ecp.framework.security.ISecuritySerialize;
import com.ygsoft.ecp.security.SecuritySerialize;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.core.annotation.Order;
import org.springframework.http.HttpHeaders;

@WebFilter(urlPatterns={"/*"}, filterName="sensitiveWordFilter")
@Order(value=0x7FFFFFFF)
public class SensitiveWordFilter
implements Filter {
    private static final IEcpLog LOG = EcpLogFactory.getLog(SensitiveWordFilter.class);
    private static final String ERROR_MSG_KEY = "errMsg";
    private static final String ERROR_MSG = "\u8bf7\u6c42\u4fe1\u606f\u4e2d\u5305\u542b\u654f\u611f\u8bcd\u3002";
    private static final String REQUEST_METHOD_POST = "POST";
    private static final String CONTENT_TYPE_JSON = "json";
    private static final String CONTENT_TYPE_TEXT = "text";
    private static final String TRUE = "true";
    private static final String SECURITY_CHECK = "security.check";
    private static volatile ISecuritySerialize securitySerialize = null;
    private static final String NOFILTER_PATH = "classpath*:/META-INF/abc-config/sensitive_word.nofilter.url.properties";
    protected static final Set<String> EXCLUDE_PATH = new HashSet<String>();

    private String getFilterErrorUrl() {
        String url = PropertyConfigUtil.getProperty("server.vipaddress") + "/filter/error";
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("FILTER_ERROR_URL=" + url));
        }
        return url;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"sensitiveWordFilter init.");
        }
        if (PropertyConfigUtil.isInterceptSensitive()) {
            this.initExcludePath();
        } else if (LOG.isInfoEnabled()) {
            LOG.info((Object)"******\u654f\u611f\u8bcd\u68c0\u6d4b\u5df2\u5173\u95ed******");
        }
    }

    public void destroy() {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)"sensitiveWordFilter destroy.");
        }
    }

    private void initExcludePath() {
        block3: {
            EXCLUDE_PATH.add(this.getFilterErrorUrl());
            try {
                List<String> list = BlockIOUtil.readLines(NOFILTER_PATH);
                EXCLUDE_PATH.addAll(list);
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("\u654f\u611f\u8bcdexclude\u8def\u5f84\uff1a" + EXCLUDE_PATH));
                }
            }
            catch (Exception e) {
                if (!LOG.isWarnEnabled()) break block3;
                LOG.warn((Object)"\u8bfb\u53d6\u654f\u611f\u8bcdexclude\u8def\u5f84classpath*:/META-INF/abc-config/sensitive_word.nofilter.url.properties\u5931\u8d25**************\u786e\u8ba4\u65e0\u9700\u914d\u7f6e**************");
            }
        }
    }

    private boolean isExcludeUrl(String url) {
        return EXCLUDE_PATH.contains(url);
    }

    private boolean needCheck(HttpServletRequest httpRequest) {
        return PropertyConfigUtil.isInterceptSensitive() && this.isPostText(httpRequest);
    }

    private boolean isPostText(HttpServletRequest httpRequest) {
        String requestMethod = httpRequest.getMethod();
        String contentType = httpRequest.getContentType();
        return REQUEST_METHOD_POST.equalsIgnoreCase(requestMethod) && (contentType.contains(CONTENT_TYPE_JSON) || contentType.contains(CONTENT_TYPE_TEXT));
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        SimpleRequestWrapper wrapper;
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        if (!this.needCheck(httpRequest)) {
            chain.doFilter(request, response);
            return;
        }
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String url = UrlUtils.buildRequestUrl(httpRequest).split("\\?")[0];
        if (this.isExcludeUrl(url)) {
            chain.doFilter(request, (ServletResponse)httpResponse);
            return;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u672c\u6b21\u8bf7\u6c42\u8fdb\u884c\u654f\u611f\u8bcd\u68c0\u6d4b..." + url));
        }
        if (!this.checkRequestInfo((HttpServletRequest)(wrapper = new SimpleRequestWrapper(httpRequest)))) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)ERROR_MSG);
            }
            request.setAttribute(ERROR_MSG_KEY, (Object)ERROR_MSG);
            request.getRequestDispatcher(this.getFilterErrorUrl()).forward(request, response);
        } else {
            chain.doFilter((ServletRequest)wrapper, (ServletResponse)httpResponse);
        }
    }

    private boolean checkRequestInfo(HttpServletRequest httpRequest) {
        Enumeration paramNames = httpRequest.getParameterNames();
        while (paramNames.hasMoreElements()) {
            String paramName = (String)paramNames.nextElement();
            String paramValue = httpRequest.getParameter(paramName);
            if (!this.containsBadWord(paramValue)) continue;
            if (LOG.isWarnEnabled()) {
                LOG.warn((Object)String.format("\u8bf7\u6c42\u4fe1\u606f\uff1a%s : %s", paramName, paramValue));
            }
            return false;
        }
        String bodyData = this.getBodyData(httpRequest);
        if (StringUtil.isNullOrTrimEmptyString((String)bodyData)) {
            return true;
        }
        return !this.containsBadWord(this.parseJsonValue(bodyData));
    }

    private String getBodyData(HttpServletRequest httpRequest) {
        String bodyData = ((SimpleRequestWrapper)httpRequest).getBodyData();
        if (StringUtil.isNullOrTrimEmptyString((String)bodyData)) {
            return bodyData;
        }
        if (this.isSecurityCheck()) {
            Enumeration headerNames = httpRequest.getHeaderNames();
            HttpHeaders httpHeaders = new HttpHeaders();
            while (headerNames.hasMoreElements()) {
                String headerName = (String)headerNames.nextElement();
                httpHeaders.add(headerName, httpRequest.getHeader(headerName));
            }
            return this.getSecuritySerialize().decodeJsonString(bodyData, httpHeaders);
        }
        return bodyData;
    }

    private ISecuritySerialize getSecuritySerialize() {
        if (Objects.isNull(securitySerialize)) {
            securitySerialize = new SecuritySerialize();
        }
        return securitySerialize;
    }

    private boolean isSecurityCheck() {
        return TRUE.equalsIgnoreCase(PropertyConfigUtil.getProperty(SECURITY_CHECK));
    }

    private String parseJsonValue(String text) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("\u5f85\u8f6c\u6362\u7684\u6570\u636e\u4e3a\uff1a%s", text));
        }
        if (StringUtil.isNullOrTrimEmptyString((String)text)) {
            return text;
        }
        if (text.startsWith("{")) {
            return this.parseJsonValue((JSON)JSON.parseObject((String)text));
        }
        if (text.startsWith("[")) {
            return this.parseJsonValue((JSON)JSON.parseArray((String)text));
        }
        return text;
    }

    private String parseJsonValue(JSON json) {
        StringBuilder sb;
        block3: {
            block2: {
                sb = new StringBuilder();
                if (!JSONObject.class.equals(json.getClass())) break block2;
                JSONObject jsonObj = (JSONObject)json;
                for (Object value : jsonObj.values()) {
                    sb.append(this.parseValue(value) + ",");
                }
                break block3;
            }
            if (!JSONArray.class.equals(json.getClass())) break block3;
            JSONArray jsonArray = (JSONArray)json;
            for (Object value : jsonArray) {
                sb.append(this.parseValue(value) + ",");
            }
        }
        return sb.toString();
    }

    private String parseValue(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof JSON) {
            return this.parseJsonValue((JSON)value);
        }
        return value.toString();
    }

    private boolean containsBadWord(String txt) {
        if (StringUtil.isNullOrTrimEmptyString((String)txt)) {
            return false;
        }
        Set<String> words = BadWordUtil.getBadWord(txt);
        if (BlockCollectionUtil.isEmpty(words)) {
            return false;
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u654f\u611f\u8bcd\u68c0\u6d4b\u6587\u672c\u4e3a\uff1a" + txt));
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u68c0\u6d4b\u5230\u7684\u654f\u611f\u8bcd\u4e3a\uff1a" + words));
        }
        return true;
    }

    public static void main(String[] args) {
        String text = BlockIOUtil.readText("classpath:/temp/jsonValue.json");
        System.out.println(text);
        String json = text.replaceAll("\\s+", "");
        System.out.println(json);
        System.out.println(new SensitiveWordFilter().parseJsonValue(json));
    }
}

