/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.excel;

import com.alibaba.ans.shaded.com.alibaba.fastjson.JSON;
import com.alibaba.ans.shaded.com.taobao.vipserver.client.utils.CollectionUtils;
import com.ygsoft.abc.service.consts.ExcelConst;
import com.ygsoft.abc.service.excel.IExcelExportHandler;
import com.ygsoft.abc.service.excel.bo.ComboBO;
import com.ygsoft.abc.service.excel.bo.ExportColumnConfigBO;
import com.ygsoft.abc.service.excel.bo.ExportConfigBO;
import com.ygsoft.abc.service.excel.bo.ExportTableHeaderBO;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.abc.service.tool.ExcelUtil;
import com.ygsoft.ecp.service.exception.EcpRuntimeException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;

public abstract class AbstractMultiSheetExportHandler
implements IExcelExportHandler {
    private static final IEcpLog LOG = EcpLogFactory.getLog(AbstractMultiSheetExportHandler.class);
    private static final int TEN = 10;
    private static final int NUMBER256 = 256;
    private static final int NUMBER700 = 700;

    @Override
    public byte[] excuteExport(Map<String, Object> param, String configFilePath) {
        List<ExportConfigBO> sheetExportConfigs = this.readColumnRule(configFilePath);
        Map<String, List<Map<String, Object>>> exportDatas = this.getExportData(param);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u5f85\u5bfc\u51fa\u7684\u6570\u636e--->>>" + JSON.toJSONString(exportDatas)));
        }
        return this.createExcel(exportDatas, sheetExportConfigs);
    }

    @Override
    public byte[] executeExport(Map<String, List<Map<String, Object>>> exportDatas, String configFilePath) {
        List<ExportConfigBO> sheetExportConfigs = this.readColumnRule(configFilePath);
        return this.createExcel(exportDatas, sheetExportConfigs);
    }

    protected abstract Map<String, List<Map<String, Object>>> getExportData(Map<String, Object> var1);

    private byte[] createExcel(Map<String, List<Map<String, Object>>> exportDataMap, List<ExportConfigBO> sheetExportConfigs) {
        HSSFWorkbook workbook = new HSSFWorkbook();
        for (int configIndex = 0; configIndex < sheetExportConfigs.size(); ++configIndex) {
            ExportConfigBO exportConfigBO = sheetExportConfigs.get(configIndex);
            if (this.checkExportConfigIsNull(exportConfigBO)) continue;
            String sheetName = "sheet" + configIndex;
            if (null != exportConfigBO && !StringUtil.isNullOrTrimEmptyString((String)exportConfigBO.getSheetName())) {
                sheetName = exportConfigBO.getSheetName();
            }
            HSSFSheet sheet = workbook.createSheet(sheetName);
            int rowIndex = 0;
            HSSFRow firstRow = null;
            HSSFCell cell = null;
            CellStyle headerCellStyle = this.getTabHeaderCellStyle((Workbook)workbook);
            if (!StringUtil.isNullOrTrimEmptyString((String)exportConfigBO.getTitleName())) {
                firstRow = sheet.createRow(rowIndex);
                cell = firstRow.createCell(0);
                CellRangeAddress region = new CellRangeAddress(rowIndex, rowIndex, 0, exportConfigBO.getColNames().size() - 1);
                sheet.addMergedRegion(region);
                cell.setCellValue(exportConfigBO.getTitleName());
                cell.setCellStyle(headerCellStyle);
                ++rowIndex;
            }
            HashMap<Integer, Integer> columnWidthMap = new HashMap<Integer, Integer>();
            HashSet<Integer> colSpanIndexSet = new HashSet<Integer>();
            if (BlockCollectionUtil.isNotEmpty(exportConfigBO.getMultiHeaders())) {
                firstRow = sheet.createRow(rowIndex);
                for (ExportTableHeaderBO item : exportConfigBO.getMultiHeaders()) {
                    Integer startCellIndex = CastUtil.getIntegerDefaultZero(item.getStartIndex());
                    AbstractMultiSheetExportHandler.addElement(colSpanIndexSet, startCellIndex, item.getColSpan());
                    CellRangeAddress region = new CellRangeAddress(rowIndex, rowIndex, startCellIndex.intValue(), startCellIndex + CastUtil.getIntegerDefaultZero(item.getColSpan()) - 1);
                    sheet.addMergedRegion(region);
                    cell = firstRow.createCell(item.getStartIndex().intValue());
                    cell.setCellValue(item.getCaption());
                    cell.setCellStyle(headerCellStyle);
                    AbstractMultiSheetExportHandler.setColumnWidthMap(startCellIndex, cell.getStringCellValue(), columnWidthMap);
                    sheet.setColumnWidth(startCellIndex.intValue(), ((Integer)columnWidthMap.get(startCellIndex)).intValue());
                }
                ++rowIndex;
            }
            HSSFRow lastRow = sheet.createRow(rowIndex);
            for (int i = 0; i < exportConfigBO.getColNames().size(); ++i) {
                if (!colSpanIndexSet.isEmpty() && !colSpanIndexSet.contains(i)) {
                    CellRangeAddress region = new CellRangeAddress(rowIndex - 1, rowIndex, i, i);
                    sheet.addMergedRegion(region);
                    firstRow = sheet.getRow(rowIndex - 1);
                    cell = firstRow.createCell(i);
                    cell.setCellValue(exportConfigBO.getColNames().get(i));
                    cell.setCellStyle(headerCellStyle);
                } else {
                    cell = lastRow.createCell(i);
                    cell.setCellStyle(headerCellStyle);
                    cell.setCellValue(exportConfigBO.getColNames().get(i));
                }
                AbstractMultiSheetExportHandler.setColumnWidthMap(i, exportConfigBO.getColNames().get(i), columnWidthMap);
                sheet.setColumnWidth(i, ((Integer)columnWidthMap.get(i)).intValue());
            }
            ++rowIndex;
            Map<String, Integer> columnName2Index = this.getColumnName2IndexMap(exportConfigBO.getColModels());
            HashMap<String, CellStyle> columnTypeCellStyleMap = new HashMap<String, CellStyle>();
            if (null == exportDataMap || !exportDataMap.containsKey(sheetName)) {
                this.infoLog(String.format("\u5bfc\u51fa--\u5f85\u5bfc\u51fa\u6570\u636e\u4e2d\u6ca1\u6709sheetName=%s\u7684\u6570\u636e\u3002", sheetName));
                continue;
            }
            for (Map<String, Object> item : exportDataMap.get(sheetName)) {
                firstRow = sheet.createRow(rowIndex++);
                for (String rowKey : item.keySet()) {
                    Object value = item.get(rowKey);
                    int columnIndex = columnName2Index.get(rowKey);
                    cell = firstRow.createCell(columnIndex);
                    ExportColumnConfigBO columnConfig = this.getColumnConfig(exportConfigBO, rowKey);
                    this.setCellValue((Workbook)workbook, (Cell)cell, value, columnConfig);
                    CellStyle dataCellStyle = this.getCellStyleByColumnType((Workbook)workbook, columnConfig.getColumnType(), columnTypeCellStyleMap);
                    cell.setCellStyle(dataCellStyle);
                    AbstractMultiSheetExportHandler.setColumnWidthMap(columnIndex, cell.getStringCellValue(), columnWidthMap);
                    sheet.setColumnWidth(columnIndex, ((Integer)columnWidthMap.get(columnIndex)).intValue());
                }
            }
        }
        return ExcelUtil.workbookParseByte(workbook);
    }

    private boolean checkExportConfigIsNull(ExportConfigBO exportConfigBO) {
        return null == exportConfigBO || CollectionUtils.isEmpty(exportConfigBO.getColNames()) || CollectionUtils.isEmpty(exportConfigBO.getColModels());
    }

    private CellStyle getCellStyleByColumnType(Workbook workbook, String columnType, Map<String, CellStyle> columnTypeCellStyleMap) {
        if (columnTypeCellStyleMap.containsKey(columnType)) {
            return columnTypeCellStyleMap.get(columnType);
        }
        CellStyle cellStyle = this.getCommonCellStyle(workbook);
        switch (columnType) {
            case "string": {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                break;
            }
            case "date": {
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                break;
            }
            case "number": {
                cellStyle.setAlignment(HorizontalAlignment.RIGHT);
                break;
            }
            case "enum": {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                break;
            }
            default: {
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
            }
        }
        columnTypeCellStyleMap.put(columnType, cellStyle);
        return cellStyle;
    }

    private Map<String, Integer> getColumnName2IndexMap(List<ExportColumnConfigBO> columnConfigs) {
        HashMap<String, Integer> name2IndexMap = new HashMap<String, Integer>();
        for (int i = 0; i < columnConfigs.size(); ++i) {
            name2IndexMap.put(columnConfigs.get(i).getColumnName(), i);
        }
        return name2IndexMap;
    }

    public static void setColumnWidthMap(Integer columnIndex, String columnVal, Map<Integer, Integer> columnWidthMap) {
        String val = columnVal;
        if (StringUtil.isNullOrTrimEmptyString((String)val)) {
            val = "";
        }
        Integer colLength = val.getBytes().length * 256 + 700;
        if (!columnWidthMap.containsKey(columnIndex)) {
            columnWidthMap.put(columnIndex, colLength);
        }
        if (columnWidthMap.containsKey(columnIndex) && columnWidthMap.get(columnIndex) < colLength) {
            columnWidthMap.put(columnIndex, colLength);
        }
    }

    private static void addElement(Set<Integer> calSet, Integer startVal, Integer colSpan) {
        int start = CastUtil.getIntegerDefaultZero(startVal);
        calSet.add(start);
        int count = CastUtil.getIntegerDefaultZero(colSpan);
        if (count <= 0) {
            return;
        }
        for (int i = 1; i <= colSpan; ++i) {
            calSet.add(start + i);
        }
    }

    private ExportColumnConfigBO getColumnConfig(ExportConfigBO exportConfigBO, String columnKey) {
        if (StringUtil.isNullOrTrimEmptyString((String)columnKey) || BlockCollectionUtil.isEmpty(exportConfigBO.getColModels())) {
            return null;
        }
        for (ExportColumnConfigBO item : exportConfigBO.getColModels()) {
            if (!columnKey.equals(item.getColumnName())) continue;
            return item;
        }
        return null;
    }

    private void setCellValue(Workbook workbook, Cell cell, Object value, ExportColumnConfigBO columnConfig) {
        if (null == value || null == columnConfig) {
            cell.setCellValue("");
            return;
        }
        switch (columnConfig.getColumnType()) {
            case "string": {
                cell.setCellValue(value.toString());
                return;
            }
            case "number": {
                BigDecimal numValue = new BigDecimal(value.toString());
                cell.setCellValue(String.valueOf(numValue.setScale((int)columnConfig.getScale(), 4)));
                return;
            }
            case "date": {
                try {
                    SimpleDateFormat format = new SimpleDateFormat(columnConfig.getDateFormat());
                    cell.setCellValue(format.format((Date)value));
                }
                catch (Exception e) {
                    this.errorLog("\u65e5\u671f\u6570\u636e\u683c\u5f0f\u5316\u5f02\u5e38\uff0c" + value + "\u8f6c\u6362\u4e3a\uff1a" + columnConfig.getDateFormat(), e);
                }
                return;
            }
            case "enum": {
                cell.setCellValue(value.toString());
                if (BlockCollectionUtil.isEmpty(columnConfig.getData())) {
                    return;
                }
                for (ComboBO item : columnConfig.getData()) {
                    if (!String.valueOf(value).equals(item.getId())) continue;
                    cell.setCellValue(item.getText());
                    return;
                }
                return;
            }
        }
        cell.setCellValue(value.toString());
    }

    private List<ExportConfigBO> readColumnRule(String configFilePath) {
        if (StringUtil.isEmptyString((String)configFilePath)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_excuteExport_63", (String)"\u5bfc\u51fa-\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\u3002"));
        }
        String fileContent = this.readFile(configFilePath);
        if (StringUtil.isNullOrTrimEmptyString((String)fileContent)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readColumnRule_223", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002"));
        }
        List sheetConfigs = null;
        try {
            sheetConfigs = JSON.parseArray((String)fileContent, ExportConfigBO.class);
        }
        catch (Exception e) {
            String msg = "\u89e3\u6790\u5bfc\u51fa\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\u3002";
            this.errorLog("\u89e3\u6790\u5bfc\u51fa\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\u3002", e);
            throw new EcpRuntimeException("\u5bfc\u51fa\u5f02\u5e38", "\u89e3\u6790\u5bfc\u51fa\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38\u3002");
        }
        if (BlockCollectionUtil.isEmpty(sheetConfigs)) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readColumnRule_223", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u5185\u5bb9\u4e3a\u7a7a\u3002"));
        }
        for (int i = 0; i < sheetConfigs.size(); ++i) {
            ExportConfigBO item = (ExportConfigBO)((Object)sheetConfigs.get(i));
            if (this.checkExportConfigIsNull(item)) {
                this.infoLog(String.format("\u6570\u636e\u5bfc\u51fa--%s\u8def\u5f84\u4e0b\uff0c\u7b2c%s\u4e2asheet\u7684\u5bfc\u51fa\u914d\u7f6e\u4e3a\u7a7a\u3002", configFilePath, i + 1));
                continue;
            }
            this.checkColRule(item);
        }
        return sheetConfigs;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String readFile(String filePath) {
        StringBuilder rule;
        BufferedReader bufReader;
        block14: {
            bufReader = null;
            InputStream in = null;
            rule = new StringBuilder("");
            try {
                in = this.getClass().getResourceAsStream(filePath);
                bufReader = new BufferedReader(new InputStreamReader(in));
                String line = bufReader.readLine();
                while (StringUtil.isNotEmpty((String)line)) {
                    rule.append(line);
                    line = bufReader.readLine();
                }
                if (null == in) break block14;
            }
            catch (Exception e) {
                try {
                    String msg = EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)String.format("\u8bfb\u53d6\u6587\u4ef6\uff1a%s\u5931\u8d25,\u539f\u56e0\uff1a%s", filePath, e.getMessage()));
                    this.errorLog(msg, e);
                    throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", msg);
                }
                catch (Throwable throwable) {
                    if (null != in) {
                        try {
                            in.close();
                        }
                        catch (IOException e2) {
                            String msg = String.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a%s", e2.getMessage());
                            this.errorLog(msg, e2);
                            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)msg), (Throwable)e2, new Object[0]);
                        }
                    }
                    if (null == bufReader) throw throwable;
                    try {
                        bufReader.close();
                        throw throwable;
                    }
                    catch (IOException e3) {
                        String msg = String.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a%s", e3.getMessage());
                        this.errorLog(msg, e3);
                        throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)msg), (Throwable)e3, new Object[0]);
                    }
                }
            }
            try {
                in.close();
            }
            catch (IOException e) {
                String msg = String.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a%s", e.getMessage());
                this.errorLog(msg, e);
                throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)msg), (Throwable)e, new Object[0]);
            }
        }
        if (null == bufReader) return rule.toString();
        try {
            bufReader.close();
            return rule.toString();
        }
        catch (IOException e) {
            String msg = String.format("\u5173\u95ed\u6587\u4ef6\u6d41\u5931\u8d25\uff1a%s", e.getMessage());
            this.errorLog(msg, e);
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_readFile_258", (String)msg), (Throwable)e, new Object[0]);
        }
    }

    private void checkColRule(ExportConfigBO exportConfiBO) {
        for (ExportColumnConfigBO item : exportConfiBO.getColModels()) {
            this.checkColumnConfigError(item);
            if (StringUtil.isNullOrTrimEmptyString((String)item.getColumnType())) {
                item.setColumnType("string");
                continue;
            }
            String columnType = item.getColumnType().toLowerCase();
            if ("string".equals(columnType)) continue;
            if ("number".equals(columnType)) {
                if (null != item.getScale()) continue;
                item.setScale(0);
                continue;
            }
            if ("date".equals(columnType)) {
                if (null != item.getDateFormat()) continue;
                item.setDateFormat("yyyy-MM-dd");
                continue;
            }
            if (!"enum".equals(columnType) || !BlockCollectionUtil.isEmpty(item.getData())) continue;
            item.setData(new ArrayList<ComboBO>());
        }
    }

    private void checkColumnConfigError(ExportColumnConfigBO columnConfigBO) {
        if (StringUtil.isNullOrTrimEmptyString((String)columnConfigBO.getColumnName())) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_checkColRule_280", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u7f3a\u5931columnName\u914d\u7f6e\u9879\u3002"));
        }
        if (!ExcelConst.DATA_TYPES.containsKey(columnConfigBO.getColumnType())) {
            throw new EcpRuntimeException("\u5bfc\u5165\u51fa\u9519", EcpI18nUtil.localizedString((String)"RedisClientFactory_checkColRule_288", (String)"\u5217\u89c4\u5219\u914d\u7f6e\u6587\u4ef6\u4e2dcolumnType\u914d\u7f6e\u9879\u914d\u7f6e\u6709\u8bef\u3002"));
        }
    }

    public CellStyle getTabHeaderCellStyle(Workbook workbook) {
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        font.setBold(true);
        CellStyle cellStyle = workbook.createCellStyle();
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        cellStyle.setAlignment(HorizontalAlignment.CENTER);
        cellStyle.setFont(font);
        this.setCellBorder(cellStyle);
        return cellStyle;
    }

    private CellStyle getCommonCellStyle(Workbook workbook) {
        CellStyle cellStyle = workbook.createCellStyle();
        this.setCellBorder(cellStyle);
        Font font = workbook.createFont();
        font.setFontHeightInPoints((short)10);
        cellStyle.setFont(font);
        cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
        this.setCellBorder(cellStyle);
        return cellStyle;
    }

    private void setCellBorder(CellStyle cellStyle) {
        cellStyle.setBorderBottom(BorderStyle.THIN);
        cellStyle.setBorderLeft(BorderStyle.THIN);
        cellStyle.setBorderTop(BorderStyle.THIN);
        cellStyle.setBorderRight(BorderStyle.THIN);
    }

    private void infoLog(String msg) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)msg);
        }
    }

    private void errorLog(String msg, Exception e) {
        if (LOG.isErrorEnabled()) {
            LOG.error((Object)msg, (Throwable)e);
        }
    }
}

