/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.domain.vo;

import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.ygsoft.abc.service.domain.vo.FileNameVO;
import com.ygsoft.abc.service.exception.AbcIOException;
import com.ygsoft.abc.service.exception.PermissionException;
import com.ygsoft.abc.service.tool.AttachUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.model.IValueObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.web.multipart.MultipartFile;

public class FileUploadLimitVO
implements IValueObject {
    private static final IEcpLog LOG = EcpLogFactory.getLog(FileUploadLimitVO.class);
    private static final long serialVersionUID = 8242741356142955615L;
    private static final Map<String, String> FILE_HEAD_SUFFIX_MAP = new HashMap<String, String>();
    private static final Map<String, String> SUFFIX_FILE_HEAD_MAP = new HashMap<String, String>();
    private static final String LOCKED_FILE_HEAD = "452D536166654E6574";
    private List<String> allowFileTypes;
    private long fileSizeMax;
    private long fileSizeMin;
    private int maxCount;
    private boolean convertToPDF;

    private static void init() {
        SUFFIX_FILE_HEAD_MAP.put("jpg", "FFD8FF");
        SUFFIX_FILE_HEAD_MAP.put("jpeg", "FFD8FF");
        SUFFIX_FILE_HEAD_MAP.put("png", "89504E47");
        SUFFIX_FILE_HEAD_MAP.put("gif", "47494638");
        SUFFIX_FILE_HEAD_MAP.put("tif", "49492A00227105008037");
        SUFFIX_FILE_HEAD_MAP.put("bmp", "424D");
        SUFFIX_FILE_HEAD_MAP.put("doc", "D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("docx", "504B0304,D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("xls", "62142365,D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("xlsx", "62142365,D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("ppt", "62142365,D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("pptx", "62142365,D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("wps", "62142365,504B0304,D0CF11E0A1B11AE1");
        SUFFIX_FILE_HEAD_MAP.put("pdf", "255044462D312E");
        SUFFIX_FILE_HEAD_MAP.put("eml", "52656365697665643A20,46726F6D3A203D3F6762");
        SUFFIX_FILE_HEAD_MAP.put("vsd", "D0CF11E0A1B11AE10000");
        SUFFIX_FILE_HEAD_MAP.put("mdb", "5374616E64617264204A");
        SUFFIX_FILE_HEAD_MAP.put("ps", "252150532D41646F6265");
        SUFFIX_FILE_HEAD_MAP.put("dwg", "41433130");
        SUFFIX_FILE_HEAD_MAP.put("zip", "504B0304140000000800");
        SUFFIX_FILE_HEAD_MAP.put("rar", "526172211A0700CF9073");
        FILE_HEAD_SUFFIX_MAP.put("FFD8FF", "jpg");
        FILE_HEAD_SUFFIX_MAP.put("89504E47", "png");
        FILE_HEAD_SUFFIX_MAP.put("47494638", "gif");
        FILE_HEAD_SUFFIX_MAP.put("49492A00227105008037", "tif");
        FILE_HEAD_SUFFIX_MAP.put("424D", "bmp");
        FILE_HEAD_SUFFIX_MAP.put("3C21444F435459504520", "html");
        FILE_HEAD_SUFFIX_MAP.put("3C21646F637479706520", "htm");
        FILE_HEAD_SUFFIX_MAP.put("48544D4C207B0D0A0942", "css");
        FILE_HEAD_SUFFIX_MAP.put("696B2E71623D696B2E71", "js");
        FILE_HEAD_SUFFIX_MAP.put("7B5C727466315C616E73", "rtf");
        FILE_HEAD_SUFFIX_MAP.put("38425053000100000000", "psd");
        FILE_HEAD_SUFFIX_MAP.put("235468697320636F6E66", "ini");
        FILE_HEAD_SUFFIX_MAP.put("3C25402070616765206C", "jsp");
        FILE_HEAD_SUFFIX_MAP.put("3C3F786D6C2076657273", "xml");
        FILE_HEAD_SUFFIX_MAP.put("494E5345525420494E54", "sql");
        FILE_HEAD_SUFFIX_MAP.put("7061636B616765207765", "java");
        FILE_HEAD_SUFFIX_MAP.put("6C6F67346A2E726F6F74", "properties");
        FILE_HEAD_SUFFIX_MAP.put("46726F6D3A203D3F6762", "eml");
        FILE_HEAD_SUFFIX_MAP.put("52656365697665643A20", "eml");
        FILE_HEAD_SUFFIX_MAP.put("D0CF11E0A1B11AE1", "doc");
        FILE_HEAD_SUFFIX_MAP.put("504B0304140006000800", "docx");
        FILE_HEAD_SUFFIX_MAP.put("62142365", "xlsx");
        FILE_HEAD_SUFFIX_MAP.put("D0CF11E0A1B11AE10000", "wps");
        FILE_HEAD_SUFFIX_MAP.put("255044462D312E", "pdf");
        FILE_HEAD_SUFFIX_MAP.put("D0CF11E0A1B11AE10000", "vsd");
        FILE_HEAD_SUFFIX_MAP.put("5374616E64617264204A", "mdb");
        FILE_HEAD_SUFFIX_MAP.put("252150532D41646F6265", "ps");
        FILE_HEAD_SUFFIX_MAP.put("41433130", "dwg");
        FILE_HEAD_SUFFIX_MAP.put("2E524D46000000120001", "rmvb");
        FILE_HEAD_SUFFIX_MAP.put("464C5601050000000900", "flv");
        FILE_HEAD_SUFFIX_MAP.put("00000020667479706D70", "mp4");
        FILE_HEAD_SUFFIX_MAP.put("49443303000000002176", "mp3");
        FILE_HEAD_SUFFIX_MAP.put("000001BA210001000180", "mpg");
        FILE_HEAD_SUFFIX_MAP.put("3026B2758E66CF11A6D9", "wmv");
        FILE_HEAD_SUFFIX_MAP.put("52494646E27807005741", "wav");
        FILE_HEAD_SUFFIX_MAP.put("52494646D07D60074156", "avi");
        FILE_HEAD_SUFFIX_MAP.put("4D546864000000060001", "mid");
        FILE_HEAD_SUFFIX_MAP.put("504B0304140000000800", "zip");
        FILE_HEAD_SUFFIX_MAP.put("526172211A0700CF9073", "rar");
        FILE_HEAD_SUFFIX_MAP.put("504B03040A0000000000", "jar");
        FILE_HEAD_SUFFIX_MAP.put("4D616E69666573742D56", "mf");
        FILE_HEAD_SUFFIX_MAP.put("1F8B0800000000000000", "gz");
        FILE_HEAD_SUFFIX_MAP.put("6431303A637265617465", "torrent");
        FILE_HEAD_SUFFIX_MAP.put("6D6F6F76", "mov");
        FILE_HEAD_SUFFIX_MAP.put("FF575043", "wpd");
        FILE_HEAD_SUFFIX_MAP.put("CFAD12FEC5FD746F", "dbx");
        FILE_HEAD_SUFFIX_MAP.put("2142444E", "pst");
        FILE_HEAD_SUFFIX_MAP.put("AC9EBD8F", "qdf");
        FILE_HEAD_SUFFIX_MAP.put("E3828596", "pwl");
        FILE_HEAD_SUFFIX_MAP.put("2E7261FD", "ram");
        FILE_HEAD_SUFFIX_MAP.put("4D5A9000030000000400", "exe");
        FILE_HEAD_SUFFIX_MAP.put("406563686F206F66660D", "bat");
        FILE_HEAD_SUFFIX_MAP.put("CAFEBABE0000002E0041", "class");
        FILE_HEAD_SUFFIX_MAP.put("49545346030000006000", "chm");
        FILE_HEAD_SUFFIX_MAP.put("04000000010000001300", "mxp");
    }

    public static FileUploadLimitVO newInstance(String allowFileType, long fileSizeMax, int maxCount) {
        return FileUploadLimitVO.newInstance(allowFileType, fileSizeMax, maxCount, 10L, false);
    }

    public static FileUploadLimitVO newInstance(String allowFileType, long fileSizeMax) {
        return FileUploadLimitVO.newInstance(allowFileType, fileSizeMax, 1);
    }

    public static FileUploadLimitVO newInstance(String allowFileType, long fileSizeMax, int maxCount, long fileSizeMin) {
        return FileUploadLimitVO.newInstance(allowFileType, fileSizeMax, maxCount, fileSizeMin, false);
    }

    public static FileUploadLimitVO newInstance(String allowFileType, long fileSizeMax, int maxCount, long fileSizeMin, boolean convertToPDF) {
        Iterable iter = Splitter.on((String)",").trimResults().split((CharSequence)allowFileType);
        FileUploadLimitVO limitVO = new FileUploadLimitVO();
        limitVO.setAllowFileTypes(Lists.newArrayList((Iterable)iter));
        limitVO.setFileSizeMax(fileSizeMax);
        limitVO.setMaxCount(maxCount);
        limitVO.setFileSizeMin(fileSizeMin);
        limitVO.setConvertToPDF(convertToPDF);
        return limitVO;
    }

    public void check(byte[] fileData, String fileName, boolean strictFileType) {
        if ((long)fileData.length > this.fileSizeMax) {
            throw new AbcIOException("ABC.0014", "\u8d85\u8fc7\u6587\u4ef6\u5927\u5c0f\u4e0a\u9650\uff0c\u65e0\u6cd5\u4e0a\u4f20\u3002");
        }
        if ((long)fileData.length <= this.fileSizeMin) {
            throw new AbcIOException("ABC.0014", "\u6587\u4ef6\u8fc7\u5c0f\u6216\u8bfb\u53d6\u5931\u8d25\u3002");
        }
        FileNameVO fileNameVO = FileNameVO.newInstance(fileName);
        String ext = fileNameVO.getExt();
        boolean match = this.allowFileTypes.stream().anyMatch(ele -> ele.equalsIgnoreCase(ext));
        if (!match) {
            throw PermissionException.newInstance("\u4e0d\u652f\u6301\u6b64\u6587\u4ef6\u7c7b\u578b\u3002");
        }
        if (this.isLockedFile(fileData)) {
            throw new AbcIOException("ABC.0014", "\u8bf7\u52ff\u4e0a\u4f20\u52a0\u5bc6\u6587\u4ef6\u3002");
        }
        if (strictFileType) {
            String headOfFile = AttachUtil.getHeadOfFileType(fileData);
            boolean matched = this.allowFileTypes.stream().anyMatch(allowType -> {
                String headType = SUFFIX_FILE_HEAD_MAP.get(allowType.toLowerCase());
                if (Objects.isNull(headType) && LOG.isErrorEnabled()) {
                    LOG.error((Object)("\u6587\u4ef6\u7c7b\u578b\uff1a" + allowType + "\uff0c\u672a\u914d\u7f6e\u3002"));
                }
                return this.isCompatible(headOfFile, headType);
            });
            if (!matched) {
                throw PermissionException.newInstance("\u771f\u5b9e\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u3002");
            }
        }
    }

    public void check(MultipartFile file, boolean strictFileType) {
        if (file.getSize() > this.fileSizeMax) {
            throw new AbcIOException("ABC.0014", "\u8d85\u8fc7\u6587\u4ef6\u5927\u5c0f\u4e0a\u9650\uff0c\u65e0\u6cd5\u4e0a\u4f20\u3002");
        }
        if (file.getSize() <= this.fileSizeMin) {
            throw new AbcIOException("ABC.0014", "\u6587\u4ef6\u8fc7\u5c0f\u6216\u8bfb\u53d6\u5931\u8d25\u3002");
        }
        String fileName = file.getOriginalFilename();
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u4e0a\u4f20\u7684\u6587\u4ef6\u540d\u5b57\uff1a" + fileName));
        }
        FileNameVO fileNameVO = FileNameVO.newInstance(file);
        String ext = fileNameVO.getExt();
        boolean match = this.allowFileTypes.stream().anyMatch(ele -> ele.equalsIgnoreCase(ext));
        if (!match) {
            throw PermissionException.newInstance("\u4e0d\u652f\u6301\u6b64\u6587\u4ef6\u7c7b\u578b\u3002");
        }
        if (this.isLockedFile(file)) {
            throw new AbcIOException("ABC.0014", "\u8bf7\u52ff\u4e0a\u4f20\u52a0\u5bc6\u6587\u4ef6\u3002");
        }
        if (strictFileType) {
            String headOfFile = AttachUtil.getHeadOfFileType(file);
            boolean matched = this.allowFileTypes.stream().anyMatch(allowType -> {
                String headType = SUFFIX_FILE_HEAD_MAP.get(allowType.toLowerCase());
                if (Objects.isNull(headType) && LOG.isErrorEnabled()) {
                    LOG.error((Object)("\u6587\u4ef6\u7c7b\u578b\uff1a" + allowType + "\uff0c\u672a\u914d\u7f6e\u3002"));
                }
                return this.isCompatible(headOfFile, headType);
            });
            if (!matched) {
                throw PermissionException.newInstance("\u771f\u5b9e\u6587\u4ef6\u7c7b\u578b\u4e0d\u652f\u6301\u3002");
            }
        }
    }

    private boolean isLockedFile(MultipartFile file) {
        String headOfFile = AttachUtil.getHeadOfFileType(file, 56);
        String lockedString = headOfFile.substring(24, 42);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5934\u524d56\u5b57\u8282\u4e3a\uff1a%s", headOfFile));
        }
        return lockedString.contains(LOCKED_FILE_HEAD);
    }

    private boolean isLockedFile(byte[] fileData) {
        String headOfFile = AttachUtil.getHeadOfFileType(fileData, 56);
        String lockedString = headOfFile.substring(24, 42);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)String.format("\u4e0a\u4f20\u6587\u4ef6\u8bf7\u6c42\u5934\u524d56\u5b57\u8282\u4e3a\uff1a%s", headOfFile));
        }
        return lockedString.contains(LOCKED_FILE_HEAD);
    }

    private boolean isCompatible(String headOfFile, String headOfSuffix) {
        String[] arr;
        for (String type : arr = headOfSuffix.split(",")) {
            if (!headOfFile.startsWith(type)) continue;
            return true;
        }
        return false;
    }

    public void check(MultipartFile file) {
        this.check(file, false);
    }

    public List<String> getAllowFileTypes() {
        return this.allowFileTypes;
    }

    public void setAllowFileTypes(List<String> newAllowFileTypes) {
        this.allowFileTypes = newAllowFileTypes;
    }

    public long getFileSizeMax() {
        return this.fileSizeMax;
    }

    public void setFileSizeMax(long newFileSizeMax) {
        this.fileSizeMax = newFileSizeMax;
    }

    public long getFileSizeMin() {
        return this.fileSizeMin;
    }

    public void setFileSizeMin(long newFileSizeMin) {
        this.fileSizeMin = newFileSizeMin;
    }

    public int getMaxCount() {
        return this.maxCount;
    }

    public void setMaxCount(int newMaxCount) {
        this.maxCount = newMaxCount;
    }

    public boolean isConvertToPDF() {
        return this.convertToPDF;
    }

    public void setConvertToPDF(boolean newConvertToPDF) {
        this.convertToPDF = newConvertToPDF;
    }

    static {
        FileUploadLimitVO.init();
    }
}

