/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.domain.bo;

import com.google.common.collect.Lists;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.abc.service.tool.BlockCollectionUtil;
import com.ygsoft.abc.service.tool.CastUtil;
import com.ygsoft.alibaba.fastjson.JSON;
import com.ygsoft.ecp.service.tool.JSONUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class ObjectPropertyChange
implements Serializable {
    private static final long serialVersionUID = -7069557812349040028L;
    private static final String CLASS_KEY = "jcls";
    private static final String GID_KEY = "gid";
    private static final String FIELD_CHANGE_PATTERN = ",%s:%s->%s";
    private Map<String, Object> source;
    private Map<String, Object> update;

    public static ObjectPropertyChange newInstance(Object source) {
        ObjectPropertyChange entity = new ObjectPropertyChange();
        entity.setSource(source);
        return entity;
    }

    private String traceChangeWithFields(Collection<String> fields) {
        if (!this.sameType()) {
            throw new AbcServiceException("ABC.0015", "\u7c7b\u578b\u4e0d\u4e00\u81f4\u3002");
        }
        if (!this.sameGid()) {
            throw new AbcServiceException("ABC.0015", "gid\u4e0d\u4e00\u81f4\u3002");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("{gid:" + this.source.get(GID_KEY));
        for (String field : fields) {
            Object updateValue;
            Object sourceValue = this.source.get(field);
            if (this.same(sourceValue, updateValue = this.update.get(field))) continue;
            sb.append(this.buildFieldChange(field, sourceValue, updateValue));
        }
        sb.append("}");
        return sb.toString();
    }

    private String buildFieldChange(String field, Object sourceValue, Object updateValue) {
        return String.format(FIELD_CHANGE_PATTERN, field, sourceValue, updateValue);
    }

    public String traceChange() {
        Set<String> fields = this.source.keySet();
        return this.traceChangeWithFields(fields);
    }

    public String traceInclude(String ... fields) {
        if (null == fields || fields.length == 0) {
            throw new AbcServiceException("ABC.0015", "\u6307\u5b9a\u5b57\u6bb5fields\u4e3a\u7a7a\u3002");
        }
        return this.traceInclude(Lists.newArrayList((Object[])fields));
    }

    public String traceInclude(List<String> fields) {
        if (BlockCollectionUtil.isEmpty(fields)) {
            throw new AbcServiceException("ABC.0015", "\u6307\u5b9a\u5b57\u6bb5fields\u4e3a\u7a7a\u3002");
        }
        return this.traceChangeWithFields(fields);
    }

    public String traceExclude(String ... fields) {
        if (null == fields || fields.length == 0) {
            throw new AbcServiceException("ABC.0015", "\u6392\u9664\u5b57\u6bb5fields\u4e3a\u7a7a\u3002");
        }
        return this.traceExclude(Lists.newArrayList((Object[])fields));
    }

    public String traceExclude(List<String> fields) {
        if (BlockCollectionUtil.isEmpty(fields)) {
            throw new AbcServiceException("ABC.0015", "\u6392\u9664\u5b57\u6bb5fields\u4e3a\u7a7a\u3002");
        }
        Set<String> allFields = this.source.keySet();
        allFields.removeAll(fields);
        return this.traceChangeWithFields(allFields);
    }

    private boolean same(Object obj1, Object obj2) {
        if (Objects.isNull(obj1)) {
            return Objects.isNull(obj2);
        }
        return obj1.equals(obj2);
    }

    private boolean sameType() {
        String clazz = CastUtil.getString(this.source.get(CLASS_KEY));
        if (StringUtil.isNullOrTrimEmptyString((String)clazz)) {
            return false;
        }
        return clazz.equals(this.update.get(CLASS_KEY));
    }

    private boolean sameGid() {
        String sourceGid = CastUtil.getString(this.source.get(GID_KEY));
        if (StringUtil.isNullOrTrimEmptyString((String)sourceGid)) {
            return false;
        }
        String updateGid = CastUtil.getString(this.update.get(GID_KEY));
        return sourceGid.equals(updateGid);
    }

    Map<String, Object> objectToMap(Object object) {
        String jsonStr = JSONUtil.toJsonString((Object)object);
        return (Map)JSON.parseObject((String)jsonStr, Map.class);
    }

    public Map<String, Object> getSource() {
        return this.source;
    }

    public void setSource(Object source) {
        this.source = this.objectToMap(source);
    }

    public Map<String, Object> getUpdate() {
        return this.update;
    }

    public void setUpdate(Object update) {
        this.update = this.objectToMap(update);
    }
}

