/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache.domain.vo;

import com.ygsoft.abc.service.tool.PropertyConfigUtil;
import com.ygsoft.ecp.service.cache.util.CacheConfigUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.model.IValueObject;
import com.ygsoft.ecp.service.tool.ClassUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class RedisConfVO
implements IValueObject {
    private static final long serialVersionUID = -5552867142373106648L;
    private static final IEcpLog LOG = EcpLogFactory.getLog(RedisConfVO.class);
    private boolean cluster;
    private List<String> serverList;
    private String password;
    private int database;
    private String appId;

    public static RedisConfVO readConfig() {
        String server = PropertyConfigUtil.getProperty("cache.redis.server");
        String appId = PropertyConfigUtil.getProperty("cache.tenant.appid");
        RedisConfVO configVO = new RedisConfVO();
        RedisConfigParam param = RedisConfVO.parse(server);
        configVO.setCluster(param.isCuster());
        configVO.setServerList(param.getServerUrls());
        configVO.setPassword(param.getPassword());
        configVO.setDatabase(0);
        configVO.setAppId(appId);
        return configVO;
    }

    private static RedisConfigParam parse(String server) {
        RedisConfigParam redisConfigParam = new RedisConfigParam();
        String pureServer = server;
        if (server.contains("?")) {
            String[] arr = server.split("\\?");
            pureServer = arr[0];
            ArrayList<String> servers = new ArrayList<String>();
            String[] urls = pureServer.split(",");
            for (int i = 0; i < urls.length; ++i) {
                servers.add(urls[i]);
            }
            redisConfigParam.serverUrls = servers;
            String param = arr[1];
            Map<String, String> paramMap = RedisConfVO.analysisParam(param);
            String requirepass = paramMap.get("requirepass");
            if (paramMap.containsKey("encryptpwd") && Boolean.parseBoolean(paramMap.get("encryptpwd"))) {
                requirepass = requirepass.startsWith("sm4cbc") ? RedisConfVO.decryptSm4cbcPwd(requirepass, arr[0], "com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil") : RedisConfVO.decryptPwd(requirepass, arr[0], null);
            }
            redisConfigParam.password = requirepass;
            String cluster = paramMap.get("cluster");
            if (StringUtil.isNullOrTrimEmptyString((String)cluster)) {
                redisConfigParam.custer = false;
            } else {
                redisConfigParam.custer = "true".equals(cluster);
            }
        } else {
            ArrayList<String> servers = new ArrayList<String>();
            String[] urls = server.split(",");
            for (int i = 0; i < urls.length; ++i) {
                servers.add(urls[i]);
            }
            redisConfigParam.serverUrls = servers;
        }
        return redisConfigParam;
    }

    private static String decryptPwd(String cipherText, String key, Class<?> sm4Clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("redis\u5bc6\u7801\u5df2\u52a0\u5bc6.\u5bc6\u6587\u4e3a[" + cipherText + "]"));
        }
        if (!RedisConfVO.checkHex(cipherText)) {
            throw new RuntimeException("\u5f53\u524dredis\u5bc6\u7801\u7684\u5bc6\u6587\u4e0d\u662f\u5341\u516d\u8fdb\u5236\u683c\u5f0f.cipherText=" + cipherText);
        }
        String pwd = null;
        try {
            Class clazz;
            String realKey = RedisConfVO.getRealKey(key);
            String realKeyHex = RedisConfVO.getHexString(realKey.getBytes(), false);
            if (System.getProperty("cache.redis.print.encryptkey") != null) {
                LOG.info((Object)("cache.redis.encrypt.key=[" + realKey + "], hex=" + realKeyHex));
            }
            if ((clazz = sm4Clazz) == null) {
                clazz = ClassUtil.forName((String)"com.ygsoft.ecp.core.service.encrypt.util.SM4EncryptUtil");
            }
            pwd = (String)ClassUtil.callMethod((Class)clazz, (String)"decodeStr", (Object[])new Object[]{cipherText, realKeyHex, "UTF-8"});
        }
        catch (Throwable e) {
            throw new RuntimeException("\u89e3\u5bc6redis\u5bc6\u7801\u5931\u8d25.cipherText=" + cipherText, e);
        }
        return pwd;
    }

    private static String decryptSm4cbcPwd(String cipherText, String key, String sm4Clazz) {
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("redis\u5bc6\u7801\u5df2\u52a0\u5bc6.\u5bc6\u6587\u4e3a[" + cipherText + "]"));
        }
        String toCheckCipherText = cipherText;
        if ("com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil".equals(sm4Clazz) && cipherText.startsWith("sm4cbc")) {
            toCheckCipherText = cipherText.substring("sm4cbc".length());
        }
        if (!RedisConfVO.checkHex(toCheckCipherText)) {
            throw new RuntimeException("\u5f53\u524dredis\u5bc6\u7801\u7684\u5bc6\u6587\u4e0d\u662f\u5341\u516d\u8fdb\u5236\u683c\u5f0f.cipherText=" + cipherText);
        }
        String pwd = null;
        try {
            String method;
            Object[] params;
            String realKeyHex = CacheConfigUtil.JDBC_PASSWD_ENCODE_KEY;
            if (System.getProperty("cache.redis.print.encryptkey") != null) {
                LOG.info((Object)("cache.redis.encrypt.key.hex=" + realKeyHex));
            }
            if (sm4Clazz.equals("com.ygsoft.ecp.core.service.encrypt.util.SM4CBCUtil")) {
                params = new Object[]{realKeyHex, toCheckCipherText};
                method = "uncoverMsg";
            } else {
                params = new Object[]{toCheckCipherText, realKeyHex, "UTF-8"};
                method = "decodeStr";
            }
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Class<?> clazz = classLoader.loadClass(sm4Clazz);
            pwd = (String)ClassUtil.callMethod(clazz, (String)method, (Object[])params);
        }
        catch (Throwable e) {
            throw new RuntimeException("\u89e3\u5bc6redis\u5bc6\u7801\u5931\u8d25.cipherText=" + cipherText, e);
        }
        return pwd;
    }

    private static boolean checkHex(String hex) {
        for (int i = 0; i < hex.length(); ++i) {
            boolean valid;
            char chr = hex.charAt(i);
            boolean bl = valid = chr >= 'a' && chr <= 'f' || chr >= '0' && chr <= '9';
            if (valid) continue;
            return false;
        }
        return true;
    }

    private static String getRealKey(String key) {
        int addCount;
        char[] salts = new char[]{'y', 'o', 'u', 'a', 'r', 'e', 'h', 'a', 'c', 'k', 'e', 'r'};
        StringBuilder tempBuf = new StringBuilder();
        char[] chars = key.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            int mode = chars[i] % salts.length;
            tempBuf.append(chars[i]);
            tempBuf.append(salts[mode]);
        }
        String realKey = tempBuf.toString();
        for (int i = addCount = realKey.length() % 16; i < 16; ++i) {
            realKey = realKey + " ";
        }
        return realKey;
    }

    private static String getHexString(byte[] bytes, boolean upperCase) {
        String ret = "";
        for (int i = 0; i < bytes.length; ++i) {
            ret = ret + Integer.toString((bytes[i] & 0xFF) + 256, 16).substring(1);
        }
        if (upperCase) {
            return ret.toUpperCase();
        }
        return ret;
    }

    private static Map<String, String> analysisParam(String paramString) {
        return Arrays.asList(paramString.split("\\&")).stream().collect(Collectors.toMap(RedisConfVO::preEqualSign, RedisConfVO::nextEqualSign));
    }

    private static String preEqualSign(String equalSignData) {
        return equalSignData.split("\\=")[0];
    }

    private static String nextEqualSign(String equalSignData) {
        return equalSignData.split("\\=")[1];
    }

    public boolean isCluster() {
        return this.cluster;
    }

    public void setCluster(boolean newCluster) {
        this.cluster = newCluster;
    }

    public List<String> getServerList() {
        return this.serverList;
    }

    public void setServerList(List<String> newServerList) {
        this.serverList = newServerList;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String newPassword) {
        this.password = newPassword;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int newDatabase) {
        this.database = newDatabase;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    static class RedisConfigParam {
        private List<String> serverUrls;
        private boolean custer;
        private String password;

        RedisConfigParam() {
        }

        public List<String> getServerUrls() {
            return this.serverUrls;
        }

        public void setServerUrls(List<String> serverUrls) {
            this.serverUrls = serverUrls;
        }

        public boolean isCuster() {
            return this.custer;
        }

        public void setCuster(boolean custer) {
            this.custer = custer;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

