/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.ygsoft.abc.service.cache.domain.vo.RedisConfVO;
import com.ygsoft.abc.service.exception.AbcServiceException;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StringUtil;
import org.redisson.Redisson;
import org.redisson.api.RedissonClient;
import org.redisson.config.ClusterServersConfig;
import org.redisson.config.Config;
import org.redisson.config.SingleServerConfig;

public final class RedissonClientFactory {
    private static final IEcpLog LOG = EcpLogFactory.getLog(RedissonClientFactory.class);
    private static RedissonClient redissonClient;

    private RedissonClientFactory() {
    }

    public static RedissonClient getRedissonClient() {
        return RedissonClientEnum.SINGLE.getClient();
    }

    private static enum RedissonClientEnum {
        SINGLE;


        private RedissonClientEnum() {
            RedisConfVO configVO = RedisConfVO.readConfig();
            Config config = new Config();
            if (configVO.isCluster()) {
                ClusterServersConfig clusterConfig = config.useClusterServers();
                for (String serverUrl : configVO.getServerList()) {
                    clusterConfig.addNodeAddress(new String[]{String.format("redis://%s", serverUrl)});
                }
                if (StringUtil.isNotEmpty((String)configVO.getPassword())) {
                    clusterConfig.setPassword(configVO.getPassword());
                }
            } else {
                String serverUrl = configVO.getServerList().get(0);
                SingleServerConfig singleConfig = config.useSingleServer();
                singleConfig.setAddress(String.format("redis://%s", serverUrl));
                if (StringUtil.isNotEmpty((String)configVO.getPassword())) {
                    singleConfig.setPassword(configVO.getPassword());
                }
                singleConfig.setDatabase(0);
            }
            try {
                redissonClient = Redisson.create((Config)config);
            }
            catch (Exception e) {
                if (LOG.isErrorEnabled()) {
                    LOG.error((Object)("RedissonClientFactory\u521b\u5efaRedissonClient\u5931\u8d25:" + e.getMessage()), (Throwable)e);
                }
                throw new AbcServiceException("ABC.0015", "RedissonClientFactory\u521b\u5efaRedissonClient\u5931\u8d25.", e, new Object[0]);
            }
        }

        public RedissonClient getClient() {
            return redissonClient;
        }
    }
}

