/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.ygsoft.abc.service.cache.IRedisService;
import com.ygsoft.abc.service.cache.RedisClientFactory;
import com.ygsoft.abc.service.exception.CacheException;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.EcpI18nUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.springframework.stereotype.Service;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.Tuple;

@Service
@Deprecated
public class RedisService
implements IRedisService {
    static final IEcpLog LOG = EcpLogFactory.getLog(RedisService.class);

    @Override
    public Long append(String cacheName, String key, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.append(this.genKey(cacheName, key), value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public <R> R batchExecute(Function<Jedis, R> callback) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                PreconditionUtil.checkNotNull(jedis, "getRedisConn is null.");
                R r = callback.apply(jedis);
                return r;
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long decr(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.decr(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long decrBy(String cacheName, String key, long index) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.decrBy(this.genKey(cacheName, key), index);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Boolean exists(String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Boolean bl = jedis.exists(key);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Boolean exists(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Boolean bl = jedis.exists(this.genKey(cacheName, key));
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long expire(String cacheName, String key, int seconds) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.expire(this.genKey(cacheName, key), seconds);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long expire(String key, int seconds) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.expire(key, seconds);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long expireAt(String cacheName, String key, long unixTime) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.expireAt(this.genKey(cacheName, key), unixTime);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String get(String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.get(key);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String get(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.get(this.genKey(cacheName, key));
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String getSet(String cacheName, String key, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.getSet(this.genKey(cacheName, key), value);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Boolean getbit(String cacheName, String key, long offset) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Boolean bl = jedis.getbit(this.genKey(cacheName, key), offset);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String getrange(String cacheName, String key, long startOffset, long endOffset) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.getrange(this.genKey(cacheName, key), startOffset, endOffset);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long hdel(String cacheName, String key, String ... fields) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.hdel(this.genKey(cacheName, key), fields);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Boolean hexists(String cacheName, String key, String field) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Boolean bl = jedis.hexists(this.genKey(cacheName, key), field);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String hget(String cacheName, String key, String field) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.hget(this.genKey(cacheName, key), field);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Map<String, String> hgetAll(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Map map = jedis.hgetAll(this.genKey(cacheName, key));
                    return map;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long hincrBy(String cacheName, String key, String field, long value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.hincrBy(this.genKey(cacheName, key), field, value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> hkeys(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.hkeys(this.genKey(cacheName, key));
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long hlen(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.hlen(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> hmget(String cacheName, String key, String ... fields) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    List list = jedis.hmget(this.genKey(cacheName, key), fields);
                    return list;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String hmset(String cacheName, String key, Map<String, String> hash) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.hmset(this.genKey(cacheName, key), hash);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long hset(String cacheName, String key, String field, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.hset(this.genKey(cacheName, key), field, value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long hsetnx(String cacheName, String key, String field, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.hsetnx(this.genKey(cacheName, key), field, value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> hvals(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    List list = jedis.hvals(this.genKey(cacheName, key));
                    return list;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long incr(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.incr(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long incrBy(String cacheName, String key, long index) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.incrBy(this.genKey(cacheName, key), index);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String lindex(String cacheName, String key, long index) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.lindex(this.genKey(cacheName, key), index);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long llen(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.llen(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String lpop(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.lpop(this.genKey(cacheName, key));
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long lpush(String cacheName, String key, String ... values) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.lpush(this.genKey(cacheName, key), values);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long lpushx(String cacheName, String key, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.lpushx(this.genKey(cacheName, key), new String[]{value});
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> lrange(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    List list = jedis.lrange(this.genKey(cacheName, key), start, end);
                    return list;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long lrem(String cacheName, String key, long count, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.lrem(this.genKey(cacheName, key), count, value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String lset(String cacheName, String key, long index, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.lset(this.genKey(cacheName, key), index, value);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String ltrim(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.ltrim(this.genKey(cacheName, key), start, end);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String rpop(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.rpop(this.genKey(cacheName, key));
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long rpush(String cacheName, String key, String ... values) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.rpush(this.genKey(cacheName, key), values);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long rpushx(String cacheName, String key, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.rpushx(this.genKey(cacheName, key), new String[]{value});
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long sadd(String cacheName, String key, String ... members) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.sadd(this.genKey(cacheName, key), members);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long sadd(String key, String ... members) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.sadd(key, members);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long scard(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.scard(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String set(String cacheName, String key, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.set(this.genKey(cacheName, key), value);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public boolean set(String cacheName, String key, String value, int seconds) {
        return this.setex(cacheName, key, value, seconds);
    }

    @Override
    public Boolean setbit(String cacheName, String key, long offset, boolean value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Boolean bl = jedis.setbit(this.genKey(cacheName, key), offset, value);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String setex(String cacheName, String key, int seconds, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.setex(this.genKey(cacheName, key), seconds, value);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public boolean setex(String key, String value, int seconds) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String result = jedis.setex(key, seconds, value);
                    boolean bl = "OK".equals(result);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return false;
    }

    public boolean setex(String cacheName, String key, String value, int seconds) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String result = jedis.setex(this.genKey(cacheName, key), seconds, value);
                    boolean bl = "OK".equals(result);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return false;
    }

    @Override
    public Long setnx(String cacheName, String key, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.setnx(this.genKey(cacheName, key), value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public boolean setnx(String cacheName, String key, String value, int seconds) {
        return false;
    }

    @Override
    public Long setrange(String cacheName, String key, long offset, String value) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.setrange(this.genKey(cacheName, key), offset, value);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Boolean sismember(String cacheName, String key, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Boolean bl = jedis.sismember(this.genKey(cacheName, key), member);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public boolean sismember(String key, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    boolean bl = jedis.sismember(key, member);
                    return bl;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return false;
    }

    @Override
    public Set<String> smembers(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.smembers(this.genKey(cacheName, key));
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> sort(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    List list = jedis.sort(this.genKey(cacheName, key));
                    return list;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String spop(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.spop(this.genKey(cacheName, key));
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String srandmember(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.srandmember(this.genKey(cacheName, key));
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long srem(String cacheName, String key, String ... members) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.srem(this.genKey(cacheName, key), members);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String substr(String cacheName, String key, int start, int end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.substr(this.genKey(cacheName, key), start, end);
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long ttl(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.ttl(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public String type(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    String string = jedis.type(this.genKey(cacheName, key));
                    return string;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zadd(String cacheName, String key, double score, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zadd(this.genKey(cacheName, key), score, member);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zadd(String cacheName, String key, Map<Double, String> scoreMembers) {
        if (this.isEnabled() && scoreMembers != null && !scoreMembers.isEmpty()) {
            for (Map.Entry<Double, String> entry : scoreMembers.entrySet()) {
                this.zadd(cacheName, key, entry.getKey(), entry.getValue());
            }
        }
        return null;
    }

    @Override
    public Long zcard(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zcard(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zcount(String cacheName, String key, double min, double max) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zcount(this.genKey(cacheName, key), min, max);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zcount(String cacheName, String key, String min, String max) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zcount(this.genKey(cacheName, key), min, max);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Double zincrby(String cacheName, String key, double score, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Double d = jedis.zincrby(this.genKey(cacheName, key), score, member);
                    return d;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrange(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrange(this.genKey(cacheName, key), start, end);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrangeByScore(String cacheName, String key, double min, double max, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScore(this.genKey(cacheName, key), min, max, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrangeByScore(String cacheName, String key, double min, double max) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScore(this.genKey(cacheName, key), min, max);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrangeByScore(String cacheName, String key, String min, String max, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScore(this.genKey(cacheName, key), min, max, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrangeByScore(String cacheName, String key, String min, String max) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScore(this.genKey(cacheName, key), min, max);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String cacheName, String key, double min, double max, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScoreWithScores(this.genKey(cacheName, key), min, max, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String cacheName, String key, double min, double max) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScoreWithScores(this.genKey(cacheName, key), min, max);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String cacheName, String key, String min, String max, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScoreWithScores(this.genKey(cacheName, key), min, max, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrangeByScoreWithScores(String cacheName, String key, String min, String max) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeByScoreWithScores(this.genKey(cacheName, key), min, max);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrangeWithScores(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrangeWithScores(this.genKey(cacheName, key), start, end);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zrank(String cacheName, String key, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zrank(this.genKey(cacheName, key), member);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zrem(String cacheName, String key, String ... members) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zrem(this.genKey(cacheName, key), members);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zremrangeByRank(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zremrangeByRank(this.genKey(cacheName, key), start, end);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zremrangeByScore(String cacheName, String key, double start, double end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zremrangeByScore(this.genKey(cacheName, key), start, end);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zremrangeByScore(String cacheName, String key, String start, String end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zremrangeByScore(this.genKey(cacheName, key), start, end);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrevrange(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrange(this.genKey(cacheName, key), start, end);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrevrangeByScore(String cacheName, String key, double max, double min, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScore(this.genKey(cacheName, key), max, min, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrevrangeByScore(String cacheName, String key, double max, double min) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScore(this.genKey(cacheName, key), max, min);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrevrangeByScore(String cacheName, String key, String max, String min, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScore(this.genKey(cacheName, key), max, min, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> zrevrangeByScore(String cacheName, String key, String max, String min) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScore(this.genKey(cacheName, key), max, min);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String cacheName, String key, double max, double min, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScoreWithScores(this.genKey(cacheName, key), max, min, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String cacheName, String key, double max, double min) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScoreWithScores(this.genKey(cacheName, key), max, min);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String cacheName, String key, String max, String min, int offset, int count) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScoreWithScores(this.genKey(cacheName, key), max, min, offset, count);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrevrangeByScoreWithScores(String cacheName, String key, String max, String min) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeByScoreWithScores(this.genKey(cacheName, key), max, min);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    public Set<Tuple> zrevrangeWithScores(String cacheName, String key, long start, long end) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.zrevrangeWithScores(this.genKey(cacheName, key), start, end);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long zrevrank(String cacheName, String key, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.zrevrank(this.genKey(cacheName, key), member);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Double zscore(String cacheName, String key, String member) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Double d = jedis.zscore(this.genKey(cacheName, key), member);
                    return d;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> blpop(String cacheName, int index, String ... keys) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                String[] key = new String[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    key[i] = this.genKey(cacheName, keys[i]);
                }
                if (jedis != null) {
                    List list = jedis.blpop(index, key);
                    return list;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> brpop(String cacheName, int index, String ... keys) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                String[] key = new String[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    key[i] = this.genKey(cacheName, keys[i]);
                }
                if (jedis != null) {
                    List list = jedis.brpop(index, key);
                    return list;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long del(String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.del(key);
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Long del(String cacheName, String key) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Long l = jedis.del(this.genKey(cacheName, key));
                    return l;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public Set<String> keys(String cacheName, String pattern) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    Set set = jedis.keys(this.genKey(cacheName, "*") + pattern);
                    return set;
                }
            }
            catch (Exception e) {
                throw new CacheException("ABC.0020", e);
            }
            finally {
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
        }
        return null;
    }

    @Override
    public List<String> mget(String cacheName, String ... keys) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                String[] key = new String[keys.length];
                for (int i = 0; i < keys.length; ++i) {
                    key[i] = this.genKey(cacheName, keys[i]);
                }
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    List list = jedis.mget(keys);
                    RedisClientFactory.INSTANCE.returnConnection(jedis);
                    return list;
                }
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
            catch (Exception e) {
                try {
                    throw new CacheException("ABC.0020", e);
                }
                catch (Throwable throwable) {
                    RedisClientFactory.INSTANCE.returnConnection(jedis);
                    throw throwable;
                }
            }
        }
        return null;
    }

    @Override
    public String mset(String cacheName, String ... keysvalues) {
        if (this.isEnabled()) {
            Jedis jedis = null;
            try {
                String[] key = new String[keysvalues.length / 2];
                String[] value = new String[keysvalues.length / 2];
                for (int i = 0; i < keysvalues.length; ++i) {
                    if (i % 2 == 0) {
                        key[i / 2] = this.genKey(cacheName, keysvalues[i]);
                        continue;
                    }
                    value[i / 2] = keysvalues[i];
                }
                jedis = RedisClientFactory.INSTANCE.getRedisConn();
                if (jedis != null) {
                    ArrayList<String> data = new ArrayList<String>();
                    for (int i = 0; i < key.length; ++i) {
                        data.add(key[i]);
                        data.add(value[i]);
                    }
                    String string = jedis.mset(data.toArray(new String[0]));
                    RedisClientFactory.INSTANCE.returnConnection(jedis);
                    return string;
                }
                RedisClientFactory.INSTANCE.returnConnection(jedis);
            }
            catch (Exception e) {
                try {
                    throw new CacheException("ABC.0020", e);
                }
                catch (Throwable throwable) {
                    RedisClientFactory.INSTANCE.returnConnection(jedis);
                    throw throwable;
                }
            }
        }
        return null;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    @Override
    public String genKey(String cacheName, String key) {
        if (cacheName == null || key == null) {
            throw new RuntimeException(EcpI18nUtil.localizedString((String)"RedisClientFactory_genKey_2276", (String)"\u7f13\u5b58\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a!"));
        }
        return cacheName + "#" + key;
    }
}

