/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.service.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.ygsoft.abc.service.cache.domain.bo.CaffeineCacheWrapper;
import com.ygsoft.abc.service.devops.domain.vo.CaffeineCacheStateVO;
import com.ygsoft.abc.service.tool.PreconditionUtil;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class CaffeineUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(CaffeineUtil.class);
    private static final String CACHE_NAME = "abc-public";
    private static final int THREE_MINUTES = 180;
    private static final int MAX_SIZE = 1000;
    private static final Map<String, CaffeineCacheWrapper> CONTAINER = new ConcurrentHashMap<String, CaffeineCacheWrapper>();

    private CaffeineUtil() {
    }

    public static Set<String> getCacheNames() {
        return CONTAINER.keySet();
    }

    public static List<CaffeineCacheStateVO> cacheStates() {
        ArrayList<CaffeineCacheStateVO> cacheStates = new ArrayList<CaffeineCacheStateVO>(CONTAINER.size());
        for (Map.Entry<String, CaffeineCacheWrapper> entry : CONTAINER.entrySet()) {
            CaffeineCacheWrapper wrapper = entry.getValue();
            CaffeineCacheStateVO stateVO = CaffeineCacheStateVO.newInstance(wrapper);
            cacheStates.add(stateVO);
        }
        return cacheStates;
    }

    public static Cache<String, Object> getInstance() {
        return CaffeineUtil.getInstance(CACHE_NAME);
    }

    public static Cache<String, Object> getInstance(String cacheName) {
        return CaffeineUtil.getInstance(cacheName, 180);
    }

    public static Cache<String, Object> getInstance(String cacheName, int expire) {
        return CaffeineUtil.getInstance(cacheName, expire, 1000);
    }

    public static Cache<String, Object> getInstance(int expire) {
        String cacheName = CACHE_NAME + expire;
        return CaffeineUtil.getInstance(cacheName, expire, 1000);
    }

    public static Cache<String, Object> getInstance(String cacheName, int expire, int size) {
        PreconditionUtil.checkNotTrimEmpty(cacheName, "\u53c2\u6570\u9519\u8bef\uff1acacheName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkArgument(expire > 3, "\u53c2\u6570\u9519\u8bef\uff1aexpire\u8bbe\u7f6e\u8fc7\u5c0f\u3002");
        PreconditionUtil.checkArgument(size > 3, "\u53c2\u6570\u9519\u8bef\uff1asize\u8bbe\u7f6e\u8fc7\u5c0f\u3002");
        CaffeineCacheWrapper cacheWraper = CONTAINER.computeIfAbsent(cacheName, it -> {
            Cache curCache = Caffeine.newBuilder().expireAfterWrite((long)expire, TimeUnit.SECONDS).removalListener((key, value, cause) -> {
                if (LOG.isInfoEnabled()) {
                    LOG.info((Object)("Caffeine\u79fb\u9664--" + key));
                }
            }).maximumSize((long)size).build();
            CaffeineCacheWrapper wrapper = new CaffeineCacheWrapper(cacheName, expire, size, (Cache<String, Object>)curCache);
            return wrapper;
        });
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u5f53\u524dCaffeine\u4e2a\u6570\uff1a" + CONTAINER.size()));
        }
        return cacheWraper.getCache();
    }

    public static CaffeineCacheWrapper getCacheWrapper(String cacheName) {
        PreconditionUtil.checkNotTrimEmpty(cacheName, "\u53c2\u6570\u9519\u8bef\uff1acacheName\u4e3a\u7a7a\u3002");
        if (CONTAINER.containsKey(cacheName)) {
            return CONTAINER.get(cacheName);
        }
        return null;
    }

    public static void setCacheWrapper(String cacheName, CaffeineCacheWrapper wrapper) {
        PreconditionUtil.checkNotTrimEmpty(cacheName, "\u53c2\u6570\u9519\u8bef\uff1acacheName\u4e3a\u7a7a\u3002");
        PreconditionUtil.checkNotNull(wrapper, "\u53c2\u6570\u9519\u8bef\uff1awrapper\u4e3a\u7a7a\u3002");
        CONTAINER.computeIfAbsent(cacheName, it -> wrapper);
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)("\u5f53\u524dCaffeine\u4e2a\u6570\uff1a" + CONTAINER.size()));
        }
    }

    public static CaffeineCacheWrapper buildWrapper(String cacheName, int expire, int size) {
        PreconditionUtil.checkArgument(expire > 3, "\u53c2\u6570\u9519\u8bef\uff1aexpire\u8bbe\u7f6e\u8fc7\u5c0f\u3002");
        PreconditionUtil.checkArgument(size > 3, "\u53c2\u6570\u9519\u8bef\uff1asize\u8bbe\u7f6e\u8fc7\u5c0f\u3002");
        Cache curCache = Caffeine.newBuilder().expireAfterWrite((long)expire, TimeUnit.SECONDS).removalListener((key, value, cause) -> {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Caffeine\u79fb\u9664--" + key));
            }
        }).maximumSize((long)size).build();
        CaffeineCacheWrapper wrapper = new CaffeineCacheWrapper(cacheName, expire, size, (Cache<String, Object>)curCache);
        return wrapper;
    }
}

