/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.util;

import com.ygsoft.abc.eepsp.satellite.client.openapi.exception.AbcIOException;
import com.ygsoft.abc.eepsp.satellite.client.openapi.exception.CheckFailedException;
import com.ygsoft.abc.eepsp.satellite.client.openapi.util.AttachUtil;
import com.ygsoft.abc.eepsp.satellite.client.openapi.util.CommonUtil;
import com.ygsoft.commons.io.IOUtils;
import com.ygsoft.ecp.service.log.EcpLogFactory;
import com.ygsoft.ecp.service.log.IEcpLog;
import com.ygsoft.ecp.service.tool.StreamUtil;
import com.ygsoft.ecp.service.tool.StringUtil;
import com.ygsoft.ecp.service.tool.UuidUtil;
import com.ygsoft.ecp.service.unstructure.EntityAttachmentSummaryVO;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.fusesource.hawtbuf.ByteArrayInputStream;
import org.springframework.web.multipart.MultipartFile;

public final class ZipUtil {
    private static final IEcpLog LOG = EcpLogFactory.getLog(ZipUtil.class);
    private static final int BUFFER_SIZE = 2048;

    private ZipUtil() {
    }

    public static List<EntityAttachmentSummaryVO> zip2Attachments(MultipartFile zip) {
        ArrayList<EntityAttachmentSummaryVO> arrayList;
        byte[] zipData;
        if (null == zip || zip.isEmpty()) {
            throw CheckFailedException.newInstance("zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        ArrayList<EntityAttachmentSummaryVO> list = new ArrayList<EntityAttachmentSummaryVO>();
        try {
            zipData = IOUtils.toByteArray((InputStream)zip.getInputStream());
        }
        catch (IOException e) {
            LOG.error((Object)"\u8bfb\u53d6zip\u6587\u4ef6\u9519\u8bef\u3002", (Throwable)e);
            return list;
        }
        File zipFile = ZipUtil.multipartFileToFile(zip);
        EntityAttachmentSummaryVO zipAttachment = AttachUtil.toEntityAttachmentSummary(zipFile, zip.getOriginalFilename(), UuidUtil.newUUID());
        zipFile.delete();
        list.add(zipAttachment);
        ZipInputStream zin = null;
        try {
            ZipEntry entry;
            zin = new ZipInputStream((InputStream)new ByteArrayInputStream(zipData));
            while ((entry = zin.getNextEntry()) != null) {
                String entryName = entry.getName();
                ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                IOUtils.copy((InputStream)zin, (OutputStream)byteOutput);
                byte[] data = byteOutput.toByteArray();
                byteOutput.flush();
                StreamUtil.closeStream((OutputStream)byteOutput);
                EntityAttachmentSummaryVO summary = AttachUtil.toEntityAttachmentSummary(data, entryName, UuidUtil.newUUID());
                list.add(summary);
            }
            arrayList = list;
        }
        catch (Exception e) {
            try {
                throw new RuntimeException("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\u3002", e);
            }
            catch (Throwable throwable) {
                ZipUtil.closeZipInputStream(zin);
                throw throwable;
            }
        }
        ZipUtil.closeZipInputStream(zin);
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static byte[] getXbrlFromZip(MultipartFile zip) {
        ZipInputStream zin;
        block10: {
            byte[] byArray;
            block9: {
                byte[] zipData;
                if (null == zip) throw CheckFailedException.newInstance("zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                if (zip.isEmpty()) {
                    throw CheckFailedException.newInstance("zip\u5305\u4e0d\u80fd\u4e3a\u7a7a\u3002");
                }
                try {
                    zipData = IOUtils.toByteArray((InputStream)zip.getInputStream());
                }
                catch (IOException e) {
                    LOG.error((Object)"\u8bfb\u53d6zip\u6587\u4ef6\u9519\u8bef\u3002", (Throwable)e);
                    return null;
                }
                zin = null;
                try {
                    ZipEntry entry;
                    zin = new ZipInputStream((InputStream)new ByteArrayInputStream(zipData));
                    while ((entry = zin.getNextEntry()) != null) {
                        String entryName = entry.getName();
                        if (!entryName.endsWith("xml")) continue;
                        ByteArrayOutputStream byteOutput = new ByteArrayOutputStream();
                        IOUtils.copy((InputStream)zin, (OutputStream)byteOutput);
                        byte[] data = byteOutput.toByteArray();
                        byteOutput.flush();
                        StreamUtil.closeStream((OutputStream)byteOutput);
                        byArray = data;
                        break block9;
                    }
                    break block10;
                }
                catch (Exception e) {
                    try {
                        throw new RuntimeException("\u6587\u4ef6\u89e3\u538b\u5931\u8d25\u3002", e);
                    }
                    catch (Throwable throwable) {
                        ZipUtil.closeZipInputStream(zin);
                        throw throwable;
                    }
                }
            }
            ZipUtil.closeZipInputStream(zin);
            return byArray;
        }
        ZipUtil.closeZipInputStream(zin);
        return null;
    }

    public static void toZip(String srcDir, String targetDir, String fileName) {
        ZipOutputStream zos = null;
        FileOutputStream fos = null;
        try {
            File dir = new File(targetDir);
            if (!dir.exists()) {
                FileUtils.forceMkdir((File)dir);
            }
            fos = new FileOutputStream(new File(targetDir + File.separator + fileName));
            zos = new ZipOutputStream(fos);
            File sourceFile = new File(srcDir);
            ZipUtil.compress(sourceFile, zos, sourceFile.getName());
        }
        catch (Exception e) {
            try {
                String msg = CommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                LOG.error((Object)msg, (Throwable)e);
                throw AbcIOException.newInstance(msg);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(zos);
                StreamUtil.closeStream(fos);
                throw throwable;
            }
        }
        StreamUtil.closeStream((OutputStream)zos);
        StreamUtil.closeStream((OutputStream)fos);
    }

    public static void toZip(String srcDir, OutputStream out) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            File sourceFile = new File(srcDir);
            ZipUtil.compress(sourceFile, zos, sourceFile.getName());
        }
        catch (Exception e) {
            try {
                String msg = CommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                LOG.error((Object)msg, (Throwable)e);
                throw AbcIOException.newInstance(msg);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(zos);
                throw throwable;
            }
        }
        StreamUtil.closeStream((OutputStream)zos);
    }

    public static void toZip(List<File> srcFiles, OutputStream out) {
        ZipOutputStream zos = null;
        try {
            zos = new ZipOutputStream(out);
            for (File srcFile : srcFiles) {
                int len;
                byte[] buf = new byte[2048];
                zos.putNextEntry(new ZipEntry(srcFile.getName()));
                FileInputStream in = new FileInputStream(srcFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            }
        }
        catch (Exception e) {
            try {
                String msg = CommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                LOG.error((Object)msg, (Throwable)e);
                throw AbcIOException.newInstance(msg);
            }
            catch (Throwable throwable) {
                StreamUtil.closeStream(zos);
                throw throwable;
            }
        }
        StreamUtil.closeStream((OutputStream)zos);
    }

    private static void compress(File sourceFile, ZipOutputStream zos, String name) {
        try {
            byte[] buf = new byte[2048];
            if (sourceFile.isFile()) {
                int len;
                zos.putNextEntry(new ZipEntry(name));
                FileInputStream in = new FileInputStream(sourceFile);
                while ((len = in.read(buf)) != -1) {
                    zos.write(buf, 0, len);
                }
                zos.closeEntry();
                in.close();
            } else {
                File[] listFiles = sourceFile.listFiles();
                if (null != listFiles && listFiles.length > 0) {
                    for (File file : listFiles) {
                        ZipUtil.compress(file, zos, file.getName());
                    }
                }
            }
        }
        catch (Exception e) {
            String msg = CommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
            LOG.error((Object)msg, (Throwable)e);
            throw AbcIOException.newInstance(msg);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<String> deZip(String zipFilePath, String targetPath) {
        if (StringUtil.isNullOrTrimEmptyString((String)zipFilePath)) {
            throw CheckFailedException.newInstance("\u5f85\u89e3\u538b\u6587\u4ef6\u8def\u5f84\u4e3a\u7a7a\u3002");
        }
        if (StringUtil.isNullOrTrimEmptyString((String)targetPath)) {
            throw CheckFailedException.newInstance("\u89e3\u538b\u540e\u6587\u4ef6\u5b58\u653e\u8def\u5f84\u4e3a\u7a7a\u3002");
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        ZipFile zipFile = null;
        try {
            BufferedOutputStream out = null;
            BufferedInputStream in = null;
            FileOutputStream fos = null;
            zipFile = new ZipFile(zipFilePath);
            Enumeration<? extends ZipEntry> zipEntires = zipFile.entries();
            File targetFile = new File(targetPath);
            if (!targetFile.exists()) {
                targetFile.mkdir();
            }
            while (zipEntires.hasMoreElements()) {
                try {
                    ZipEntry entry = zipEntires.nextElement();
                    if (entry.isDirectory()) {
                        String dirName = entry.getName();
                        dirName = dirName.substring(0, dirName.length() - 1);
                        File dirFile = new File(targetFile, dirName);
                        dirFile.mkdir();
                    } else {
                        int count;
                        in = new BufferedInputStream(zipFile.getInputStream(entry));
                        byte[] dataByte = new byte[2048];
                        String fileName = entry.getName();
                        fileNames.add(fileName);
                        fos = new FileOutputStream(new File(targetFile, fileName));
                        out = new BufferedOutputStream(fos, 2048);
                        while ((count = in.read(dataByte, 0, 2048)) != -1) {
                            out.write(dataByte, 0, count);
                        }
                    }
                }
                catch (Exception e) {
                    try {
                        String msg = CommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                        LOG.error((Object)msg, (Throwable)e);
                        throw AbcIOException.newInstance(msg);
                    }
                    catch (Throwable throwable) {
                        StreamUtil.closeStream(out);
                        StreamUtil.closeStream(fos);
                        StreamUtil.closeStream(in);
                        throw throwable;
                    }
                }
                StreamUtil.closeStream(out);
                StreamUtil.closeStream(fos);
                StreamUtil.closeStream((InputStream)in);
            }
        }
        catch (Exception e) {
            try {
                String msg = CommonUtil.spliceStr("\u538b\u7f29\u6587\u4ef6\u5f02\u5e38\uff1a", e.getMessage());
                LOG.error((Object)msg, (Throwable)e);
                throw AbcIOException.newInstance(msg);
            }
            catch (Throwable throwable) {
                ZipUtil.closeZipFile(zipFile);
                throw throwable;
            }
        }
        ZipUtil.closeZipFile(zipFile);
        return fileNames;
    }

    private static File multipartFileToFile(MultipartFile file) {
        try {
            if (file != null && file.getSize() > 0L) {
                InputStream ins = file.getInputStream();
                File toFile = new File(file.getOriginalFilename());
                ZipUtil.inputStreamToFile(ins, toFile);
                ins.close();
                return toFile;
            }
            return null;
        }
        catch (IOException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private static void inputStreamToFile(InputStream ins, File file) {
        try {
            int bytesRead;
            FileOutputStream os = new FileOutputStream(file);
            byte[] buffer = new byte[8192];
            while ((bytesRead = ins.read(buffer, 0, 8192)) != -1) {
                ((OutputStream)os).write(buffer, 0, bytesRead);
            }
            ((OutputStream)os).close();
            ins.close();
        }
        catch (Exception e) {
            LOG.error((Object)"inputstream to file error", (Throwable)e);
        }
    }

    private static void closeZipInputStream(ZipInputStream zin) {
        try {
            if (zin != null) {
                zin.closeEntry();
            }
            StreamUtil.closeStream((InputStream)zin);
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("IO\u5f02\u5e38\u3002");
        }
    }

    private static void closeZipFile(ZipFile zipFile) {
        try {
            if (zipFile != null) {
                zipFile.close();
            }
        }
        catch (Exception e) {
            throw AbcIOException.newInstance("IO\u5f02\u5e38\u3002");
        }
    }
}

