/*
 * Decompiled with CFR 0.152.
 */
package com.ygsoft.abc.eepsp.satellite.client.openapi.impl.service;

import com.ygsoft.abc.eepsp.satellite.client.openapi.model.ByteArrayMultipartFile;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileBase64VO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.model.vo.FileByteVO;
import com.ygsoft.abc.eepsp.satellite.client.openapi.service.IVoucherBaseFunction;
import com.ygsoft.abc.eepsp.satellite.client.openapi.service.IVoucherVerifyService;
import com.ygsoft.abc.eepsp.service.explain.common.bo.BaseResponseBO;
import com.ygsoft.abc.eepsp.service.explain.verify.domain.vo.VerifyRecordVO;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.EleVoucherParseFactory;
import com.ygsoft.abc.eepsp.service.explain.verify.strategy.IEleVoucherParseStrategy;
import com.ygsoft.abc.service.annotation.TLog;
import java.util.Base64;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
@Transactional
public class VoucherVerifyService
implements IVoucherVerifyService,
IVoucherBaseFunction {
    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- \u9a8c\u8bc1\u7535\u5b50\u51ed\u8bc1\u7b7e\u540d\u7684\u6709\u6548\u6027\u3002")
    public BaseResponseBO verify(MultipartFile file) {
        BaseResponseBO checkResult = this.checkFile(file);
        if (checkResult.isError()) {
            return checkResult;
        }
        String parseFileName = file.getOriginalFilename();
        IEleVoucherParseStrategy instance = EleVoucherParseFactory.getInstance((String)parseFileName);
        VerifyRecordVO verifyRecord = instance.parseSign(file);
        return BaseResponseBO.success((Object)verifyRecord);
    }

    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- \u9a8c\u8bc1\u7535\u5b50\u51ed\u8bc1\u7b7e\u540d\u7684\u6709\u6548\u6027\u3002")
    public BaseResponseBO verifyForBase64(FileBase64VO fileBase64VO) {
        BaseResponseBO checkResult = this.checkFileBase64VO(fileBase64VO);
        if (checkResult.isError()) {
            return checkResult;
        }
        ByteArrayMultipartFile file = ByteArrayMultipartFile.createFrom(Base64.getDecoder().decode(fileBase64VO.getFileInBase64()), fileBase64VO.getFileName());
        return this.verify(file);
    }

    @Override
    @TLog(text="[\u670d\u52a1\u5c42] --- \u9a8c\u8bc1\u7535\u5b50\u51ed\u8bc1\u7b7e\u540d\u7684\u6709\u6548\u6027\u3002")
    public BaseResponseBO verifyForByte(FileByteVO fileByteVO) {
        BaseResponseBO checkResult = this.checkFileByteVO(fileByteVO);
        if (checkResult.isError()) {
            return checkResult;
        }
        ByteArrayMultipartFile file = ByteArrayMultipartFile.createFrom(fileByteVO.getFileInBytes(), fileByteVO.getFileName());
        return this.verify(file);
    }
}

