/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.ocsp.test;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.Date;
import javax.crypto.KeyGenerator;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DEREncodable;
import xjyb.org.bjca.asn1.x509.AuthorityKeyIdentifier;
import xjyb.org.bjca.asn1.x509.BasicConstraints;
import xjyb.org.bjca.asn1.x509.SubjectKeyIdentifier;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.x509.X509V3CertificateGenerator;

public class OCSPTestUtil {
    public static SecureRandom rand;
    public static KeyPairGenerator kpg;
    public static KeyPairGenerator eckpg;
    public static KeyGenerator desede128kg;
    public static KeyGenerator desede192kg;
    public static KeyGenerator rc240kg;
    public static KeyGenerator rc264kg;
    public static KeyGenerator rc2128kg;
    public static BigInteger serialNumber;
    public static final boolean DEBUG = true;

    public static KeyPair makeKeyPair() {
        return kpg.generateKeyPair();
    }

    public static KeyPair makeECKeyPair() {
        return eckpg.generateKeyPair();
    }

    public static X509Certificate makeCertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(_subKP, _subDN, _issKP, _issDN, false);
    }

    public static X509Certificate makeECDSACertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeECDSACertificate(_subKP, _subDN, _issKP, _issDN, false);
    }

    public static X509Certificate makeCACertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(_subKP, _subDN, _issKP, _issDN, true);
    }

    public static X509Certificate makeCertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN, boolean _ca) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(_subKP, _subDN, _issKP, _issDN, "MD5withRSA", _ca);
    }

    public static X509Certificate makeECDSACertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN, boolean _ca) throws GeneralSecurityException, IOException {
        return OCSPTestUtil.makeCertificate(_subKP, _subDN, _issKP, _issDN, "SHA1WithECDSA", _ca);
    }

    public static X509Certificate makeCertificate(KeyPair _subKP, String _subDN, KeyPair _issKP, String _issDN, String algorithm, boolean _ca) throws GeneralSecurityException, IOException {
        PublicKey _subPub = _subKP.getPublic();
        PrivateKey _issPriv = _issKP.getPrivate();
        PublicKey _issPub = _issKP.getPublic();
        X509V3CertificateGenerator _v3CertGen = new X509V3CertificateGenerator();
        _v3CertGen.reset();
        _v3CertGen.setSerialNumber(OCSPTestUtil.allocateSerialNumber());
        _v3CertGen.setIssuerDN(new X509Name(_issDN));
        _v3CertGen.setNotBefore(new Date(System.currentTimeMillis()));
        _v3CertGen.setNotAfter(new Date(System.currentTimeMillis() + 8640000000L));
        _v3CertGen.setSubjectDN(new X509Name(_subDN));
        _v3CertGen.setPublicKey(_subPub);
        _v3CertGen.setSignatureAlgorithm(algorithm);
        _v3CertGen.addExtension(X509Extensions.SubjectKeyIdentifier, false, (DEREncodable)OCSPTestUtil.createSubjectKeyId(_subPub));
        _v3CertGen.addExtension(X509Extensions.AuthorityKeyIdentifier, false, (DEREncodable)OCSPTestUtil.createAuthorityKeyId(_issPub));
        _v3CertGen.addExtension(X509Extensions.BasicConstraints, false, (DEREncodable)new BasicConstraints(_ca));
        X509Certificate _cert = _v3CertGen.generateX509Certificate(_issPriv);
        _cert.checkValidity(new Date());
        _cert.verify(_issPub);
        return _cert;
    }

    private static AuthorityKeyIdentifier createAuthorityKeyId(PublicKey _pubKey) throws IOException {
        ByteArrayInputStream _bais = new ByteArrayInputStream(_pubKey.getEncoded());
        SubjectPublicKeyInfo _info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(_bais).readObject());
        return new AuthorityKeyIdentifier(_info);
    }

    private static SubjectKeyIdentifier createSubjectKeyId(PublicKey _pubKey) throws IOException {
        ByteArrayInputStream _bais = new ByteArrayInputStream(_pubKey.getEncoded());
        SubjectPublicKeyInfo _info = new SubjectPublicKeyInfo((ASN1Sequence)new ASN1InputStream(_bais).readObject());
        return new SubjectKeyIdentifier(_info);
    }

    private static BigInteger allocateSerialNumber() {
        BigInteger _tmp = serialNumber;
        serialNumber = serialNumber.add(BigInteger.ONE);
        return _tmp;
    }

    static {
        try {
            rand = new SecureRandom();
            kpg = KeyPairGenerator.getInstance("RSA", "BC");
            kpg.initialize(1024, rand);
            serialNumber = new BigInteger("1");
            eckpg = KeyPairGenerator.getInstance("ECDSA", "BC");
            eckpg.initialize(192, rand);
        }
        catch (Exception ex) {
            throw new RuntimeException(ex.toString());
        }
    }
}

