/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.bjca.ocsp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import xjyb.org.bjca.asn1.ASN1EncodableVector;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1OutputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.DERBitString;
import xjyb.org.bjca.asn1.DERNull;
import xjyb.org.bjca.asn1.DERObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.DERSequence;
import xjyb.org.bjca.asn1.ocsp.OCSPRequest;
import xjyb.org.bjca.asn1.ocsp.Request;
import xjyb.org.bjca.asn1.ocsp.TBSRequest;
import xjyb.org.bjca.asn1.x509.AlgorithmIdentifier;
import xjyb.org.bjca.asn1.x509.GeneralName;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.jce.X509Principal;
import xjyb.org.bjca.ocsp.CertificateID;
import xjyb.org.bjca.ocsp.OCSPException;
import xjyb.org.bjca.ocsp.OCSPReq;
import xjyb.org.bjca.ocsp.OCSPUtil;

public class OCSPReqGenerator {
    private List list = new ArrayList();
    private GeneralName requestorName = null;
    private X509Extensions requestExtensions = null;

    private DERObject makeObj(byte[] encoding) throws IOException {
        if (encoding == null) {
            return null;
        }
        ASN1InputStream aIn = new ASN1InputStream(encoding);
        return aIn.readObject();
    }

    public void addRequest(CertificateID certId) {
        this.list.add(new RequestObject(certId, null));
    }

    public void addRequest(CertificateID certId, X509Extensions singleRequestExtensions) {
        this.list.add(new RequestObject(certId, singleRequestExtensions));
    }

    public void setRequestorName(X500Principal requestorName) {
        try {
            this.requestorName = new GeneralName(4, new X509Principal(requestorName.getEncoded()));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("cannot encode principal: " + e);
        }
    }

    public void setRequestorName(GeneralName requestorName) {
        this.requestorName = requestorName;
    }

    public void setRequestExtensions(X509Extensions requestExtensions) {
        this.requestExtensions = requestExtensions;
    }

    private OCSPReq generateRequest(DERObjectIdentifier signingAlgorithm, PrivateKey key, X509Certificate[] chain, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException {
        Iterator it = this.list.iterator();
        ASN1EncodableVector requests = new ASN1EncodableVector();
        while (it.hasNext()) {
            try {
                requests.add(((RequestObject)it.next()).toRequest());
            }
            catch (Exception e) {
                throw new OCSPException("exception creating Request", e);
            }
        }
        TBSRequest tbsReq = new TBSRequest(this.requestorName, new DERSequence(requests), this.requestExtensions);
        Signature sig = null;
        xjyb.org.bjca.asn1.ocsp.Signature signature = null;
        if (signingAlgorithm != null) {
            if (this.requestorName == null) {
                throw new OCSPException("requestorName must be specified if request is signed.");
            }
            try {
                sig = Signature.getInstance(signingAlgorithm.getId(), provider);
                if (random != null) {
                    sig.initSign(key, random);
                } else {
                    sig.initSign(key);
                }
            }
            catch (NoSuchAlgorithmException e) {
                throw new OCSPException("exception creating signature: " + e, e);
            }
            catch (InvalidKeyException e) {
                throw new OCSPException("exception creating signature: " + e, e);
            }
            DERBitString bitSig = null;
            try {
                ByteArrayOutputStream bOut = new ByteArrayOutputStream();
                ASN1OutputStream aOut = new ASN1OutputStream(bOut);
                aOut.writeObject(tbsReq);
                sig.update(bOut.toByteArray());
                bitSig = new DERBitString(sig.sign());
            }
            catch (Exception e) {
                throw new OCSPException("exception processing TBSRequest: " + e, e);
            }
            AlgorithmIdentifier sigAlgId = new AlgorithmIdentifier(signingAlgorithm, new DERNull());
            if (chain != null && chain.length > 0) {
                ASN1EncodableVector v = new ASN1EncodableVector();
                try {
                    for (int i = 0; i != chain.length; ++i) {
                        v.add(new X509CertificateStructure((ASN1Sequence)this.makeObj(chain[i].getEncoded())));
                    }
                }
                catch (IOException e) {
                    throw new OCSPException("error processing certs", e);
                }
                catch (CertificateEncodingException e) {
                    throw new OCSPException("error encoding certs", e);
                }
                signature = new xjyb.org.bjca.asn1.ocsp.Signature(sigAlgId, bitSig, new DERSequence(v));
            } else {
                signature = new xjyb.org.bjca.asn1.ocsp.Signature(sigAlgId, bitSig);
            }
        }
        return new OCSPReq(new OCSPRequest(tbsReq, signature));
    }

    public OCSPReq generate() throws OCSPException {
        try {
            return this.generateRequest(null, null, null, null, null);
        }
        catch (NoSuchProviderException e) {
            throw new OCSPException("no provider! - " + e, e);
        }
    }

    public OCSPReq generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, String provider) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        return this.generate(signingAlgorithm, key, chain, provider, null);
    }

    public OCSPReq generate(String signingAlgorithm, PrivateKey key, X509Certificate[] chain, String provider, SecureRandom random) throws OCSPException, NoSuchProviderException, IllegalArgumentException {
        if (signingAlgorithm == null) {
            throw new IllegalArgumentException("no signing algorithm specified");
        }
        try {
            DERObjectIdentifier oid = OCSPUtil.getAlgorithmOID(signingAlgorithm);
            return this.generateRequest(oid, key, chain, provider, random);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("unknown signing algorithm specified: " + signingAlgorithm);
        }
    }

    public Iterator getSignatureAlgNames() {
        return OCSPUtil.getAlgNames();
    }

    private class RequestObject {
        CertificateID certId;
        X509Extensions extensions;

        public RequestObject(CertificateID certId, X509Extensions extensions) {
            this.certId = certId;
            this.extensions = extensions;
        }

        public Request toRequest() throws Exception {
            return new Request(this.certId.toASN1Object(), this.extensions);
        }
    }
}

