/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.protocol;

import java.io.IOException;
import xjyb.org.apache.http.HttpException;
import xjyb.org.apache.http.HttpRequest;
import xjyb.org.apache.http.HttpRequestInterceptor;
import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.protocol.HttpContext;
import xjyb.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

