/*
 * Decompiled with CFR 0.152.
 */
package xjyb.org.apache.http.impl.cookie;

import xjyb.org.apache.http.annotation.Contract;
import xjyb.org.apache.http.annotation.ThreadingBehavior;
import xjyb.org.apache.http.cookie.CommonCookieAttributeHandler;
import xjyb.org.apache.http.cookie.Cookie;
import xjyb.org.apache.http.cookie.CookieOrigin;
import xjyb.org.apache.http.cookie.MalformedCookieException;
import xjyb.org.apache.http.cookie.SetCookie;
import xjyb.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import xjyb.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

