/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.utils;

import java.io.FileInputStream;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import xjyb.cn.org.bjca.config.XmlConfig;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.DigestUtil;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;

public class HashUtil
extends SuperUtil {
    public HashUtil(String appName) {
        super(appName);
    }

    public static String getHashAlg(String applicationName) {
        if (applicationName == null || applicationName.equals("")) {
            return "SHA1";
        }
        Properties properties = (Properties)XmlConfig.getListWebapps().get(applicationName);
        String hashtype = (String)properties.get("hashtype");
        if (hashtype != null && !hashtype.equals("")) {
            return hashtype.toUpperCase();
        }
        return "SHA1";
    }

    public static long getHashAlgLong(String applicationName) {
        if (applicationName == null || applicationName.equals("")) {
            return 1L;
        }
        Properties properties = (Properties)XmlConfig.getListWebapps().get(applicationName);
        String hashtype = (String)properties.get("hashtype");
        if (hashtype != null && !hashtype.equals("")) {
            if (hashtype.toUpperCase().equals("SHA256")) {
                return 2L;
            }
            return 1L;
        }
        return 1L;
    }

    public static byte[] hash(String algType, byte[] inData, X509CertificateStructure cert) throws HashException {
        byte[] hashedData = null;
        HashUtil hashUtil = new HashUtil("");
        if ("SM3".equals(algType)) {
            byte[] publicKey = null;
            byte[] id = null;
            if (cert != null) {
                SubjectPublicKeyInfo spki = cert.getSubjectPublicKeyInfo();
                byte[] bPubKey = spki.getPublicKeyData().getBytes();
                publicKey = new byte[64];
                System.arraycopy(bPubKey, 1, publicKey, 0, publicKey.length);
                id = "1234567812345678".getBytes();
            }
            try {
                WrapCard wCard = new WrapCard();
                hashedData = wCard.sm3(inData, publicKey, id);
            }
            catch (Exception e) {
                throw new HashException("Exception in sm2 signature with hashed Data!" + e.getMessage());
            }
        } else if ("SHA1".equals(algType)) {
            hashedData = hashUtil.BJS_HashBytes(0L, inData);
        } else if ("SHA256".equals(algType)) {
            hashedData = hashUtil.BJS_HashBytes(2L, inData);
        }
        return hashedData;
    }

    public byte[] BJS_HashBytes(long ALGID, byte[] data) throws HashException {
        try {
            MessageDigest md = null;
            md = 2L == ALGID ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
            md.update(data);
            byte[] digest = md.digest();
            return digest;
        }
        catch (Exception e) {
            this.errorlog("Exception in hash,hash byte", e);
            this.debuglog("Exception in hash,hash byte");
            return null;
        }
    }

    public byte[] BJS_HashFile(long ALGID, String sFilePath) throws HashException {
        try {
            int len;
            MessageDigest md = null;
            md = 2L == HashUtil.getHashAlgLong(this.applicationName) ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
            FileInputStream in = new FileInputStream(sFilePath);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = ((InputStream)in).read(inBytes)) != -1) {
                md.update(inBytes, 0, len);
            }
            byte[] hashValue = md.digest();
            ((InputStream)in).close();
            return hashValue;
        }
        catch (Exception e) {
            this.errorlog("Exception in hash,hash file", e);
            this.debuglog("Exception in hash,hash file");
            return null;
        }
    }

    public byte[] BJS_HashFile(long ALGID, InputStream inputStream) throws HashException {
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = inputStream.read(inBytes)) != -1) {
                md.update(inBytes, 0, len);
            }
            byte[] hashValue = md.digest();
            inputStream.close();
            return hashValue;
        }
        catch (Exception e) {
            this.errorlog("Exception in hash,hash file", e);
            this.debuglog("Exception in hash,hash file");
            return null;
        }
    }

    public byte[] hashAll(ArrayList fileList, ArrayList stringList, long signMethod) throws NoSuchAlgorithmException {
        FileUtil fileUtil = new FileUtil(this.applicationName);
        MessageDigest md = MessageDigest.getInstance("SHA1");
        byte[] hashbuf = null;
        try {
            int i;
            for (i = 0; i < fileList.size(); ++i) {
                String filePath = fileList.get(i).toString();
                byte[] inbuf = fileUtil.readFile(filePath);
                md.update(inbuf);
            }
            for (i = 0; i < stringList.size(); ++i) {
                String str = stringList.get(i).toString();
                md.update(str.getBytes());
            }
            hashbuf = md.digest();
        }
        catch (Exception e) {
            this.errorlog("Exception in hash,hashAll", e);
            this.debuglog("Exception in hash,hashAll");
            return null;
        }
        return hashbuf;
    }

    private void method() {
        try {
            Base64Util base64 = new Base64Util(this.applicationName);
            String inData = "\u4f60\u597d\uff01,";
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(inData.getBytes());
            byte[] digest = md.digest();
            String outData = base64.BJS_EncodeBase64(digest);
            System.out.println("outData==  " + outData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void method2() {
        try {
            FileUtil fileU = new FileUtil("");
            String inData = "hello";
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(inData.getBytes());
            byte[] digest = md.digest();
            fileU.writeFile(digest, "d:/digest_sha1");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] hashFile(String alg, String sFilePath, String pubInfoStr) {
        FileInputStream in = null;
        if ("RSA".equals(alg)) {
            try {
                byte[] hashValue;
                in = new FileInputStream(sFilePath);
                byte[] byArray = hashValue = this.hashByInputStream(in);
                return byArray;
            }
            catch (Exception e) {
                this.debuglog("Hash file error!", e);
                this.errorlog("Hash file error!", e);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (Exception ex) {
                    this.debuglog("Close FileInputStream error!", ex);
                    this.errorlog("Close FileInputStream error!", ex);
                }
            }
        }
        if ("ECC".equals(alg)) {
            try {
                in = new FileInputStream(sFilePath);
                byte[] hashValue = null;
                hashValue = null == pubInfoStr || "".equals(pubInfoStr) ? this.sm3HashByInputStream(in) : this.sm3HashByInputStream(in, pubInfoStr);
                byte[] byArray = hashValue;
                return byArray;
            }
            catch (Exception e) {
                this.debuglog("Hash file error!", e);
                this.errorlog("Hash file error!", e);
                byte[] byArray = null;
                return byArray;
            }
            finally {
                try {
                    if (in != null) {
                        ((InputStream)in).close();
                    }
                }
                catch (Exception ex) {
                    this.debuglog("Close FileInputStream error!", ex);
                    this.errorlog("Close FileInputStream error!", ex);
                }
            }
        }
        return null;
    }

    public byte[] sha1HashByInputStream(InputStream inputStream) {
        try {
            int len;
            MessageDigest md = MessageDigest.getInstance("SHA1");
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = inputStream.read(inBytes)) != -1) {
                md.update(inBytes, 0, len);
            }
            byte[] hashValue = md.digest();
            return hashValue;
        }
        catch (Exception e) {
            this.errorlog("Exception in rsaHashByInputStream", e);
            this.debuglog("Exception in rsaHashByInputStream");
            return null;
        }
    }

    public byte[] hashByInputStream(InputStream inputStream) {
        try {
            int len;
            MessageDigest md = null;
            md = 2L == HashUtil.getHashAlgLong(this.applicationName) ? MessageDigest.getInstance("SHA-256") : MessageDigest.getInstance("SHA-1");
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = inputStream.read(inBytes)) != -1) {
                md.update(inBytes, 0, len);
            }
            byte[] hashValue = md.digest();
            return hashValue;
        }
        catch (Exception e) {
            this.errorlog("Exception in rsaHashByInputStream", e);
            this.debuglog("Exception in rsaHashByInputStream");
            return null;
        }
    }

    public byte[] sm3HashByInputStream(InputStream inputStream, String pubInfoStr) {
        Base64Util base64U = new Base64Util("");
        ArrayList<byte[]> pubInfoList = new ArrayList<byte[]>();
        StringTokenizer pubInfoSt = new StringTokenizer(pubInfoStr, "###");
        while (pubInfoSt.hasMoreElements()) {
            String pubInfo = pubInfoSt.nextElement().toString();
            byte[] pubInfoByte = base64U.BJS_DecodeBase64(pubInfo);
            pubInfoList.add(pubInfoByte);
        }
        byte[] xByte = (byte[])pubInfoList.get(0);
        BigInteger xBigInt = new BigInteger(xByte);
        byte[] yByte = (byte[])pubInfoList.get(1);
        BigInteger yBigInt = new BigInteger(yByte);
        byte[] idByte = (byte[])pubInfoList.get(2);
        byte[] bHash = null;
        try {
            int len;
            bHash = new byte[32];
            DigestUtil digestU = new DigestUtil();
            digestU.addId(xBigInt, yBigInt, idByte);
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = inputStream.read(inBytes)) != -1) {
                digestU.update(inBytes, 0, len);
            }
            digestU.doFinal(bHash, 0);
            return bHash;
        }
        catch (Exception e) {
            this.debuglog("Hash file error!", e);
            this.errorlog("Hash file error!", e);
            return null;
        }
    }

    public byte[] sm3HashByInputStream(InputStream inputStream) {
        Base64Util base64U = new Base64Util("");
        byte[] bHash = null;
        try {
            int len;
            bHash = new byte[32];
            DigestUtil digestU = new DigestUtil();
            int blockSize = 131072;
            byte[] inBytes = new byte[blockSize];
            while ((len = inputStream.read(inBytes)) != -1) {
                digestU.update(inBytes, 0, len);
            }
            digestU.doFinal(bHash, 0);
            return bHash;
        }
        catch (Exception e) {
            this.debuglog("Hash file error!", e);
            this.errorlog("Hash file error!", e);
            return null;
        }
    }

    public static void main(String[] str) {
        try {
            HashUtil hashUtil = new HashUtil("");
            System.out.println(hashUtil.BJS_HashBytes(1L, "abc".getBytes()).length);
            System.out.println(hashUtil.BJS_HashBytes(2L, "abc".getBytes()).length);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

