/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.utils;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import xjyb.cn.org.bjca.exception.HashException;
import xjyb.cn.org.bjca.exception.ValidateCertException;
import xjyb.cn.org.bjca.exception.VerifySignDataException;
import xjyb.cn.org.bjca.framework.SuperUtil;
import xjyb.cn.org.bjca.java.utils.RsaUtil;
import xjyb.cn.org.bjca.security.SuperEngine;
import xjyb.cn.org.bjca.utils.Base64Util;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.cn.org.bjca.utils.HashUtil;
import xjyb.com.sansec.device.local.WrapCard;
import xjyb.org.bjca.asn1.ASN1InputStream;
import xjyb.org.bjca.asn1.ASN1Sequence;
import xjyb.org.bjca.asn1.ASN1TaggedObject;
import xjyb.org.bjca.asn1.DERObjectIdentifier;
import xjyb.org.bjca.asn1.pkcs.PKCSObjectIdentifiers;
import xjyb.org.bjca.asn1.x509.CertificateList;
import xjyb.org.bjca.asn1.x509.RSAPublicKeyStructure;
import xjyb.org.bjca.asn1.x509.SubjectPublicKeyInfo;
import xjyb.org.bjca.asn1.x509.TBSCertificateStructure;
import xjyb.org.bjca.asn1.x509.X509CertificateStructure;
import xjyb.org.bjca.asn1.x509.X509Extension;
import xjyb.org.bjca.asn1.x509.X509Extensions;
import xjyb.org.bjca.asn1.x509.X509Name;
import xjyb.org.bjca.asn1.x9.X9ObjectIdentifiers;
import xjyb.org.bjca.crypto.CryptoException;
import xjyb.org.bjca.crypto.digests.SHA1Digest;
import xjyb.org.bjca.crypto.params.RSAKeyParameters;
import xjyb.org.bjca.crypto.signers.BJCASigner;
import xjyb.org.bjca.crypto.signers.SM2Signer;
import xjyb.org.bjca.jce.fastparser.DerUtil;
import xjyb.org.bjca.jce.provider.X509CRLObject;
import xjyb.org.bjca.math.ec.ECPoint;
import xjyb.org.bjca.util.P7bUtil;

public class CertificateUtil
extends SuperUtil {
    public static final String timestamp = "1.3.6.1.5.5.7.3.8";

    public CertificateUtil(String appName) {
        super(appName);
    }

    public PublicKey getCertPublicKey(byte[] usrCert) throws CertificateException {
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(usrCert);
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        PublicKey pubKey = oCert.getPublicKey();
        return pubKey;
    }

    public boolean isTimeStampCert(byte[] usrCert) {
        try {
            CertificateFactory oCf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream ois = new ByteArrayInputStream(usrCert);
            X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
            List<String> ls = oCert.getExtendedKeyUsage();
            int len = ls.size();
            for (int i = 0; i < len; ++i) {
                String extendedOid = ls.get(i);
                if (!timestamp.equals(extendedOid)) continue;
                return true;
            }
        }
        catch (Exception e) {
            this.errorlog("Exception in parsing timestamp certificate", e);
            this.debuglog("Exception in parsing timestamp certificate");
        }
        return false;
    }

    public String BJC_GetBasicCertInfo(byte[] usrCert, long infoType) {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String info = null;
        try {
            X509Extension alternativeExt;
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            SimpleDateFormat newDateformat = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss");
            X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(usrCert));
            X509Name subjectX509Name = cert.getSubject();
            String subjectName = subjectX509Name.toString().trim();
            X509Name issuerX509Name = cert.getIssuer();
            String issuerName = issuerX509Name.toString().trim();
            String striC = null;
            String striO = null;
            String striOU = null;
            Object striS = null;
            String striCN = null;
            String striL = null;
            String striE = null;
            StringTokenizer stSubjectDN = new StringTokenizer(subjectName, ",");
            while (stSubjectDN.hasMoreTokens()) {
                String strSubj = stSubjectDN.nextToken().trim();
                if (strSubj.indexOf("C=") != -1) {
                    striC = strSubj.substring(strSubj.indexOf("C=") + 2);
                    continue;
                }
                if (strSubj.indexOf("O=") != -1) {
                    striO = strSubj.substring(strSubj.indexOf("O=") + 2);
                    continue;
                }
                if (strSubj.indexOf("OU=") != -1) {
                    striOU = strSubj.substring(strSubj.indexOf("OU=") + 3);
                    continue;
                }
                if (strSubj.indexOf("CN=") != -1) {
                    striCN = strSubj.substring(strSubj.indexOf("CN=") + 3);
                    continue;
                }
                if (strSubj.indexOf("L=") != -1) {
                    striL = strSubj.substring(strSubj.indexOf("L=") + 2);
                    continue;
                }
                if (strSubj.indexOf("EMAILADDRESS=") != -1) {
                    striE = strSubj.substring(strSubj.indexOf("EMAILADDRESS=") + 13);
                    continue;
                }
                if (strSubj.indexOf("E=") == -1) continue;
                striE = strSubj.substring(strSubj.indexOf("E=") + 2);
            }
            String strC = null;
            String strO = null;
            String strOU = null;
            String strS = null;
            String strCN = null;
            String strL = null;
            String strE = null;
            X509Extensions extensions = cert.getTBSCertificate().getExtensions();
            if (extensions != null && (alternativeExt = extensions.getExtension(X509Extensions.SubjectAlternativeName)) != null) {
                ASN1Sequence sequence = (ASN1Sequence)X509Extension.convertValueToObject(alternativeExt);
                Enumeration enumeration = sequence.getObjects();
                ASN1Sequence sequence1 = null;
                while (enumeration.hasMoreElements()) {
                    ASN1TaggedObject object = (ASN1TaggedObject)enumeration.nextElement();
                    int tagNo = object.getTagNo();
                    if (tagNo != 4) continue;
                    sequence1 = (ASN1Sequence)object.getObject();
                    break;
                }
                if (sequence1 != null) {
                    X509Name x509Name = new X509Name(sequence1);
                    String strName = x509Name.toString().trim();
                    this.debuglog(strName);
                    StringTokenizer st = new StringTokenizer(strName, ",");
                    while (st.hasMoreTokens()) {
                        String str = st.nextToken().trim();
                        if (str.indexOf("C=") == 0) {
                            strC = str.substring(2);
                            continue;
                        }
                        if (str.indexOf("O=") != -1) {
                            strO = str.substring(2);
                            continue;
                        }
                        if (str.indexOf("OU=") != -1) {
                            strOU = str.substring(3);
                            continue;
                        }
                        if (str.indexOf("ST=") != -1) {
                            strS = str.substring(3);
                            continue;
                        }
                        if (str.indexOf("CN=") != -1) {
                            strCN = str.substring(3);
                            continue;
                        }
                        if (str.indexOf("L=") != -1) {
                            strL = str.substring(2);
                            continue;
                        }
                        if (str.indexOf("E=") == -1) continue;
                        strE = str.substring(2);
                    }
                }
            }
            int itype = (int)infoType;
            String infostr = null;
            switch (itype) {
                case 1: {
                    info = String.valueOf(cert.getVersion());
                    break;
                }
                case 2: {
                    info = cert.getSerialNumber().getValue().toString(16);
                    break;
                }
                case 3: {
                    info = cert.getSignatureAlgorithm().getObjectId().getId();
                    break;
                }
                case 8: {
                    infostr = issuerName;
                    StringTokenizer stIssuerDN = new StringTokenizer(infostr, ",");
                    while (stIssuerDN.hasMoreTokens()) {
                        String strIss = stIssuerDN.nextToken().trim();
                        if (strIss.indexOf("CN=") != 0) continue;
                        info = strIss.substring(3);
                    }
                    break;
                }
                case 11: {
                    Date startDate = cert.getStartDate().getDate();
                    info = dateformat.format(startDate);
                    break;
                }
                case 12: {
                    Date endDate = cert.getEndDate().getDate();
                    info = dateformat.format(endDate);
                    break;
                }
                case 13: {
                    info = striC;
                    break;
                }
                case 14: {
                    info = striO;
                    break;
                }
                case 15: {
                    info = striOU;
                    break;
                }
                case 16: {
                    info = striS;
                    break;
                }
                case 17: {
                    info = striCN;
                    break;
                }
                case 18: {
                    info = striL;
                    break;
                }
                case 19: {
                    info = striE;
                    break;
                }
                case 20: {
                    info = issuerName;
                    break;
                }
                case 21: {
                    info = subjectName;
                    break;
                }
                case 22: {
                    info = null;
                    break;
                }
                case 23: {
                    info = strC;
                    break;
                }
                case 24: {
                    info = strO;
                    break;
                }
                case 25: {
                    info = strOU;
                    break;
                }
                case 26: {
                    info = strS;
                    break;
                }
                case 27: {
                    info = strCN;
                    break;
                }
                case 28: {
                    info = strL;
                    break;
                }
                case 29: {
                    info = strE;
                    break;
                }
                case 30: {
                    SubjectPublicKeyInfo spki = cert.getSubjectPublicKeyInfo();
                    byte[] bPubKey = spki.getPublicKeyData().getBytes();
                    info = base64Util.BJS_EncodeBase64(bPubKey);
                    break;
                }
                case 31: {
                    DERObjectIdentifier algorithmIdenti = cert.getSubjectPublicKeyInfo().getAlgorithmId().getObjectId();
                    if (X9ObjectIdentifiers.id_ecPublicKey.equals(algorithmIdenti)) {
                        info = "ECC";
                        break;
                    }
                    if (PKCSObjectIdentifiers.rsaEncryption.equals(algorithmIdenti)) {
                        info = "RSA";
                        break;
                    }
                    info = "";
                    break;
                }
                case 32: {
                    byte[] certificatePolicies = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.CertificatePolicies).getValue().getOctets();
                    ByteArrayInputStream bIn = new ByteArrayInputStream(certificatePolicies);
                    ASN1InputStream aIn = new ASN1InputStream(bIn);
                    ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                    ASN1Sequence seq2 = (ASN1Sequence)seq.getObjectAt(0);
                    DERObjectIdentifier oid = (DERObjectIdentifier)seq2.getObjectAt(0);
                    info = oid.toString();
                    break;
                }
                case 33: {
                    String pubKeyInfo;
                    SubjectPublicKeyInfo PubKey = cert.getSubjectPublicKeyInfo();
                    byte[] pubKeyByte = PubKey.getPublicKeyData().getBytes();
                    SM2Signer sm2 = new SM2Signer();
                    ECPoint pubkey = sm2.decodePoint(pubKeyByte);
                    BigInteger affineX = pubkey.getX().toBigInteger();
                    BigInteger affineY = pubkey.getY().toBigInteger();
                    byte[] xByte = affineX.toByteArray();
                    String xStr = base64Util.BJS_EncodeBase64(xByte);
                    byte[] yByte = affineY.toByteArray();
                    String yStr = base64Util.BJS_EncodeBase64(yByte);
                    byte[] id = "1234567812345678".getBytes();
                    String idStr = base64Util.BJS_EncodeBase64(id);
                    info = pubKeyInfo = xStr + "###" + yStr + "###" + idStr;
                    break;
                }
                case 34: {
                    Date newStartDate = cert.getStartDate().getDate();
                    info = newDateformat.format(newStartDate);
                    break;
                }
                case 35: {
                    Date newEndDate = cert.getEndDate().getDate();
                    info = newDateformat.format(newEndDate);
                    break;
                }
                default: {
                    info = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            info = null;
            this.errorlog("Exception in parsing certificate", e);
            this.debuglog("Exception in parsing certificate");
        }
        return info;
    }

    public String BJC_GetBasicCertInfo0020(byte[] usrCert, long infoType) {
        Base64Util base64Util = new Base64Util(this.applicationName);
        String info = null;
        try {
            X509Extension alternativeExt;
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            SimpleDateFormat newDateformat = new SimpleDateFormat("yyyy/MM/dd/HH/mm/ss");
            X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(usrCert));
            X509Name subjectX509Name = cert.getSubject();
            String subjectName = subjectX509Name.toString().trim();
            X509Name issuerX509Name = cert.getIssuer();
            String issuerName = issuerX509Name.toString().trim();
            String striC = null;
            String striO = null;
            String striOU = null;
            Object striS = null;
            String striCN = null;
            String striL = null;
            String striE = null;
            StringTokenizer stSubjectDN = new StringTokenizer(subjectName, ",");
            while (stSubjectDN.hasMoreTokens()) {
                String strSubj = stSubjectDN.nextToken().trim();
                if (strSubj.indexOf("C=") != -1) {
                    striC = strSubj.substring(strSubj.indexOf("C=") + 2);
                    continue;
                }
                if (strSubj.indexOf("O=") != -1) {
                    striO = strSubj.substring(strSubj.indexOf("O=") + 2);
                    continue;
                }
                if (strSubj.indexOf("OU=") != -1) {
                    striOU = strSubj.substring(strSubj.indexOf("OU=") + 3);
                    continue;
                }
                if (strSubj.indexOf("CN=") != -1) {
                    striCN = strSubj.substring(strSubj.indexOf("CN=") + 3);
                    continue;
                }
                if (strSubj.indexOf("L=") != -1) {
                    striL = strSubj.substring(strSubj.indexOf("L=") + 2);
                    continue;
                }
                if (strSubj.indexOf("EMAILADDRESS=") != -1) {
                    striE = strSubj.substring(strSubj.indexOf("EMAILADDRESS=") + 13);
                    continue;
                }
                if (strSubj.indexOf("E=") == -1) continue;
                striE = strSubj.substring(strSubj.indexOf("E=") + 2);
            }
            String strC = null;
            String strO = null;
            String strOU = null;
            String strS = null;
            String strCN = null;
            String strL = null;
            String strE = null;
            X509Extensions extensions = cert.getTBSCertificate().getExtensions();
            if (extensions != null && (alternativeExt = extensions.getExtension(X509Extensions.SubjectAlternativeName)) != null) {
                ASN1Sequence sequence = (ASN1Sequence)X509Extension.convertValueToObject(alternativeExt);
                Enumeration enumeration = sequence.getObjects();
                ASN1Sequence sequence1 = null;
                while (enumeration.hasMoreElements()) {
                    ASN1TaggedObject object = (ASN1TaggedObject)enumeration.nextElement();
                    int tagNo = object.getTagNo();
                    if (tagNo != 4) continue;
                    sequence1 = (ASN1Sequence)object.getObject();
                    break;
                }
                if (sequence1 != null) {
                    X509Name x509Name = new X509Name(sequence1);
                    String strName = x509Name.toString().trim();
                    this.debuglog(strName);
                    StringTokenizer st = new StringTokenizer(strName, ",");
                    while (st.hasMoreTokens()) {
                        String str = st.nextToken().trim();
                        if (str.indexOf("C=") == 0) {
                            strC = str.substring(2);
                            continue;
                        }
                        if (str.indexOf("O=") != -1) {
                            strO = str.substring(2);
                            continue;
                        }
                        if (str.indexOf("OU=") != -1) {
                            strOU = str.substring(3);
                            continue;
                        }
                        if (str.indexOf("ST=") != -1) {
                            strS = str.substring(3);
                            continue;
                        }
                        if (str.indexOf("CN=") != -1) {
                            strCN = str.substring(3);
                            continue;
                        }
                        if (str.indexOf("L=") != -1) {
                            strL = str.substring(2);
                            continue;
                        }
                        if (str.indexOf("E=") == -1) continue;
                        strE = str.substring(2);
                    }
                }
            }
            int itype = (int)infoType;
            String infostr = null;
            switch (itype) {
                case 1: {
                    info = String.valueOf(cert.getVersion());
                    break;
                }
                case 2: {
                    info = cert.getSerialNumber().getValue().toString(16);
                    break;
                }
                case 3: {
                    info = cert.getSignatureAlgorithm().getObjectId().getId();
                    break;
                }
                case 5: {
                    info = issuerName;
                    break;
                }
                case 6: {
                    Date startDate1 = cert.getStartDate().getDate();
                    String before = dateformat.format(startDate1);
                    Date endDate1 = cert.getEndDate().getDate();
                    String end = dateformat.format(endDate1);
                    info = before + "-" + end;
                    break;
                }
                case 7: {
                    info = subjectName;
                    break;
                }
                case 8: {
                    SubjectPublicKeyInfo spki = cert.getSubjectPublicKeyInfo();
                    byte[] bPubKey = spki.getPublicKeyData().getBytes();
                    info = base64Util.BJS_EncodeBase64(bPubKey);
                    break;
                }
                case 9: {
                    TBSCertificateStructure tbsCert = cert.getTBSCertificate();
                    X509Extensions extensions2 = tbsCert.getExtensions();
                    byte[] eee = extensions2.getEncoded();
                    info = base64Util.BJS_EncodeBase64(eee);
                    break;
                }
                case 17: {
                    String authkeyID = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.AuthorityKeyIdentifier).getValue().toString();
                    info = authkeyID.substring(9);
                    break;
                }
                case 18: {
                    String subkeyID = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.SubjectKeyIdentifier).getValue().toString();
                    info = subkeyID.substring(5);
                    break;
                }
                case 19: {
                    String keyUse = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.KeyUsage).getValue().toString();
                    info = keyUse.substring(1);
                    break;
                }
                case 20: {
                    Date pristartDate1 = cert.getStartDate().getDate();
                    String pribefore = dateformat.format(pristartDate1);
                    Date priendDate1 = cert.getEndDate().getDate();
                    String priend = dateformat.format(priendDate1);
                    info = pribefore + "-" + priend;
                    break;
                }
                case 21: {
                    byte[] certificatePolicies = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.CertificatePolicies).getValue().getOctets();
                    ByteArrayInputStream bIn = new ByteArrayInputStream(certificatePolicies);
                    ASN1InputStream aIn = new ASN1InputStream(bIn);
                    ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                    ASN1Sequence seq2 = (ASN1Sequence)seq.getObjectAt(0);
                    DERObjectIdentifier oid = (DERObjectIdentifier)seq2.getObjectAt(0);
                    info = oid.toString();
                    break;
                }
                case 22: {
                    info = null;
                    break;
                }
                case 23: {
                    info = null;
                    break;
                }
                case 24: {
                    info = null;
                    break;
                }
                case 25: {
                    String exkeyUse = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.ExtendedKeyUsage).getValue().toString();
                    info = exkeyUse.substring(1);
                    break;
                }
                case 26: {
                    String cRLDistributionPoints = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.CRLDistributionPoints).getValue().toString();
                    info = cRLDistributionPoints.substring(1);
                    break;
                }
                case 27: {
                    info = null;
                    break;
                }
                case 28: {
                    info = null;
                    break;
                }
                case 33: {
                    infostr = issuerName;
                    StringTokenizer stIssuerDN = new StringTokenizer(infostr, ",");
                    while (stIssuerDN.hasMoreTokens()) {
                        String strIss = stIssuerDN.nextToken().trim();
                        if (strIss.indexOf("CN=") != 0) continue;
                        info = strIss.substring(3);
                    }
                    break;
                }
                case 34: {
                    infostr = issuerName;
                    StringTokenizer stIssuerDN1 = new StringTokenizer(infostr, ",");
                    while (stIssuerDN1.hasMoreTokens()) {
                        String strIss = stIssuerDN1.nextToken().trim();
                        if (strIss.indexOf("O=") != 0) continue;
                        info = strIss.substring(2);
                    }
                    break;
                }
                case 35: {
                    infostr = issuerName;
                    StringTokenizer stIssuerDN2 = new StringTokenizer(infostr, ",");
                    while (stIssuerDN2.hasMoreTokens()) {
                        String strIss = stIssuerDN2.nextToken().trim();
                        if (strIss.indexOf("OU=") != 0) continue;
                        info = strIss.substring(3);
                    }
                    break;
                }
                case 49: {
                    infostr = subjectName;
                    StringTokenizer subjectDN = new StringTokenizer(infostr, ",");
                    while (subjectDN.hasMoreTokens()) {
                        String strIss = subjectDN.nextToken().trim();
                        if (strIss.indexOf("CN=") != 0) continue;
                        info = strIss.substring(3);
                    }
                    break;
                }
                case 50: {
                    infostr = subjectName;
                    StringTokenizer subjectDN1 = new StringTokenizer(infostr, ",");
                    while (subjectDN1.hasMoreTokens()) {
                        String strIss = subjectDN1.nextToken().trim();
                        if (strIss.indexOf("O=") != 0) continue;
                        info = strIss.substring(2);
                    }
                    break;
                }
                case 51: {
                    infostr = subjectName;
                    StringTokenizer subjectDN2 = new StringTokenizer(infostr, ",");
                    while (subjectDN2.hasMoreTokens()) {
                        String strIss = subjectDN2.nextToken().trim();
                        if (strIss.indexOf("OU=") != 0) continue;
                        info = strIss.substring(3);
                    }
                    break;
                }
                case 52: {
                    infostr = subjectName;
                    StringTokenizer subjectDN3 = new StringTokenizer(infostr, ",");
                    while (subjectDN3.hasMoreTokens()) {
                        String strIss = subjectDN3.nextToken().trim();
                        if (strIss.indexOf("E=") != 0) continue;
                        info = strIss.substring(2);
                    }
                    break;
                }
                default: {
                    info = null;
                    break;
                }
            }
        }
        catch (Exception e) {
            info = null;
            this.errorlog("Exception in parsing certificate", e);
            this.debuglog("Exception in parsing certificate");
        }
        return info;
    }

    public String BJC_GetExtCertInfo(byte[] usrCert, String infoID) {
        String info;
        block4: {
            info = null;
            try {
                DERObjectIdentifier derIdenti = new DERObjectIdentifier(infoID);
                X509CertificateStructure cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(usrCert));
                X509Extension extension = cert.getTBSCertificate().getExtensions().getExtension(derIdenti);
                if (extension != null) {
                    char head;
                    byte[] infoByte = extension.getValue().getOctets();
                    info = new String(infoByte, "utf-8");
                    if (info != null && !info.equals("") && (head = info.charAt(0)) == '\f') {
                        info = info.substring(2, info.length());
                    }
                    break block4;
                }
                return null;
            }
            catch (Exception e) {
                info = null;
                this.debuglog("Exception in getting certificate extension value:" + infoID);
            }
        }
        return info;
    }

    public int BJC_VerifyUsrCertificate_old_version(byte[] usrCert, ArrayList p7List, String m_verifyTime, int m_policytype, ArrayList m_catypeList, Properties m_appProhibitsList, String m_uniqidoid) throws CertificateException, ValidateCertException {
        int i;
        ArrayList cloneP7List = (ArrayList)p7List.clone();
        int retValue = 0;
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(usrCert);
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        String serialNum = this.BJC_GetBasicCertInfo(usrCert, 2L);
        this.debuglog("Certificate serial number == " + serialNum);
        try {
            int p7Length = cloneP7List.size();
            for (i = 0; i < p7Length; ++i) {
                Certificate p7Obj = (Certificate)cloneP7List.get(i);
                this.debuglog("P7 certificate content == " + p7Obj.hashCode());
                PublicKey oPbKey = p7Obj.getPublicKey();
                try {
                    oCert.verify(oPbKey);
                    retValue = 1;
                    break;
                }
                catch (Exception ex) {
                    retValue = -1;
                    continue;
                }
            }
            if (retValue == -1) {
                this.debuglog("The certificate is not trusted");
                return -1;
            }
        }
        catch (Exception e) {
            this.errorlog("Exception in verifying certificate's p7", e);
            this.debuglog("Exception in verifying certificate's p7");
            throw new ValidateCertException("Exception in verifying certificate's p7");
        }
        if (1 == m_policytype || 2 == m_policytype) {
            boolean isEffective = this.isCertEffective(usrCert);
            if (!isEffective) {
                return -5;
            }
            String verifyTime = m_verifyTime;
            if (verifyTime != null && !verifyTime.equals("")) {
                int iday = 0;
                try {
                    iday = this.BJC_CheckCertValidity(usrCert, null);
                }
                catch (Exception e) {
                    retValue = 0;
                    this.errorlog("Exception in verifying certificate's validity", e);
                    this.debuglog("Exception in verifying certificate's validity");
                    throw new ValidateCertException("Exception in verifying certificate's validity");
                }
                boolean bValidaty = iday < Integer.parseInt(verifyTime);
                this.debuglog("Actual expired days == " + iday);
                this.debuglog("Allowed to expire days == " + verifyTime);
                if (!bValidaty) {
                    this.debuglog("The certificate is expired!");
                    return -2;
                }
            }
        }
        if (2 == m_policytype) {
            Hashtable listCrl = (Hashtable)SuperEngine.listCrl.clone();
            for (i = 0; i < m_catypeList.size(); ++i) {
                String caName = (String)m_catypeList.get(i);
                String issuerDn = this.BJC_GetBasicCertInfo(usrCert, 20L);
                X509CRLObject crlObj = null;
                try {
                    crlObj = (X509CRLObject)listCrl.get(caName);
                }
                catch (Exception e) {
                    crlObj = null;
                    this.errorlog("Exception in getting crl content from list", e);
                    this.debuglog("Exception in getting crl content from list");
                }
                if (crlObj == null) continue;
                try {
                    String crlIssuerDN = crlObj.getIssuerDN().getName();
                    this.debuglog(caName + " CRL issuer DN == " + crlIssuerDN);
                    this.debuglog(caName + " cert issuer DN == " + issuerDn);
                    X509Name certIssuerX509DN = new X509Name(issuerDn);
                    X509Name crlIssuerX509DN = new X509Name(crlIssuerDN);
                    if (!certIssuerX509DN.equals(crlIssuerX509DN)) continue;
                    this.debuglog("start verify " + caName + " CRL ");
                    this.debuglog("the usercert == " + oCert);
                    boolean isOnCRL = crlObj.isRevoked(oCert);
                    this.debuglog("verify result == " + isOnCRL);
                    if (!isOnCRL) continue;
                    return -3;
                }
                catch (Exception e) {
                    this.errorlog("Exception in validating certificate by CRL", e);
                    this.debuglog("Exception in validating certificate by CRL");
                    throw new ValidateCertException("Exception in validating certificate by CRL");
                }
            }
        }
        String uniqid = "";
        try {
            this.debuglog("The application oid == " + m_uniqidoid);
            this.debuglog("The user certificate == " + usrCert);
            uniqid = this.BJC_GetExtCertInfo(usrCert, m_uniqidoid);
            if (uniqid == null) {
                uniqid = "";
            }
            this.debuglog("The user id == " + uniqid);
        }
        catch (Exception e) {
            uniqid = "";
            this.errorlog("Exception in getting certificate's unique id", e);
            this.debuglog("Exception in getting certificate's unique id" + m_uniqidoid);
        }
        ArrayList listUniqid = (ArrayList)m_appProhibitsList.get("uniqid");
        this.debuglog("The black list of user id == " + listUniqid);
        ArrayList listSerialnum = (ArrayList)m_appProhibitsList.get("serialnum");
        this.debuglog("The black list of serialnum  == " + listSerialnum);
        if (listUniqid.indexOf(uniqid) > -1) {
            retValue = -4;
            this.debuglog("The certificate has been frozen!");
        }
        if (listSerialnum.indexOf(serialNum) > -1) {
            retValue = -4;
            this.debuglog("The certificate has been frozen!");
        }
        return retValue;
    }

    public int verifyCertificate(byte[] usrCert, int m_Iinitmodel, HashMap p7Map, Hashtable crlTable, String m_verifyTime, int m_policytype, ArrayList m_catypeList, Properties m_appProhibitsList, String m_uniqidoid) throws CertificateException, ValidateCertException {
        TreeSet crlList;
        int retValue = 0;
        X509CertificateStructure cert = null;
        try {
            cert = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(usrCert));
        }
        catch (IOException e1) {
            this.errorlog("Exception in configure certificate structure", e1);
            this.debuglog("Exception in configure certificate structure");
        }
        String serialNum = cert.getSerialNumber().getValue().toString(16);
        X509Name certX509Name = cert.getIssuer();
        this.debuglog("Certificate serial number == " + serialNum);
        String authorityKeyIdentifier = cert.getTBSCertificate().getExtensions().getExtension(X509Extensions.AuthorityKeyIdentifier).getValue().toString();
        int keyIdentifierLen = authorityKeyIdentifier == null ? 0 : authorityKeyIdentifier.length();
        Object p7MapKey = certX509Name;
        if (keyIdentifierLen > 9) {
            p7MapKey = certX509Name + authorityKeyIdentifier.substring(9);
        }
        try {
            X509CertificateStructure p7Obj = (X509CertificateStructure)p7Map.get(p7MapKey);
            if (p7Obj == null) {
                return -1;
            }
            this.debuglog("P7 certificate content == " + p7Obj.hashCode());
            boolean isSuccess = this.validateCertSignature(p7Obj, cert, m_Iinitmodel);
            if (!isSuccess) {
                this.debuglog("The certificate is not trusted");
                return -1;
            }
            retValue = 1;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in verifying certificate's p7", e);
            this.debuglog("Exception in verifying certificate's p7");
            throw new ValidateCertException("Exception in verifying certificate's p7");
        }
        if (1 == m_policytype || 2 == m_policytype) {
            int verifyDay;
            Date startDate = cert.getStartDate().getDate();
            long startDateCompare = CertificateUtil.compareDateWithNowDate(startDate, 0);
            if (startDateCompare > 0L) {
                return -5;
            }
            Date endDate = cert.getEndDate().getDate();
            long endDateCompare = CertificateUtil.compareDateWithNowDate(endDate, verifyDay = Integer.parseInt(m_verifyTime));
            if (endDateCompare <= 0L) {
                this.debuglog("The certificate is expired!");
                return -2;
            }
        }
        if (2 == m_policytype && (crlList = (TreeSet)crlTable.get(p7MapKey)) != null && crlList.contains(serialNum)) {
            return -3;
        }
        ArrayList listUniqid = (ArrayList)m_appProhibitsList.get("uniqid");
        this.debuglog("The black list of user id == " + listUniqid);
        ArrayList listSerialnum = (ArrayList)m_appProhibitsList.get("serialnum");
        this.debuglog("The black list of serialnum  == " + listSerialnum);
        String uniqid = "";
        if (listUniqid.size() > 0) {
            try {
                this.debuglog("The application oid == " + m_uniqidoid);
                this.debuglog("The user certificate == " + usrCert);
                uniqid = this.BJC_GetExtCertInfo(usrCert, m_uniqidoid);
                if (uniqid == null) {
                    uniqid = "";
                }
                this.debuglog("The user id == " + uniqid);
            }
            catch (Exception e) {
                uniqid = "";
                this.errorlog("Exception in getting certificate's unique id", e);
                this.debuglog("Exception in getting certificate's unique id" + m_uniqidoid);
            }
            if (listUniqid.indexOf(uniqid) > -1) {
                retValue = -4;
                this.debuglog("The certificate has been frozen!");
            }
        }
        if (listSerialnum.size() > 0 && listSerialnum.indexOf(serialNum.toUpperCase()) > -1) {
            retValue = -4;
            this.debuglog("The certificate has been frozen!");
        }
        this.debuglog("Verify certificate result  == " + retValue);
        return retValue;
    }

    public int verifyCertificate_old_2_5(byte[] usrCert, ArrayList p7List, String m_verifyTime, int m_policytype, ArrayList m_catypeList, Properties m_appProhibitsList, String m_uniqidoid) throws CertificateException, ValidateCertException {
        int retValue = 0;
        CertificateFactory oCf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream ois = new ByteArrayInputStream(usrCert);
        X509Certificate oCert = (X509Certificate)oCf.generateCertificate(ois);
        String serialNum = oCert.getSerialNumber().toString(16);
        this.debuglog("Certificate serial number == " + serialNum);
        try {
            int p7Length = p7List.size();
            for (int i = 0; i < p7Length; ++i) {
                Certificate p7Obj = (Certificate)p7List.get(i);
                this.debuglog("P7 certificate content == " + p7Obj.hashCode());
                PublicKey oPbKey = p7Obj.getPublicKey();
                try {
                    oCert.verify(oPbKey);
                    retValue = 1;
                    break;
                }
                catch (Exception ex) {
                    retValue = -1;
                    continue;
                }
            }
            if (retValue == -1) {
                this.debuglog("The certificate is not trusted");
                return -1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorlog("Exception in verifying certificate's p7", e);
            this.debuglog("Exception in verifying certificate's p7");
            throw new ValidateCertException("Exception in verifying certificate's p7");
        }
        if (1 == m_policytype || 2 == m_policytype || 3 == m_policytype) {
            Date nowDate = new Date();
            Date endDate = oCert.getNotAfter();
            boolean isEnd = endDate.after(nowDate);
            if (!isEnd) {
                return -2;
            }
            Date startDate = oCert.getNotBefore();
            boolean isStart = startDate.before(nowDate);
            if (!isStart) {
                return -5;
            }
        }
        if (2 == m_policytype || 3 == m_policytype) {
            for (int i = 0; i < m_catypeList.size(); ++i) {
                String caName = (String)m_catypeList.get(i);
                ArrayList crlList = null;
                try {
                    crlList = (ArrayList)SuperEngine.listCrlSn.get(caName);
                }
                catch (Exception e) {
                    crlList = null;
                    this.errorlog("Exception in getting crl content from list", e);
                    this.debuglog("Exception in getting crl content from list");
                }
                if (crlList == null || !crlList.contains(serialNum)) continue;
                return -3;
            }
        }
        if (3 == m_policytype) {
            String uniqid = "";
            try {
                this.debuglog("The application oid == " + m_uniqidoid);
                this.debuglog("The user certificate == " + usrCert);
                uniqid = this.BJC_GetExtCertInfo(usrCert, m_uniqidoid);
                if (uniqid == null) {
                    uniqid = "";
                }
                this.debuglog("The user id == " + uniqid);
            }
            catch (Exception e) {
                uniqid = "";
                this.errorlog("Exception in getting certificate's unique id", e);
                this.debuglog("Exception in getting certificate's unique id" + m_uniqidoid);
            }
            ArrayList listUniqid = (ArrayList)m_appProhibitsList.get("uniqid");
            this.debuglog("The black list of user id == " + listUniqid);
            ArrayList listSerialnum = (ArrayList)m_appProhibitsList.get("serialnum");
            this.debuglog("The black list of serialnum  == " + listSerialnum);
            if (listUniqid.indexOf(uniqid) > -1) {
                retValue = -4;
                this.debuglog("The certificate has been frozen!");
            }
            if (listSerialnum.indexOf(serialNum) > -1) {
                retValue = -4;
                this.debuglog("The certificate has been frozen!");
            }
        }
        return retValue;
    }

    public int BJC_CheckCertValidity(byte[] usrCert, String sDate) {
        int iday = 0;
        try {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            Date compDate = null;
            compDate = sDate == null || sDate.equals("") ? new Date() : dateformat.parse(sDate);
            String strdateto = this.BJC_GetBasicCertInfo(usrCert, 12L);
            Date dateto = dateformat.parse(strdateto);
            long ldate = (dateto.getTime() - compDate.getTime()) / 86400000L;
            iday = (int)ldate;
        }
        catch (Exception e) {
            iday = 0;
            this.errorlog("Exception in checking the validity of the certificate", e);
            this.debuglog("Exception in checking the validity of the certificate");
        }
        return -iday;
    }

    public int checkCertValidity(byte[] usrCert, String sDate) {
        int iday = 0;
        try {
            SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
            Date compDate = null;
            compDate = sDate == null || sDate.equals("") ? new Date() : dateformat.parse(sDate);
            String strdateto = this.BJC_GetBasicCertInfo(usrCert, 12L);
            Date dateto = dateformat.parse(strdateto);
            long ldate = (dateto.getTime() - compDate.getTime()) / 86400000L;
            iday = (int)ldate;
        }
        catch (Exception e) {
            iday = 0;
            this.errorlog("Exception in checking the validity of the certificate", e);
            this.debuglog("Exception in checking the validity of the certificate");
        }
        return -iday;
    }

    public boolean isCertEffective(byte[] usrCert) {
        Date nowData = new Date();
        SimpleDateFormat dateformat = new SimpleDateFormat("yyyy/MM/dd");
        String strStartDate = this.BJC_GetBasicCertInfo(usrCert, 11L);
        try {
            Date dateto = dateformat.parse(strStartDate);
            if (dateto.getTime() > nowData.getTime()) {
                return false;
            }
        }
        catch (ParseException e) {
            this.errorlog("Exception in parse the cert start date !!!", e);
            this.debuglog("Exception in parse the cert start date !!!");
            return false;
        }
        return true;
    }

    public static long compareDateWithNowDate(Date toBevalidDate, int day) {
        Date nowData = new Date();
        long intervalTime = (long)day * 86400L * 1000L;
        long result = toBevalidDate.getTime() - nowData.getTime() + intervalTime;
        return result;
    }

    public String getCRLInfo(byte[] crlByte, int infoType) {
        try {
            ByteArrayInputStream bIn = new ByteArrayInputStream(crlByte);
            ASN1InputStream aIn = new ASN1InputStream(bIn);
            ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
            CertificateList certList = new CertificateList(seq);
            String thisUpdateTime = certList.getThisUpdate().getTime() + "";
            String nextUpdateTime = certList.getNextUpdate().getTime() + "";
            X509Name issuerX509Name = certList.getIssuer();
            String issuerName = issuerX509Name.toString().trim();
            if (infoType == 1) {
                return thisUpdateTime;
            }
            if (infoType == 2) {
                return nextUpdateTime;
            }
            if (infoType == 3) {
                return issuerName;
            }
            return null;
        }
        catch (Exception e) {
            this.errorlog("Exception in getting crl's infomation !!!", e);
            this.debuglog("Exception in getting crl's infomation !!!");
            return null;
        }
    }

    public boolean isCRLValid(CertificateList crlCertList, X509CertificateStructure p7ChildCert) throws IOException, HashException, VerifySignDataException {
        boolean isSuccess = false;
        byte[] toBeSignCrl = crlCertList.getTBSCertList().getEncoded();
        byte[] signedCrlData = crlCertList.getSignature().getBytes();
        DERObjectIdentifier algorithmIdenti = p7ChildCert.getSubjectPublicKeyInfo().getAlgorithmId().getObjectId();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals(algorithmIdenti)) {
            WrapCard wCard = new WrapCard();
            isSuccess = wCard.vefiySM3WithSM2Sign(toBeSignCrl, p7ChildCert, signedCrlData);
        } else {
            RsaUtil rsaU = new RsaUtil("");
            HashUtil hashU = new HashUtil("");
            byte[] hashedData = hashU.BJS_HashBytes(1L, toBeSignCrl);
            isSuccess = rsaU.verifySignHashedData(hashedData, signedCrlData, p7ChildCert);
            if (!isSuccess) {
                hashedData = hashU.BJS_HashBytes(2L, toBeSignCrl);
                isSuccess = rsaU.verifySignHashedData(hashedData, signedCrlData, p7ChildCert);
            }
        }
        return isSuccess;
    }

    public boolean isCRLValid(byte[] crlByte, byte[] p7Byte) throws Exception {
        boolean isSuccess = false;
        ByteArrayInputStream bIn = new ByteArrayInputStream(crlByte);
        ASN1InputStream aIn = new ASN1InputStream(bIn);
        ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
        CertificateList crlCertList = new CertificateList(seq);
        X509CertificateStructure[] p7certList = P7bUtil.getCertChain(p7Byte);
        X509CertificateStructure p7ChildCert = p7certList[0];
        isSuccess = this.isCRLValid(crlCertList, p7ChildCert);
        return isSuccess;
    }

    public int validateP7Cert(byte[] p7Byte) throws CryptoException, CertificateException, IOException {
        X509CertificateStructure[] p7certList = P7bUtil.getCertChain(p7Byte);
        int p7Len = p7certList.length;
        for (int i = 0; i < p7Len; ++i) {
            if (p7certList[i] == null) {
                return -1;
            }
            int expiredDay = this.BJC_CheckCertValidity(p7certList[i].getEncoded(), null);
            if (expiredDay <= 0) continue;
            return -2;
        }
        return 1;
    }

    public boolean validateCertSignature(X509CertificateStructure fatherCert, X509CertificateStructure childCert, int model) throws IOException, HashException, VerifySignDataException {
        boolean isSuccess = false;
        byte[] toBeSignCert = childCert.getTBSCertificate().getEncoded();
        byte[] signedData = childCert.getSignature().getBytes();
        DERObjectIdentifier childAlgorithmIdenti = childCert.getSubjectPublicKeyInfo().getAlgorithmId().getObjectId();
        if (X9ObjectIdentifiers.id_ecPublicKey.equals(childAlgorithmIdenti)) {
            WrapCard wCard = new WrapCard();
            isSuccess = wCard.vefiySM3WithSM2Sign(toBeSignCert, fatherCert, signedData);
        } else {
            RsaUtil rsaU = new RsaUtil("");
            HashUtil hashU = new HashUtil("");
            byte[] hashedData = hashU.BJS_HashBytes(2L, toBeSignCert);
            isSuccess = rsaU.verifySignHashedData(hashedData, signedData, fatherCert);
            if (!isSuccess) {
                hashedData = hashU.BJS_HashBytes(0L, toBeSignCert);
                byte[] pubKey = fatherCert.getSubjectPublicKeyInfo().getPublicKeyData().getBytes();
                ByteArrayInputStream bin = new ByteArrayInputStream(pubKey);
                ASN1InputStream aIn = new ASN1InputStream(bin);
                ASN1Sequence seq = (ASN1Sequence)aIn.readObject();
                RSAPublicKeyStructure rSAPublicKeyStructure = new RSAPublicKeyStructure(seq);
                BigInteger modulus = rSAPublicKeyStructure.getModulus();
                BigInteger exponents = rSAPublicKeyStructure.getPublicExponent();
                RSAKeyParameters RSApubKey = new RSAKeyParameters(false, modulus, exponents);
                BJCASigner bjcaSigner = new BJCASigner(new SHA1Digest());
                bjcaSigner.init(false, RSApubKey);
                bjcaSigner.update(hashedData, 0, hashedData.length);
                isSuccess = bjcaSigner.verifySignature(signedData);
            }
        }
        return isSuccess;
    }

    public boolean validateCertChain(X509CertificateStructure[] certChain, int model) throws Exception {
        int len = certChain.length;
        if (len < 2) {
            return true;
        }
        for (int i = 1; i < len; ++i) {
            boolean isSuccess = this.validateCertSignature(certChain[i], certChain[i - 1], model);
            if (isSuccess) continue;
            Base64Util base64U = new Base64Util(this.applicationName);
            this.errorlog("Exception in validateCertChain , the error certificate == " + base64U.BJS_EncodeBase64(certChain[i].getEncoded()) + " && " + base64U.BJS_EncodeBase64(certChain[i - 1].getEncoded()));
            this.debuglog("Exception in validateCertChain , the error certificate == " + base64U.BJS_EncodeBase64(certChain[i].getEncoded()) + " && " + base64U.BJS_EncodeBase64(certChain[i - 1].getEncoded()));
            return false;
        }
        return true;
    }

    public X509CertificateStructure getX509CertStrc(String base64Cert) {
        X509CertificateStructure p7CertStrc = null;
        try {
            Base64Util base64Util = new Base64Util(this.applicationName);
            byte[] certbuf = base64Util.BJS_DecodeBase64(base64Cert);
            p7CertStrc = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(certbuf));
        }
        catch (Exception e) {
            this.errorlog("Exception in getX509CertStrc !", e);
            this.debuglog("Exception in getX509CertStrc !");
            return null;
        }
        return p7CertStrc;
    }

    public X509CertificateStructure getX509CertStrc(byte[] cert) {
        X509CertificateStructure p7CertStrc = null;
        try {
            p7CertStrc = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(cert));
        }
        catch (Exception e) {
            this.errorlog("Exception in getX509CertStrc !", e);
            this.debuglog("Exception in getX509CertStrc !");
            return null;
        }
        return p7CertStrc;
    }

    public static void main(String[] str) {
        try {
            CertificateUtil certU = new CertificateUtil("");
            FileUtil fileU = new FileUtil("");
            byte[] father = fileU.readFile("D:\\2018\u5de5\u4f5c\u76f8\u5173\\\u9879\u76ee\u652f\u6301\\\u6ee8\u6d77CA\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u4e0d\u8fc7\u7684\u95ee\u9898\\ROOTca.cer");
            byte[] child = fileU.readFile("D:\\2018\u5de5\u4f5c\u76f8\u5173\\\u9879\u76ee\u652f\u6301\\\u6ee8\u6d77CA\u8bc1\u4e66\u94fe\u9a8c\u8bc1\u4e0d\u8fc7\u7684\u95ee\u9898\\TJca.cer");
            X509CertificateStructure fatherStrc = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(father));
            X509CertificateStructure childStrc = new X509CertificateStructure((ASN1Sequence)DerUtil.getDerObject(child));
            X509CertificateStructure[] certChain = new X509CertificateStructure[]{childStrc, fatherStrc};
            boolean rere = certU.validateCertChain(certChain, 4);
            System.out.println(rere);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

