/*
 * Decompiled with CFR 0.152.
 */
package xjyb.cn.org.bjca.java.utils;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import xjyb.cn.org.bjca.framework.Log;
import xjyb.cn.org.bjca.java.utils.KeyPairUtil;
import xjyb.cn.org.bjca.utils.FileUtil;
import xjyb.cn.org.bjca.utils.GetPathUtil;

public class JKSUtil
extends Log {
    public JKSUtil() {
        super("JKSUtil");
    }

    public void jksGenerator(String filePath, String jksAlias, PrivateKey privateKey, String keyPassword, String storePassword, X509Certificate cert) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        Certificate[] caCertChain = new X509Certificate[]{cert};
        KeyStore ks1 = KeyStore.getInstance("JKS");
        ks1.load(null, null);
        ks1.setKeyEntry(jksAlias, privateKey, keyPassword.toCharArray(), caCertChain);
        String dirPath = GetPathUtil.getDirPathFromFilePath(filePath);
        GetPathUtil.confirmDir(dirPath);
        FileOutputStream fos = new FileOutputStream(filePath);
        ks1.store(fos, storePassword.toCharArray());
        fos.close();
    }

    public static void main(String[] args) {
        try {
            JKSUtil jksU = new JKSUtil();
            FileUtil fileUtil = new FileUtil("");
            byte[] cert = fileUtil.readFile("c:/123.der");
            CertificateFactory oCf = CertificateFactory.getInstance("X.509");
            ByteArrayInputStream ois = new ByteArrayInputStream(cert);
            X509Certificate x509Cert = (X509Certificate)oCf.generateCertificate(ois);
            KeyPairUtil keyPairUtil = new KeyPairUtil("");
            keyPairUtil.generatorKeyPair();
            PrivateKey privateKey = keyPairUtil.getPrivateKey();
            ByteArrayOutputStream byteArrayOutStream = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(byteArrayOutStream);
            oos.writeObject(privateKey);
            byte[] realPrivateKeyObjByte = byteArrayOutStream.toByteArray();
            ByteArrayInputStream in = new ByteArrayInputStream(realPrivateKeyObjByte);
            ObjectInputStream oIn = new ObjectInputStream(in);
            PrivateKey privateKeyO = (PrivateKey)oIn.readObject();
            jksU.jksGenerator("c:/test.jks", "testKey", privateKeyO, "111111", "111111", x509Cert);
            KeyStore keyStore = KeyStore.getInstance("JKS");
            FileInputStream oFis = new FileInputStream("c:/test.jks");
            keyStore.load(oFis, "111111".toCharArray());
            Certificate certGet = keyStore.getCertificate("testKey");
            byte[] certGetByte = certGet.getEncoded();
            fileUtil.writeFile(certGetByte, "c:/test2.der");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

