/*
 * Decompiled with CFR 0.152.
 */
package com.xjyb.util;

import com.xjyb.config.Constants;
import com.xjyb.exception.InvalidArgumentException;
import com.xjyb.exception.NullArgumentException;
import java.nio.charset.StandardCharsets;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import xjyb.cn.org.bjca.exception.AlgorithmNotFoundException;
import xjyb.cn.org.bjca.security.SecurityUtil;
import xjyb.com.alibaba.fastjson.JSONObject;

public class SecureCommonUtil {
    private static final char[] DIGITS_LOWER = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};

    public static String bytesToHexString(byte[] bytes) {
        int len = bytes.length;
        char[] out = new char[len << 1];
        int j = 0;
        for (int i = 0; i < len; ++i) {
            out[j++] = DIGITS_LOWER[(0xF0 & bytes[i]) >>> 4];
            out[j++] = DIGITS_LOWER[0xF & bytes[i]];
        }
        return new String(out);
    }

    public static byte[] stringToBytes(String s) {
        int len = s.length();
        byte[] b = new byte[(len + 1) / 2];
        for (int i = 0; i < len; i += 2) {
            b[i / 2] = (byte)(Character.digit(s.charAt(i), 16) << 4 | Character.digit(i + 1 == len ? (char)'0' : s.charAt(i + 1), 16));
        }
        return b;
    }

    public static boolean equals(String cs1, String cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return cs1.equals(cs2);
    }

    public static boolean equalsIgnoreCase(String cs1, String cs2) {
        if (cs1 == cs2) {
            return true;
        }
        if (cs1 == null || cs2 == null) {
            return false;
        }
        if (cs1.length() != cs2.length()) {
            return false;
        }
        return cs1.equalsIgnoreCase(cs2);
    }

    public static <T> void requireNonNull(T obj, String message) {
        if (obj == null) {
            throw new NullArgumentException(message);
        }
    }

    public static void checkTransId(String transId) {
        if (transId == null) {
            throw new NullArgumentException("transId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (transId.length() > 128) {
            throw new InvalidArgumentException("transId\u957f\u5ea6\u4e0d\u80fd\u8d85\u8fc7128\uff0c\u5b9e\u9645\u4f20\u5165\u957f\u5ea6\uff1a" + transId.length());
        }
        String regStr = "^[0-9a-fA-F]+$";
        if (!transId.matches(regStr)) {
            throw new InvalidArgumentException("transId\u5fc5\u987b\u4e3a16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
        }
    }

    public static void checkRandomLen(String random, String randomLen) {
        if (randomLen != null && random != null) {
            if (!("4".equals(randomLen) || "8".equals(randomLen) || "16".equals(randomLen))) {
                throw new InvalidArgumentException("randomLen\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30104,8,16\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + randomLen);
            }
            String regStr = "^[0-9a-fA-F]+$";
            if (!random.matches(regStr)) {
                throw new InvalidArgumentException("random\u5fc5\u987b\u4e3a16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
            }
            int randomLenInt = Integer.parseInt(randomLen);
            if (random.length() != randomLenInt * 2) {
                throw new InvalidArgumentException("\u4f20\u5165\u968f\u673a\u6570\u3010random\u3011\u957f\u5ea6\u548c\u4f20\u5165\u7684\u968f\u673a\u6570\u957f\u5ea6\u3010randomLen\u3011\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e\uff01");
            }
        } else {
            if (randomLen == null && random == null) {
                return;
            }
            throw new InvalidArgumentException("\u4f20\u5165\u968f\u673a\u6570\u3010random\u3011\u957f\u5ea6\u548c\u4f20\u5165\u7684\u968f\u673a\u6570\u957f\u5ea6\u3010randomLen\u3011\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e\uff01");
        }
    }

    public static void checkKeyType(String keyType) {
        switch (keyType) {
            case "ZMK": {
                break;
            }
            case "PIK": {
                break;
            }
            case "MAK": {
                break;
            }
            case "CVK": {
                break;
            }
            case "PVK": {
                break;
            }
            case "VIPK": {
                break;
            }
            case "DPMAK": {
                break;
            }
            case "WWK": {
                break;
            }
            case "ZEK": {
                break;
            }
            case "MDKAC": {
                break;
            }
            case "MKENC": {
                break;
            }
            case "MKMAC": {
                break;
            }
            case "KMC": {
                break;
            }
            default: {
                throw new InvalidArgumentException("keyType\u73b0\u5728\u652f\u6301\u7684\u5bc6\u94a5\u7c7b\u578b\u4e3a\u3010ZMK|PIK|MAK|CVK|PVK|VIPK|DPMAK|WWK|ZEK|MDKAC|MKENC|MKMAC|KMC\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + keyType);
            }
        }
    }

    public static void checkAlgFlag(String algFlag) {
        if (!"1".equals(algFlag) && !"2".equals(algFlag)) {
            throw new InvalidArgumentException("algFlag\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u30101:3DES,2:SM4\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + algFlag);
        }
    }

    public static void checkAlgMode(String algMode) {
        if (!"1".equals(algMode) && !"2".equals(algMode)) {
            throw new InvalidArgumentException("algMode\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f\u30101:ECB,2:CBC\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + algMode);
        }
    }

    public static void checkMacFlag(String macFlag) {
        if (!("1".equals(macFlag) || "2".equals(macFlag) || "3".equals(macFlag))) {
            throw new InvalidArgumentException("macFlag\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u6a21\u5f0f\u30101:ANSI9.9,2:ANSI9.19,3:PBOC3.0\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + macFlag);
        }
    }

    public static void checkData(String inData) {
        int length = Base64.getDecoder().decode(inData).length;
        if (length > 2048) {
            throw new InvalidArgumentException("\u4f20\u8f93\u6570\u636e\u6700\u5927\u957f\u5ea6\u4e0d\u80fd\u51b2\u8fc71024\u5b57\u8282\uff0c\u4f20\u5165\u53c2\u6570\uff1a" + inData + "\uff0c\u6570\u636e\u957f\u5ea6\uff1a" + length);
        }
    }

    public static void checkIv(String algMode, String algFlag, String iv) {
        if ("2".equals(algMode)) {
            Objects.requireNonNull(iv, "algMode\u4e3a CBC\u6a21\u5f0f\u65f6IV\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            if ("1".equals(algFlag)) {
                if (iv.length() != 16) {
                    throw new RuntimeException("algFlag\u662f'1'\u65f6\uff0civ\u3010" + iv + "\u3011\u957f\u5ea6\u5fc5\u987b\u662f16\uff01");
                }
            } else if ("2".equals(algFlag) && iv.length() != 32) {
                throw new RuntimeException("algFlag\u662f'2'\u65f6\uff0civ\u3010" + iv + "\u3011\u957f\u5ea6\u5fc5\u987b\u662f32\uff01");
            }
        }
    }

    public static void checkIvAndAlgFlag(String algFlag, String iv) {
        int ivLen = iv.length();
        if ("1".equals(algFlag)) {
            if (ivLen != 16) {
                throw new InvalidArgumentException("algFlag\u4e3a'1'\u65f6\uff0c\u957f\u5ea6\u5e94\u4e3a16\uff0c\u73b0\u5728\u6570\u636e\u957f\u5ea6\uff1a" + ivLen);
            }
        } else if ("2".equals(algFlag)) {
            if (ivLen != 32) {
                throw new InvalidArgumentException("algFlag\u4e3a'2'\u65f6\uff0c\u957f\u5ea6\u5e94\u4e3a32\uff0c\u73b0\u5728\u6570\u636e\u957f\u5ea6\uff1a" + ivLen);
            }
        } else {
            throw new InvalidArgumentException("algFlag\u73b0\u5728\u652f\u6301\u7684\u7b97\u6cd5\u30101:3DES,2:SM4\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + algFlag);
        }
    }

    public static void checkLength(String data, int length) {
        if (data.length() != length) {
            throw new InvalidArgumentException("\u8f93\u5165\u6570\u636e\u3010" + data + "\u3011\u957f\u5ea6\u4e0d\u662f" + length + ",\u8bf7\u68c0\u67e5\u8f93\u5165\u6570\u636e\u662f\u5426\u6b63\u786e!");
        }
    }

    public static String randomHexString(int len) {
        char[] chars = new char[len];
        for (int i = 0; i < len; ++i) {
            try {
                chars[i] = Integer.toHexString(SecureRandom.getInstance("SHA1PRNG", "SUN").nextInt(16)).charAt(0);
                continue;
            }
            catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
                continue;
            }
            catch (NoSuchProviderException e) {
                e.printStackTrace();
            }
        }
        return new String(chars);
    }

    public static void main(String[] args) {
        SecureCommonUtil.checkAlgFlag("1");
        SecureCommonUtil.checkAlgFlag("2");
        SecureCommonUtil.checkAlgFlag("3");
        SecureCommonUtil.checkAlgMode("1");
        SecureCommonUtil.checkAlgMode("2");
        SecureCommonUtil.checkAlgMode("3");
        SecureCommonUtil.checkMacFlag("-1");
        SecureCommonUtil.checkMacFlag("2");
        SecureCommonUtil.checkMacFlag("3");
        SecureCommonUtil.checkMacFlag("4");
    }

    public static void checkParams(JSONObject jsonObject, String key1) {
        long s1 = System.currentTimeMillis();
        if (!jsonObject.containsKey(key1)) {
            throw new InvalidArgumentException("\u4f20\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e:" + jsonObject.toJSONString());
        }
        long s2 = System.currentTimeMillis();
        System.out.println("checkParams : " + (s2 - s1) + "ms");
    }

    public static void checkParams(JSONObject jsonObject, String key1, String key2) {
        boolean flag;
        boolean bl = flag = jsonObject.containsKey(key1) && jsonObject.containsKey(key2);
        if (!flag) {
            throw new InvalidArgumentException("\u4f20\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + jsonObject.toJSONString());
        }
    }

    public static void checkParams(JSONObject jsonObject, String key1, String key2, String key3) {
        boolean flag;
        boolean bl = flag = jsonObject.containsKey(key1) && jsonObject.containsKey(key2) && jsonObject.containsKey(key3);
        if (!flag) {
            throw new InvalidArgumentException("\u4f20\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + jsonObject.toJSONString());
        }
    }

    public static void checkParams(JSONObject jsonObject, String key1, String key2, String key3, String key4) {
        boolean flag;
        boolean bl = flag = jsonObject.containsKey(key1) && jsonObject.containsKey(key2) && jsonObject.containsKey(key3) && jsonObject.containsKey(key4);
        if (!flag) {
            throw new InvalidArgumentException("\u4f20\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + jsonObject.toJSONString());
        }
    }

    public static void checkParams(JSONObject jsonObject, String ... keys) {
        for (String key : keys) {
            if (jsonObject.containsKey(key)) continue;
            throw new InvalidArgumentException("\u4f20\u5165\u53c2\u6570\u683c\u5f0f\u4e0d\u6b63\u786e\uff1a" + jsonObject.toJSONString());
        }
    }

    public static void checkCardType(String cardType) {
        if (!("0".equals(cardType) && "8".equals(cardType) && "N".equals(cardType))) {
            throw new InvalidArgumentException("cardType\u7b7e\u7f72\u65b9\u8bc1\u4ef6\u7c7b\uff080\u30018\u3001N\uff09\u578b0=\u5c45\u6c11\u8eab\u4efd\u8bc1\uff0c8=\u4f01\u4e1a\u8425\u4e1a\u6267\u7167\uff0cN=\u793e\u4f1a\u7edf\u4e00\u4fe1\u7528\u4ee3\u7801\u3002\u4f20\u5165cardType\uff1a" + cardType);
        }
    }

    public static Map<String, String> checkDn(String dn) {
        String[] items;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String item : items = dn.split(",")) {
            String[] entry = item.split("=");
            if (entry.length != 2) {
                throw new InvalidArgumentException("dn\u7ed3\u6784\u4e0d\u5408\u6cd5\uff01");
            }
            map.put(entry[0].toLowerCase(), entry[1]);
        }
        if (map.get("cn") == null) {
            throw new InvalidArgumentException("dn\u7ed3\u6784\u4e0d\u5408\u6cd5\uff1acn\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        return map;
    }

    public static String encCertKey(String key) throws AlgorithmNotFoundException {
        byte[] vbytes = SecurityUtil.getInstance().symmEncryptData(key.getBytes(StandardCharsets.UTF_8), Constants.SYMMKEY, "SM4");
        return Base64.getEncoder().encodeToString(vbytes);
    }

    public static String decCertKey(String keyEnced) throws AlgorithmNotFoundException {
        byte[] keyBytes = SecurityUtil.getInstance().symmDecryptData(Base64.getDecoder().decode(keyEnced), Constants.SYMMKEY, "SM4");
        return new String(keyBytes, StandardCharsets.UTF_8);
    }

    public static byte[] byteMergerAll(byte[] ... values) {
        int length_byte = 0;
        for (int i = 0; i < values.length; ++i) {
            length_byte += values[i].length;
        }
        byte[] all_byte = new byte[length_byte];
        int countLength = 0;
        for (int i = 0; i < values.length; ++i) {
            byte[] b = values[i];
            System.arraycopy(b, 0, all_byte, countLength, b.length);
            countLength += b.length;
        }
        return all_byte;
    }

    public static void checkDiversify(String diversifyTimes, String diversifyFactor1, String diversifyFactor2, String diversifyFactor3) {
        if (diversifyTimes == null) {
            throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!("0".equals(diversifyTimes) || "1".equals(diversifyTimes) || "2".equals(diversifyTimes) || "3".equals(diversifyTimes))) {
            throw new InvalidArgumentException("diversifyTimes\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1,2,3\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + diversifyTimes);
        }
        int times = Integer.parseInt(diversifyTimes);
        String regStr = "^[0-9a-fA-F]+$";
        switch (times) {
            case 0: {
                break;
            }
            case 1: {
                if (diversifyFactor1 == null) {
                    throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e3a1\u65f6\uff0cdiversifyFactor1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!diversifyFactor1.matches(regStr)) {
                    throw new InvalidArgumentException("\u5206\u6563\u56e0\u5b50\u5fc5\u987b\u4e3a16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
                }
                if (diversifyFactor1.length() == 32) break;
                throw new InvalidArgumentException("\u5206\u6563\u56e0\u5b50\u957f\u5ea6\u5e94\u4e3a32\uff0c\u5b9e\u9645\u4f20\u5165\u957f\u5ea6\uff1a" + diversifyFactor1.length());
            }
            case 2: {
                if (diversifyFactor1 == null) {
                    throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e3a2\u65f6\uff0cdiversifyFactor1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (diversifyFactor2 == null) {
                    throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e3a2\u65f6\uff0cdiversifyFactor2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!diversifyFactor1.matches(regStr) || !diversifyFactor2.matches(regStr)) {
                    throw new InvalidArgumentException("\u5206\u6563\u56e0\u5b50\u5fc5\u987b\u4e3a16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
                }
                if (diversifyFactor1.length() == 32 && diversifyFactor2.length() == 32) break;
                throw new InvalidArgumentException("\u5206\u6563\u56e0\u5b50\u957f\u5ea6\u5e94\u4e3a32\uff0c\u5b9e\u9645\u4f20\u5165\u957f\u5ea6\uff1a" + diversifyFactor1.length() + "," + diversifyFactor2.length());
            }
            case 3: {
                if (diversifyFactor1 == null) {
                    throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e3a3\u65f6\uff0cdiversifyFactor1\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (diversifyFactor2 == null) {
                    throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e3a3\u65f6\uff0cdiversifyFactor2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (diversifyFactor3 == null) {
                    throw new NullArgumentException("\u5206\u6563\u6b21\u6570diversifyTimes\u4e3a3\u65f6\uff0cdiversifyFactor3\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (!(diversifyFactor1.matches(regStr) && diversifyFactor2.matches(regStr) && diversifyFactor3.matches(regStr))) {
                    throw new InvalidArgumentException("\u5206\u6563\u56e0\u5b50\u5fc5\u987b\u4e3a16\u8fdb\u5236\u5b57\u7b26\u4e32\uff01");
                }
                if (diversifyFactor1.length() == 32 && diversifyFactor2.length() == 32 && diversifyFactor3.length() == 32) break;
                throw new InvalidArgumentException("\u5206\u6563\u56e0\u5b50\u957f\u5ea6\u5e94\u4e3a32\uff0c\u5b9e\u9645\u4f20\u5165\u957f\u5ea6\uff1a" + diversifyFactor1.length() + "," + diversifyFactor2.length() + "," + diversifyFactor3.length());
            }
        }
    }

    public static void checkGenMode(String genMode, String cryptographGroup, String keyIndex) {
        if (genMode == null) {
            throw new NullArgumentException("\u751f\u6210\u65b9\u5f0fgenMode\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"0".equals(genMode) && !"1".equals(genMode)) {
            throw new InvalidArgumentException("genMode\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30100,1\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + genMode);
        }
        int gMode = Integer.parseInt(genMode);
        switch (gMode) {
            case 0: {
                break;
            }
            case 1: {
                if (cryptographGroup == null) {
                    throw new NullArgumentException("\u751f\u6210\u65b9\u5f0fgenMode\u4e3a1\u65f6\uff0ccryptographGroup\u4e0d\u80fd\u4e3a\u7a7a\uff01");
                }
                if (keyIndex != null) break;
                throw new NullArgumentException("\u751f\u6210\u65b9\u5f0fgenMode\u4e3a1\u65f6\uff0ckeyIndex\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }

    public static void checkEncType(String encType, String encKeyId, String pubKey) {
        if (encType == null) {
            throw new NullArgumentException("\u5bc6\u94a5\u7f16\u53f7\u5206\u53d1\u52a0\u5bc6\u65b9\u5f0fencType\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (!"1".equals(encType) && !"2".equals(encType)) {
            throw new InvalidArgumentException("encType\u73b0\u5728\u652f\u6301\u7684\u503c\u4e3a\u30101,2\u3011\uff0c\u8f93\u5165\u503c\u4e3a\uff1a" + encType);
        }
        int eType = Integer.parseInt(encType);
        switch (eType) {
            case 1: {
                if (encKeyId != null) break;
                throw new NullArgumentException("\u5bc6\u94a5\u7f16\u53f7\u5206\u53d1\u52a0\u5bc6\u65b9\u5f0fencType\u4e3a1\u65f6\uff0cencKeyId\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            case 2: {
                if (pubKey != null) break;
                throw new NullArgumentException("\u5bc6\u94a5\u7f16\u53f7\u5206\u53d1\u52a0\u5bc6\u65b9\u5f0fencType\u4e3a2\u65f6\uff0cpubKey\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
        }
    }
}

