/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.pkcs.bc;

import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.pkcs.PKCS12PBEParams;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.operator.MacCalculator;
import cn.org.bjca.gaia.operator.OperatorCreationException;
import cn.org.bjca.gaia.operator.bc.BcDigestProvider;
import cn.org.bjca.gaia.pkcs.PKCS12MacCalculatorBuilder;
import cn.org.bjca.gaia.pkcs.PKCS12MacCalculatorBuilderProvider;
import cn.org.bjca.gaia.pkcs.bc.PKCS12PBEUtils;

public class BcPKCS12MacCalculatorBuilderProvider
implements PKCS12MacCalculatorBuilderProvider {
    private BcDigestProvider digestProvider;

    public BcPKCS12MacCalculatorBuilderProvider(BcDigestProvider digestProvider) {
        this.digestProvider = digestProvider;
    }

    @Override
    public PKCS12MacCalculatorBuilder get(final AlgorithmIdentifier algorithmIdentifier) {
        return new PKCS12MacCalculatorBuilder(){

            @Override
            public MacCalculator build(char[] password) throws OperatorCreationException {
                PKCS12PBEParams pbeParams = PKCS12PBEParams.getInstance(algorithmIdentifier.getParameters());
                return PKCS12PBEUtils.createMacCalculator(algorithmIdentifier.getAlgorithm(), BcPKCS12MacCalculatorBuilderProvider.this.digestProvider.get(algorithmIdentifier), pbeParams, password);
            }

            @Override
            public AlgorithmIdentifier getDigestAlgorithmIdentifier() {
                return new AlgorithmIdentifier(algorithmIdentifier.getAlgorithm(), DERNull.INSTANCE);
            }
        };
    }
}

