/*
 * Decompiled with CFR 0.152.
 */
package cn.org.bjca.gaia.jce.provider;

import cn.org.bjca.gaia.asn1.ASN1Object;
import cn.org.bjca.gaia.asn1.ASN1ObjectIdentifier;
import cn.org.bjca.gaia.asn1.ASN1OctetString;
import cn.org.bjca.gaia.asn1.ASN1Primitive;
import cn.org.bjca.gaia.asn1.ASN1Sequence;
import cn.org.bjca.gaia.asn1.DERBitString;
import cn.org.bjca.gaia.asn1.DERNull;
import cn.org.bjca.gaia.asn1.DEROctetString;
import cn.org.bjca.gaia.asn1.cryptopro.CryptoProObjectIdentifiers;
import cn.org.bjca.gaia.asn1.cryptopro.ECGOST3410NamedCurves;
import cn.org.bjca.gaia.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import cn.org.bjca.gaia.asn1.x509.AlgorithmIdentifier;
import cn.org.bjca.gaia.asn1.x509.SubjectPublicKeyInfo;
import cn.org.bjca.gaia.asn1.x9.X962Parameters;
import cn.org.bjca.gaia.asn1.x9.X9ECParameters;
import cn.org.bjca.gaia.asn1.x9.X9ECPoint;
import cn.org.bjca.gaia.asn1.x9.X9IntegerConverter;
import cn.org.bjca.gaia.asn1.x9.X9ObjectIdentifiers;
import cn.org.bjca.gaia.crypto.params.ECDomainParameters;
import cn.org.bjca.gaia.crypto.params.ECPublicKeyParameters;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.EC5Util;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.ECUtil;
import cn.org.bjca.gaia.jcajce.provider.asymmetric.util.KeyUtil;
import cn.org.bjca.gaia.jce.ECGOST3410NamedCurveTable;
import cn.org.bjca.gaia.jce.interfaces.ECPointEncoder;
import cn.org.bjca.gaia.jce.provider.BJCAJEProvider;
import cn.org.bjca.gaia.jce.spec.ECNamedCurveParameterSpec;
import cn.org.bjca.gaia.jce.spec.ECNamedCurveSpec;
import cn.org.bjca.gaia.jce.spec.ECPublicKeySpec;
import cn.org.bjca.gaia.math.ec.ECCurve;
import cn.org.bjca.gaia.math.ec.ECPoint;
import cn.org.bjca.gaia.util.Strings;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.EllipticCurve;

public class JCEECPublicKey
implements ECPublicKey,
cn.org.bjca.gaia.jce.interfaces.ECPublicKey,
ECPointEncoder {
    private String algorithm = "EC";
    private ECPoint q;
    private ECParameterSpec ecSpec;
    private boolean withCompression;
    private GOST3410PublicKeyAlgParameters gostParams;

    public JCEECPublicKey(String algorithm, JCEECPublicKey key) {
        this.algorithm = algorithm;
        this.q = key.q;
        this.ecSpec = key.ecSpec;
        this.withCompression = key.withCompression;
        this.gostParams = key.gostParams;
    }

    public JCEECPublicKey(String algorithm, java.security.spec.ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.ecSpec = spec.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, spec.getW(), false);
    }

    public JCEECPublicKey(String algorithm, ECPublicKeySpec spec) {
        this.algorithm = algorithm;
        this.q = spec.getQ();
        if (spec.getParams() != null) {
            ECCurve curve = spec.getParams().getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, spec.getParams().getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec.getParams());
        } else {
            if (this.q.getCurve() == null) {
                cn.org.bjca.gaia.jce.spec.ECParameterSpec s = BJCAJEProvider.CONFIGURATION.getEcImplicitlyCa();
                this.q = s.getCurve().createPoint(this.q.getAffineXCoord().toBigInteger(), this.q.getAffineYCoord().toBigInteger(), false);
            }
            this.ecSpec = null;
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params, ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (spec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, dp);
        } else {
            this.ecSpec = spec;
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params, cn.org.bjca.gaia.jce.spec.ECParameterSpec spec) {
        ECDomainParameters dp = params.getParameters();
        this.algorithm = algorithm;
        this.q = params.getQ();
        if (spec == null) {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(dp.getCurve(), dp.getSeed());
            this.ecSpec = this.createSpec(ellipticCurve, dp);
        } else {
            EllipticCurve ellipticCurve = EC5Util.convertCurve(spec.getCurve(), spec.getSeed());
            this.ecSpec = EC5Util.convertSpec(ellipticCurve, spec);
        }
    }

    public JCEECPublicKey(String algorithm, ECPublicKeyParameters params) {
        this.algorithm = algorithm;
        this.q = params.getQ();
        this.ecSpec = null;
    }

    private ECParameterSpec createSpec(EllipticCurve ellipticCurve, ECDomainParameters dp) {
        return new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(dp.getG()), dp.getN(), dp.getH().intValue());
    }

    public JCEECPublicKey(ECPublicKey key) {
        this.algorithm = key.getAlgorithm();
        this.ecSpec = key.getParams();
        this.q = EC5Util.convertPoint(this.ecSpec, key.getW(), false);
    }

    JCEECPublicKey(SubjectPublicKeyInfo info) {
        this.populateFromPubKeyInfo(info);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo info) {
        if (info.getAlgorithmId().getAlgorithm().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            ASN1OctetString key;
            DERBitString bits = info.getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                key = (ASN1OctetString)ASN1Primitive.fromByteArray(bits.getBytes());
            }
            catch (IOException ex) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] keyEnc = key.getOctets();
            byte[] x9Encoding = new byte[65];
            x9Encoding[0] = 4;
            for (int i = 1; i <= 32; ++i) {
                x9Encoding[i] = keyEnc[32 - i];
                x9Encoding[i + 32] = keyEnc[64 - i];
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)info.getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec spec = ECGOST3410NamedCurveTable.getParameterSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            ECCurve curve = spec.getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, spec.getSeed());
            this.q = curve.decodePoint(x9Encoding);
            this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()), ellipticCurve, EC5Util.convertPoint(spec.getG()), spec.getN(), spec.getH());
        } else {
            int qLength;
            ECCurve curve;
            X962Parameters params = new X962Parameters((ASN1Primitive)info.getAlgorithmId().getParameters());
            if (params.isNamedCurve()) {
                ASN1ObjectIdentifier oid = (ASN1ObjectIdentifier)params.getParameters();
                X9ECParameters ecP = ECUtil.getNamedCurveByOid(oid);
                curve = ecP.getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
                this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName(oid), ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), ecP.getH());
            } else if (params.isImplicitlyCA()) {
                this.ecSpec = null;
                curve = BJCAJEProvider.CONFIGURATION.getEcImplicitlyCa().getCurve();
            } else {
                X9ECParameters ecP = X9ECParameters.getInstance(params.getParameters());
                curve = ecP.getCurve();
                EllipticCurve ellipticCurve = EC5Util.convertCurve(curve, ecP.getSeed());
                this.ecSpec = new ECParameterSpec(ellipticCurve, EC5Util.convertPoint(ecP.getG()), ecP.getN(), ecP.getH().intValue());
            }
            DERBitString bits = info.getPublicKeyData();
            byte[] data = bits.getBytes();
            ASN1OctetString key = new DEROctetString(data);
            if (data[0] == 4 && data[1] == data.length - 2 && (data[2] == 2 || data[2] == 3) && (qLength = new X9IntegerConverter().getByteLength(curve)) >= data.length - 3) {
                try {
                    key = (ASN1OctetString)ASN1Primitive.fromByteArray(data);
                }
                catch (IOException ex) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
            X9ECPoint derQ = new X9ECPoint(curve, key);
            this.q = derQ.getPoint();
        }
    }

    @Override
    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public String getFormat() {
        return "X.509";
    }

    @Override
    public byte[] getEncoded() {
        SubjectPublicKeyInfo info;
        if (this.algorithm.equals("ECGOST3410")) {
            ASN1Object params;
            if (this.gostParams != null) {
                params = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveSpec) {
                params = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                ECCurve curve = EC5Util.convertCurve(this.ecSpec.getCurve());
                X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint(curve, this.ecSpec.getGenerator(), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                params = new X962Parameters(ecP);
            }
            BigInteger bX = this.q.getAffineXCoord().toBigInteger();
            BigInteger bY = this.q.getAffineYCoord().toBigInteger();
            byte[] encKey = new byte[64];
            this.extractBytes(encKey, 0, bX);
            this.extractBytes(encKey, 32, bY);
            try {
                info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, params), new DEROctetString(encKey));
            }
            catch (IOException e) {
                return null;
            }
        } else {
            ECCurve curve;
            X962Parameters params;
            if (this.ecSpec instanceof ECNamedCurveSpec) {
                ASN1ObjectIdentifier curveOid = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.ecSpec).getName());
                if (curveOid == null) {
                    curveOid = new ASN1ObjectIdentifier(((ECNamedCurveSpec)this.ecSpec).getName());
                }
                params = new X962Parameters(curveOid);
            } else if (this.ecSpec == null) {
                params = new X962Parameters(DERNull.INSTANCE);
            } else {
                curve = EC5Util.convertCurve(this.ecSpec.getCurve());
                X9ECParameters ecP = new X9ECParameters(curve, EC5Util.convertPoint(curve, this.ecSpec.getGenerator(), this.withCompression), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                params = new X962Parameters(ecP);
            }
            curve = this.engineGetQ().getCurve();
            ASN1OctetString p = (ASN1OctetString)new X9ECPoint(curve.createPoint(this.getQ().getAffineXCoord().toBigInteger(), this.getQ().getAffineYCoord().toBigInteger(), this.withCompression)).toASN1Primitive();
            info = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, params), p.getOctets());
        }
        return KeyUtil.getEncodedSubjectPublicKeyInfo(info);
    }

    private void extractBytes(byte[] encKey, int offSet, BigInteger bI) {
        byte[] val = bI.toByteArray();
        if (val.length < 32) {
            byte[] tmp = new byte[32];
            System.arraycopy(val, 0, tmp, tmp.length - val.length, val.length);
            val = tmp;
        }
        for (int i = 0; i != 32; ++i) {
            encKey[offSet + i] = val[val.length - 1 - i];
        }
    }

    @Override
    public ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public cn.org.bjca.gaia.jce.spec.ECParameterSpec getParameters() {
        if (this.ecSpec == null) {
            return null;
        }
        return EC5Util.convertSpec(this.ecSpec, this.withCompression);
    }

    @Override
    public java.security.spec.ECPoint getW() {
        return EC5Util.convertPoint(this.q);
    }

    @Override
    public ECPoint getQ() {
        if (this.ecSpec == null) {
            return this.q.getDetachedPoint();
        }
        return this.q;
    }

    public ECPoint engineGetQ() {
        return this.q;
    }

    cn.org.bjca.gaia.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec, this.withCompression);
        }
        return BJCAJEProvider.CONFIGURATION.getEcImplicitlyCa();
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        String nl = Strings.lineSeparator();
        buf.append("EC Public Key").append(nl);
        buf.append("            X: ").append(this.q.getAffineXCoord().toBigInteger().toString(16)).append(nl);
        buf.append("            Y: ").append(this.q.getAffineYCoord().toBigInteger().toString(16)).append(nl);
        return buf.toString();
    }

    @Override
    public void setPointFormat(String style) {
        this.withCompression = !"UNCOMPRESSED".equalsIgnoreCase(style);
    }

    public boolean equals(Object o) {
        if (!(o instanceof JCEECPublicKey)) {
            return false;
        }
        JCEECPublicKey other = (JCEECPublicKey)o;
        return this.engineGetQ().equals(other.engineGetQ()) && this.engineGetSpec().equals(other.engineGetSpec());
    }

    public int hashCode() {
        return this.engineGetQ().hashCode() ^ this.engineGetSpec().hashCode();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        byte[] enc = (byte[])in.readObject();
        this.populateFromPubKeyInfo(SubjectPublicKeyInfo.getInstance(ASN1Primitive.fromByteArray(enc)));
        this.algorithm = (String)in.readObject();
        this.withCompression = in.readBoolean();
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(this.getEncoded());
        out.writeObject(this.algorithm);
        out.writeBoolean(this.withCompression);
    }
}

